<?php

  date_default_timezone_set('Asia/Kolkata');


class getFunctions{


    private $conn;
    
  
    function __construct() {
       
    
        require_once 'DB_Connect.php';
        require_once 'Automation.php';
        require_once 'getFunctionsParents.php';
        require_once ('Common.php');
        require_once ('getFunctionsCRM.php');
          
               // connecting to database
        $db = new Db_Connect();
       
        $this->conn = $db->connect();  
        mysqli_set_charset($this->conn,'utf8');  
        /*mysqli_query('SET character_set_results=utf8');
        mysqli_query('SET names=utf8');
        mysqli_query('SET character_set_client=utf8');
        mysqli_query('SET character_set_connection=utf8');
        mysqli_query('SET character_set_results=utf8');
        mysqli_query('SET collation_connection=utf8_general_ci'); */  
    }

public function getCurrentAppVersion($current_version_code,$is_in_app_call,$panel)
{

    if($is_in_app_call=='true')
    {
        
        if($panel=='Admin')
        {
            $sql="SELECT `version_code`,`version_name`,`update_mode` FROM `tm_app_version` WHERE `version_code` = (select max(`version_code`) from `tm_app_version` WHERE `in_app_update`='1' AND `update_admin`='1')";
           $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current app version: '.mysqli_error($this->conn));
                                     
             while ($row = $result->fetch_assoc()) {
                $version_code=$row['version_code'];
                $row['update_mode']=$this->getUpdateMode($version_code,$current_version_code);
                $version_details=$this->getAppVersionDetails($version_code);
                $row['version_details']=$version_details;
            
                $data[] = $row;
           }
        }

        if($panel=='Clerk')
        {
            $sql="SELECT `version_code`,`version_name`,`update_mode` FROM `tm_app_version` WHERE `version_code` = (select max(`version_code`) from `tm_app_version` WHERE `in_app_update`='1' AND `update_clerk`='1')";
           $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current app version: '.mysqli_error($this->conn));
                                     
             while ($row = $result->fetch_assoc()) {
                $version_code=$row['version_code'];
                $row['update_mode']=$this->getUpdateMode($version_code,$current_version_code);
                $version_details=$this->getAppVersionDetails($version_code);
                $row['version_details']=$version_details;
            
                $data[] = $row;
           }
        }
        if($panel=='Teacher')
        {
            $sql="SELECT `version_code`,`version_name`,`update_mode` FROM `tm_app_version` WHERE `version_code` = (select max(`version_code`) from `tm_app_version` WHERE `in_app_update`='1' AND `update_teacher`='1')";
           $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current app version: '.mysqli_error($this->conn));
                                     
             while ($row = $result->fetch_assoc()) {
                $version_code=$row['version_code'];
                $row['update_mode']=$this->getUpdateMode($version_code,$current_version_code);
                $version_details=$this->getAppVersionDetails($version_code);
                $row['version_details']=$version_details;
            
                $data[] = $row;
           }
        }
        if($panel=='Parents')
        {
            $sql="SELECT `version_code`,`version_name`,`update_mode` FROM `tm_app_version` WHERE `version_code` = (select max(`version_code`) from `tm_app_version` WHERE `in_app_update`='1' AND `update_parents`='1')";
           $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current app version: '.mysqli_error($this->conn));
                                     
             while ($row = $result->fetch_assoc()) {
                $version_code=$row['version_code'];
                $row['update_mode']=$this->getUpdateMode($version_code,$current_version_code);
                $version_details=$this->getAppVersionDetails($version_code);
                $row['version_details']=$version_details;
            
                $data[] = $row;
           }
        }
        return $data;
    }
    else{
         $sql="SELECT `version_code`,`version_name`,`update_mode` FROM `tm_app_version` WHERE `version_code` = (select max(`version_code`) from `tm_app_version` WHERE `full_update`='1')";
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current app version: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $version_code=$row['version_code'];
                $row['update_mode']=$this->getUpdateMode($version_code,$current_version_code);
                $version_details=$this->getAppVersionDetails($version_code);
                $row['version_details']=$version_details;
            
                $data[] = $row;
         }
     
       return $data; 
    }

       
}
public function getAppVersionDetails($version_code)
{

     $sql="SELECT `version_code`,`version_title`,`version_description` FROM `tm_app_version_details` WHERE `version_code`='$version_code' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current app version details: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getUpdateMode($version_code,$current_version_code)
{

     $sql="SELECT `update_mode` FROM `tm_app_version` WHERE (`version_code`>'$current_version_code' AND `version_code`<='$version_code') AND `update_mode`='Required'";
     //echo $sql;
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  update mode: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }
         if($data)
         {
            return 'Required';
         }
         else{
            return 'Recommended';
         }

         
}

public function getAdminMainDashboard($school_code,$system_code,$CurrentVersionCode)
{

    $is_in_app_call='true';
    $panel="Admin";
    
    $AdminModules=$this->getAllAdminModules($school_code,$system_code);
    $dashboard['AdminModules']=$AdminModules;

    $SchoolDetails=$this->getSchoolDetails($school_code);
    $dashboard['SchoolDetails']=$SchoolDetails;

    $ClerkAllActiveModules=$this->getClerkAllActiveModules($system_code);
    $dashboard['ClerkAllActiveModules']=$ClerkAllActiveModules;

    $CurrentSession=$this->getCurrentSessionName($school_code);
    $dashboard['CurrentSession']=$CurrentSession;

    $AdsControl=$this->getAdsControl($school_code,$panel);
    $dashboard['AdsControl']=$AdsControl;

    $Announcement=$this->getAnnouncement($school_code,$panel);
    $dashboard['Announcement']=$Announcement;

    $app_update=$this->getCurrentAppVersion($CurrentVersionCode,$is_in_app_call,$panel);
    $dashboard['app_update']=$app_update;

    $product_account=$this->getProductAccountStatus($school_code,$system_code);
    $dashboard['product_account']=$product_account;



    return $dashboard;
   
}

public function getProductAccountStatus($school_code,$system_code)
{
     $reg_date=$this->getSchoolRegistrationDate($school_code);
     $reg_date2=date("Y-m-d", strtotime($reg_date) );
     $today=date('Y-m-d');
     
     
    $sql="SELECT `school_code`,`product_code`,`system_code`,`product_status`,`product_status_name` FROM `tm_crm_school_product_account` WHERE `school_code` = '$school_code' AND `system_code` ='$system_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  product account status : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
     if($data)
     {
        if($data[0]['product_status']=='1')
        {
             $product_code=$data[0]['product_code'];
             $demo_data=$this->getSchoolProductDemoData($school_code,$product_code);
             $demo_start_date=$demo_data[0]['demo_start_date'];
             $demo_days=$demo_data[0]['demo_days'];

             $date1 = new DateTime($demo_start_date);
             $date2 = new DateTime($today);

             $days =$date1->diff($date2)->format("%a");
             //echo $days.'/';
             if($days>$demo_days)
             {
                $data[0]['demo_service']='0';
             }
             else{
                $data[0]['demo_service']='1';
                $data[0]['demo_remaining_days']=$demo_days-$days;
             }
  
             return $data;

        }
        else if($data[0]['product_status']=='2')
        {
             return $data;
        }else{
             return $data;
        }

     }  
     else{
            if($system_code=='11')
            {
                $product_code='TM001';
            }
            else if($system_code=='12')
            {
                $product_code='TM004';
            }

             $sql="INSERT INTO `tm_crm_school_product_account` (`id`, `school_code`, `product_code`, `system_code`, `product_status`, `product_status_name`, `date_added`, `status`)
              VALUES (NULL, '$school_code', '$product_code', '$system_code', '1', 'Demo', CURRENT_TIMESTAMP, 'Active')";

                $result=mysqli_query($this->conn,$sql)or die ('Error in Adding school product account :'.mysqli_error($this->conn));

                 $sql2="INSERT INTO `tm_crm_school_product_demo` (`id`, `school_code`, `product_code`, `demo_start_date`, `demo_days`, `date_added`, `status`) 
                 VALUES (NULL, '$school_code', '$product_code', '$today', '15', CURRENT_TIMESTAMP, 'Active')";

                $result2=mysqli_query($this->conn,$sql2)or die ('Error in Adding school product demo :'.mysqli_error($this->conn));

                if($result2)
                {
                      $sql="SELECT `school_code`,`product_code`,`system_code`,`product_status`,`product_status_name` FROM `tm_crm_school_product_account` WHERE `school_code` = '$school_code' AND `system_code` ='$system_code' AND `status`='Active'";
                 
                     $result=mysqli_query($this->conn,$sql)or die ('Error in getting  product account status : '.mysqli_error($this->conn));
                             
                             while ($row = $result->fetch_assoc()) {
                                    $data[] = $row;
                             }
                     $product_code=$data[0]['product_code'];
                     $demo_data=$this->getSchoolProductDemoData($school_code,$product_code);
                     $demo_start_date=$demo_data[0]['demo_start_date'];
                     $demo_days=$demo_data[0]['demo_days'];

                     $date1 = new DateTime($demo_start_date);
                     $date2 = new DateTime($today);

                     $days =$date1->diff($date2)->format("%a");
                     //echo $days.'/';
                     if($days>$demo_days)
                     {
                        $data[0]['demo_service']='0';
                     }
                     else{
                        $data[0]['demo_service']='1';
                        $data[0]['demo_remaining_days']=$demo_days-$days;
                     }
          
                     return $data;
                }


     }          
    

}
public function getSchoolRegistrationDate($school_code)
{
     $sql="SELECT `date_added` FROM `tm_school_master` WHERE `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting School Registration Date : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }

    return $data[0]['date_added'];
}
public function getSchoolProductDemoData($school_code,$product_code)
{
     $sql="SELECT `school_code`,`product_code`,`demo_start_date`,`demo_days` FROM `tm_crm_school_product_demo` WHERE `school_code`='$school_code' AND `product_code`='$product_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting SchoolProductDemoData : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }

    return $data;
}

public function getStaffLoginFromCrm($user_id,$password)
{
    $server_name=$_SERVER['SERVER_NAME'];
     $getParent=new getFunctionsParents();
     $sql="SELECT a.`staff_id`,a.`school_code`,b.`school_name`,a.`staff_name`,a.`staff_phone`,a.`staff_email`,a.`password`,a.`joining_date`,a.`staff_role`,a.`login_type`,a.`staff_image_path` FROM `tm_staff_master` a LEFT JOIN `tm_school_master` b ON a.`school_code`=b.`school_code` WHERE (a.`staff_id`='$user_id' OR a.`staff_phone`='$user_id' OR a.`staff_email`='$user_id') AND a.`password`='$password' AND a.`status`!='InActive' AND a.`status`!='Delisted'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff login : '.mysqli_error($this->conn));
                 
            $num_rows = mysqli_num_rows($result);
            if($num_rows!=0)   
            {
                while ($row = $result->fetch_assoc()) {

                         $staff_image_path=$row['staff_image_path'];
                         $img='http://'.$server_name."/".$staff_image_path;
                         $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
               
                        $data[] = $row;
                 }
                 
                 return $data;

            } 
            else{
                
                $data=$getParent->getStudentLogin($user_id, $password);
                
                return $data;

            } 
                 

}


public function getStaffLogin($user_id,$password)
{
    $server_name=$_SERVER['SERVER_NAME'];
     $getParent=new getFunctionsParents();
     $sql="SELECT a.`staff_id`,a.`school_code`,b.`school_name`,a.`staff_name`,a.`staff_phone`,a.`staff_email`,a.`password`,a.`joining_date`,a.`staff_role`,a.`login_type`,a.`staff_image_path` FROM `tm_staff_master` a LEFT JOIN `tm_school_master` b ON a.`school_code`=b.`school_code` WHERE (a.`staff_id`='$user_id' OR a.`staff_phone`='$user_id' OR a.`staff_email`='$user_id') AND a.`password`='$password' AND a.`status`!='InActive' AND a.`status`!='Delisted'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff login : '.mysqli_error($this->conn));
                 
            $num_rows = mysqli_num_rows($result);
            if($num_rows!=0)   
            {
                while ($row = $result->fetch_assoc()) {

                         $staff_image_path=$row['staff_image_path'];
                         $img='http://'.$server_name."/".$staff_image_path;
                         $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
               
                        $data[] = $row;
                 }
                 
                 if($data)
                 {
                    $school_code=$data[0]['school_code'];
                    $login_type=$data[0]['login_type'];
                    $this->updateLoginLogs($school_code,$user_id,$login_type);
                 }
                 return $data;

            } 
            else{
                
                $data=$getParent->getStudentLogin($user_id, $password);
                if($data)
                {
                   $school_code=$data[0]['school_code'];
                   $login_type="Student";
                   $this->updateLoginLogs($school_code,$user_id,$login_type); 
                }
                
                return $data;

            } 
                 

}
public function getStaffLoginPremium($user_id,$password,$application_id,$system_code)
{

$server_name=$_SERVER['SERVER_NAME'];
if($system_code=='11')
 {
    $school_code=$this->getSchoolCode($application_id);
    $getParent=new getFunctionsParents();
    $sql="SELECT `staff_id`,`school_code`,`staff_name`,`staff_phone`,`staff_email`,`password`,`joining_date`,`staff_role`,`login_type`,`staff_image_path` FROM `tm_staff_master` WHERE (`staff_id`='$user_id' OR `staff_phone`='$user_id' OR `staff_email`='$user_id') AND `password`='$password' AND `status`!='InActive' AND `status`!='Delisted' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff login : '.mysqli_error($this->conn));
                 
            $num_rows = mysqli_num_rows($result);
            if($num_rows!=0)   
            {
                while ($row = $result->fetch_assoc()) {
                        $staff_image_path=$row['staff_image_path'];
                         $img='http://'.$server_name."/".$staff_image_path;
                         $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
               
                        $data[] = $row;
                 }
                 
                 if($data)
                 {
                    $school_code=$data[0]['school_code'];
                    $login_type=$data[0]['login_type'];
                    $this->updateLoginLogs($school_code,$user_id,$login_type);
                 }
                 return $data;

            } 
            else{
                
                $data=$getParent->getStudentLogin($user_id, $password,$school_code);
                if($data)
                {
                   $school_code=$data[0]['school_code'];
                   $login_type="Student";
                   $this->updateLoginLogs($school_code,$user_id,$login_type); 
                }
                
                return $data;

            }
}
else{
    $getParent=new getFunctionsParents();
    $sql="SELECT `staff_id`,`school_code`,`staff_name`,`staff_phone`,`staff_email`,`password`,`joining_date`,`staff_role`,`login_type`,`staff_image_path` FROM `tm_staff_master` WHERE (`staff_id`='$user_id' OR `staff_phone`='$user_id' OR `staff_email`='$user_id') AND `password`='$password' AND `status`!='InActive' AND `status`!='Delisted'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff login : '.mysqli_error($this->conn));
                 
            $num_rows = mysqli_num_rows($result);
            if($num_rows!=0)   
            {
                while ($row = $result->fetch_assoc()) {
                         $staff_image_path=$row['staff_image_path'];
                         $img='http://'.$server_name."/".$staff_image_path;
                         $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
               
                        $data[] = $row;
                 }
                 
                 if($data)
                 {
                    $school_code=$data[0]['school_code'];
                    $login_type=$data[0]['login_type'];
                    $this->updateLoginLogs($school_code,$user_id,$login_type);
                 }
                 return $data;

            } 
           

     }          
                 

}
public function getSchoolCode($application_id)
{
    $sql="SELECT `school_code` FROM `tm_school_master` WHERE `application_id`='$application_id'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school code: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['school_code'];

}

public function updateLoginLogs($school_code,$user_id,$login_type)
{
    $sql="SELECT `school_code`,`user_id`,`login_type`,`login_date` FROM `tm_crm_login_logs` WHERE `school_code`='$school_code' AND `user_id`='$user_id' AND `status`='Active' AND `isTrashed`='0'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  login logs  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        if($data)
        {
            $sql="UPDATE `tm_crm_login_logs` SET `login_date` =CURRENT_TIMESTAMP WHERE `school_code`='$school_code' AND `user_id`='$user_id'";
     
             $result=mysqli_query($this->conn,$sql)or die ('Error in updating  login logs  : '.mysqli_error($this->conn));
                 
        }
        else{
            $sql="INSERT INTO `tm_crm_login_logs` (`id`, `school_code`, `user_id`, `login_type`, `login_date`, `date_added`, `status`, `isTrashed`, `trashed_date`) 
               VALUES (NULL, '$school_code', '$user_id', '$login_type', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'Active', '0', NULL)";
     
             $result=mysqli_query($this->conn,$sql)or die ('Error in inserting  login logs  : '.mysqli_error($this->conn));
                 
        }         
        
}

public function getClassSectionStudents($class_id,$section_id,$session_id,$school_code)
{
    $sql="SELECT * FROM `tm_student_class` WHERE `class_id`='$class_id' AND `section_id`='$section_id'AND `session_id`='$session_id' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students from class : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getClassStudents($class_id,$session_id,$school_code)
{
    $sql="SELECT * FROM `tm_student_class` WHERE `class_id`='$class_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students from class : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getClassStudentsReAdmission($class_id,$session_id,$school_code)
{
    $sql="SELECT * FROM `tm_student_class` WHERE `class_id`='$class_id' AND `session_id`='$session_id' AND `admission_type_id`='ADMTYPE01' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students from class : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getClassStudentsNewAdmission($class_id,$session_id,$school_code)
{
    $sql="SELECT * FROM `tm_student_class` WHERE `class_id`='$class_id' AND `session_id`='$session_id' AND `admission_type_id`='ADMTYPE02' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students from class : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}

public function getClassAttendenceStatusAndBoardMedium($session_id,$days,$school_code)
{
    $board=$this->getBoard($school_code,$session_id);
    $data['board']=$board;

    $medium=$this->getMedium($school_code,$session_id);
    $data['medium']=$medium;

    $class=$this->getClassAttendenceStatus($session_id,$days,$school_code);
    $data['ClassAttendenceStatus']=$class;
    

    return $data;

}


public function getClassAttendenceStatus($session_id,$days,$school_code)
{
    
    $cur_date=date('Y/m/d');
    $sql="SELECT `class_id`,`class_name`,`board_id`,`medium_id` FROM `tm_class` WHERE `status`='Active' AND `session_id`='$session_id' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   class : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        $class_name=$row['class_name'];
                        $class_id=$row['class_id'];
                        $section=$this->getClassSectionWithAttendanceStatus($class_id,$session_id,$cur_date,$days,$school_code);
                        if($section)
                        {
                        
                                 $row['section']=$section;
                        }
                        else{
                
                            $row['section']='No';
                            $section_id='No';
                                    
                            $attendence=$this->getClassAttendence($class_id,$section_id,$session_id,$cur_date,$days,$school_code);
                            $row['attendence']=$attendence;
                        }
                       



                        $data[] = $row;
                 }
        return $data;

}


public function getClassHomeWorkStatus($school_code)
{
    
    $session_id=$this->getCurrentSession($school_code);

     $sql="SELECT `class_id`,`class_name`,`board_id`,`medium_id` FROM `tm_class` WHERE `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   class : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        $class_name=$row['class_name'];
                        $class_id=$row['class_id'];
                        $section=$this->getClassSection($class_id,$session_id,$school_code);
                        if($section)
                        {
                                for ($i=0; $i<count($section) ; $i++) { 
                                    $section_id=$section[$i]['section_id'];
                                    
                                    $days='1';
                                    $cur_date=date('Y/m/d');
                                    $homework=$this->getClassHomework_ForDays($class_id,$section_id,$session_id,$current_date,$days,$school_code);
                                    $section[$i]['homework']=$homework;

                                }
                                 $row['section']=$section;
                        }
                        else{
                                 $row['section']='No';
                                        $section_id='No';
                                   
                                
                                    $days='1';
                                    $cur_date=date('Y/m/d');
                                    $homework=$this->getClassHomework_ForDays($class_id,$section_id,$session_id,$current_date,$days,$school_code);
                                    $row['homework']=$homework;
                        }
                       



                        $data[] = $row;
                 }
        return $data;

}

public function getSubjectCount($session_id,$class_id)
{

    $sql="SELECT `subject_id` FROM `tm_class_subject`  WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject count : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return count($data);

}

public function getCurrentSession($school_code)
{

    $sql="SELECT `session_id` FROM `tm_session` WHERE `status`='current' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current session : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['session_id'];

}
public function getCurrentSessionName($school_code)
{

    $sql="SELECT `session_id`,`session_name`,`start_date`,`end_date` FROM `tm_session` WHERE `status`='current' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current session name : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $session_id=$row['session_id'];
                        $total=$this->getTotalStudent_count($session_id,$school_code);
                        $row['total_student']=$total;
                        $data[] = $row;
                 }
        return $data;

}
public function getSessionName($session_id,$school_code)
{

    $sql="SELECT `session_name` FROM `tm_session` WHERE `session_id`='$session_id' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  session name : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                
                        $data[] = $row;
                 }
        return $data[0]['session_name'];

}

public function getAllSession($school_code)
{

    $sql="SELECT `session_id`,`session_name`,`start_date`,`end_date`,`status` FROM `tm_session` WHERE `school_code`='$school_code'  AND `status`!='InActive' ORDER BY `id` DESC ";
     
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  all session  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
  public function getPreviousSession($school_code)
    {
     
         $sql="SELECT * FROM (SELECT * FROM `tm_session` WHERE `school_code`='$school_code' ORDER BY Id DESC LIMIT 2) tbl1 ORDER BY Id LIMIT 1";
     
          $result=mysqli_query($this->conn,$sql)or die ('Error in getting  previous session: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                        $data[] = $row;
                 }
        
          return $data; 
     }
    public function getCurrentOrUpcomingSession($school_code)
    {
     
         $sql="SELECT * FROM (SELECT * FROM `tm_session` WHERE `school_code`='$school_code' ORDER BY Id DESC LIMIT 1) tbl1 ORDER BY Id LIMIT 1";
     
          $result=mysqli_query($this->conn,$sql)or die ('Error in getting  current or upcoming session: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                        $data[] = $row;
                 }
        
          return $data; 
     }

public function getClassSection($class_id,$session_id,$school_code)
{

$sql="SELECT a.`session_id`,a.`section_id`,a.`class_id`,b.`class_name`,a.`section_name` FROM  `tm_class_section` a LEFT JOIN (SELECT * FROM `tm_class` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`class_id`=b.`class_id` WHERE  a.`class_id` ='$class_id' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  section: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getClassSectionWithDetails($class_id,$session_id,$school_code)
{

$sql="SELECT a.`session_id`,a.`section_id`,a.`class_id`,b.`class_name`,a.`section_name` FROM  `tm_class_section` a LEFT JOIN (SELECT * FROM `tm_class` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`class_id`=b.`class_id` WHERE  a.`class_id` ='$class_id' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  section: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $section_id=$row['section_id'];
                        $student=$this->getStudentCount($class_id,$section_id,$session_id,$school_code);
                        $row['student']=$student;
                        $class_teacher_id=$this->getClassTeacher($class_id,$section_id,$session_id,$school_code);
                        $class_teacher_name=$this->getStaffName($class_teacher_id);
                        $row['class_teacher_id']=$class_teacher_id;
                        $row['class_teacher_name']=$class_teacher_name;
                        $data[] = $row;
                 }
        return $data;

}
public function getClassSectionWithAttendanceStatus($class_id,$session_id,$cur_date,$days,$school_code)
{

$sql="SELECT a.`session_id`,a.`section_id`,a.`class_id`,b.`class_name`,a.`section_name` FROM  `tm_class_section` a LEFT JOIN (SELECT * FROM `tm_class` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`class_id`=b.`class_id` WHERE  a.`class_id` ='$class_id' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  section: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $section_id=$row['section_id'];
                        $attendence=$this->getClassAttendence($class_id,$section_id,$session_id,$cur_date,$days,$school_code);
                        $row['attendence']=$attendence;
                        $data[] = $row;
                 }
        return $data;

}
public function getTotalStudent($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,b.`sr_admission_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path`,b.`status` FROM `tm_student_class`a LEFT JOIN  `tm_student_admission` b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;
                        $data[] = $row;
                 }
        return $data;

}

public function getCurrentStudent($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,a.`student_roll_no`,b.`sr_admission_no`,b.`password`,b.`stu_name` ,b.`gender`,b.`student_img_path`,b.`father_name`,b.`sr_admission_no`,b.`bloodgroup`,b.`religion`,b.`nationality`,b.`community`,b.`current_address`,b.`permanent_address`,b.`mother_name`,b.`email_id` FROM `tm_student_class`a LEFT JOIN  `tm_student_admission` b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;
                        $data[] = $row;
                 }
        return $data;

}
public function getStudentCount($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `student_enrollment_no` FROM `tm_student_class` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `status`!='InActive'  AND `school_code`='$school_code'";
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
    while ($row = $result->fetch_assoc()) {
                       
        $data[] = $row;
    }
    return COUNT($data);

}

public function getStudentByDate($class_id,$section_id,$date,$school_code)
{
     $session_id=$this->getSessionByDate($date,$school_code);
     $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,a.`student_roll_no`,b.`stu_name`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN `tm_student_admission`b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`registration_date` <='$date' AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";  
   // echo $sql;   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                         $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                        $student_enrollment_no=$row['student_enrollment_no'];
                        if($this->isStudentOnLeave($date,$student_enrollment_no,$school_code))
                        {

                            $row['OnLeave']="Yes";
                        }
                        else{
                            $row['OnLeave']="No";
                        }
                        $data[] = $row;
                 }
        return $data;       
        

}
public function getStudentByDateCount($class_id,$section_id,$date,$school_code)
{
     $session_id=$this->getSessionByDate($date,$school_code);
     $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no` FROM `tm_student_class`a WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`registration_date` <='$date'AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        
                        $data[] = $row;
                 }
        return COUNT($data);       
        

}


public function getSessionByDate($date,$school_code)
{

    $sql="SELECT `session_id` FROM `tm_session`  WHERE '$date' between `start_date`  AND `end_date` AND (`status`='Active' OR `status`='Current' OR `status`='Previous' OR `status`='Upcoming') AND `school_code`='$school_code'";
    
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   session by date: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['session_id'];

}
public function getClassAttendence($class_id,$section_id,$session_id,$current_date,$days,$school_code)
{
        unset($data);
        unset($result);
        unset($student);
       

        $sql="SELECT `attendence`,COUNT(*) AS total FROM `tm_student_attendence` WHERE  `class_id`='$class_id' AND `section_id`='$section_id'  AND `attendence_date`='$current_date'  AND `status`='Active' AND `school_code`='$school_code' GROUP BY`attendence`";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attendence : '.mysqli_error($this->conn));

        $data['attendence_date']=$current_date;
       
        
        $num_rows = mysqli_num_rows($result);
        //echo $num_rows . '<br />';

        if ($num_rows!==0) 
         {

                $data['status']="Taken";
                while ($row = $result->fetch_assoc()) {
                    
                        $data[$row['attendence']]=$row['total'];
                }
         }
         else{
            $isSunday=$this->isSunday($current_date);
            if($isSunday)
            {
                $data['status']="Sunday";
            }
            else if($this->isHoliday($current_date,$school_code))
            {
                   $data['status']="Holiday";         
            }
            else{
                $data['status']="Not Taken";
            }
            
         }
                
          $arr[0]=$data;
        return $arr;

}
public function getClassAttendence_ForDays($class_id,$section_id,$session_id,$current_date,$days,$school_code)
{
    unset($arr);
    for ($i=0; $i <$days ; $i++) { 
        $prev_date= date('Y-m-d', strtotime($current_date .-$i.' day'));
    
        

        unset($data);
        unset($result);
        unset($student);
       

         $sql="SELECT `attendence`,COUNT(*) AS total FROM `tm_student_attendence` WHERE  `class_id`='$class_id' AND `section_id`='$section_id'  AND `attendence_date`='$prev_date'  AND `status`='Active' AND `school_code`='$school_code' GROUP BY`attendence`";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attendence : '.mysqli_error($this->conn));

        $data['attendence_date']=$prev_date;
       
        
        $num_rows = mysqli_num_rows($result);
        //echo $num_rows . '<br />';

        if ($num_rows!==0) 
         {

                $data['status']="Taken";
                /*$student=$this->getStudentCount($class_id,$section_id,$session_id,$school_code);
                $data['student']=$student;

                $student_by_date=$this->getStudentByDateCount($class_id,$section_id,$prev_date,$school_code);
                $data['student_by_date']=$student_by_date;*/

                while ($row = $result->fetch_assoc()) {
                    
                        $data[$row['attendence']]=$row['total'];
                }
         }
         else{
            $isSunday=$this->isSunday($prev_date);
            if($isSunday)
            {
                $data['status']="Sunday";
            }
            else if($this->isHoliday($prev_date,$school_code))
            {
                   $data['status']="Holiday";         
            }
            else{
                $data['status']="Not Taken";
            }
            
         }
                
        $arr[$i]= $data;       
    }
     
 return $arr;

}


public function getClassHomework_ForDays($class_id,$section_id,$session_id,$current_date,$days,$school_code)
{

    for ($i=0; $i <$days ; $i++) { 
        
         $prev_date= date('Y-m-d', strtotime($current_date .-$i.' day'));
        

        unset($data);
        unset($subject);
        unset($result);
        unset($result_subject);
        
        $data['homework_date']=$prev_date;
    

        $sql="SELECT a.`subject_id`,b.`subject_name` FROM `tm_class_subject` a LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code' AND `status`='Active') b ON a.`subject_id`=b.`subject_id` WHERE a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
        //echo $sql;

              
         $result_subject=mysqli_query($this->conn,$sql)or die ('Error in getting  subject in home work : '.mysqli_error($this->conn));
          while ($row = $result_subject->fetch_assoc()) {
                    
                    $subject_id=$row['subject_id'];
                    //echo $subject_id;


                     $sql="SELECT `homework_id`,`home_work` FROM `tm_class_homework` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `homework_date`='$prev_date' AND `status`='Active' AND `school_code`='$school_code'";             
                     $result=mysqli_query($this->conn,$sql)or die ('Error in getting  homework : '.mysqli_error($this->conn));

                  
                    $num_rows = mysqli_num_rows($result);
                    if ($num_rows!==0) 
                     {

                            $row['status']="Assigned";
                     }
                     else{
                        $isSunday=$this->isSunday($prev_date);
                        if($isSunday)
                        {
                            $row['status']="Sunday";
                        }
                        else if($this->isHoliday($prev_date,$school_code))
                        {
                               $row['status']="Holiday";         
                        }
                        else{
                            $row['status']="Not Assigned";
                        }
                        
                     }
                     $subject[]=$row;
                                               
                }
                                           
            $data['subjects']=$subject;   
            $arr[]=$data;                           

    }
     
    
return $arr;
}
public function isSunday($date) {
    $weekDay = date('w', strtotime($date));
    return ($weekDay==0);
}
public function isHoliday($date,$school_code) {

    $session_id=$this->getSessionByDate($date,$school_code);

    $sql="SELECT `holiday_id` FROM `tm_holiday_list` WHERE '$date' between `start_holiday_date`  and `end_holiday_date` AND `session_id`='$session_id' AND `school_code`='$school_code'";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in checking holiday : '.mysqli_error($this->conn));
        
        $num_rows = mysqli_num_rows($result);
        if($num_rows!==0)
        {
            return TRUE;
        }
        else{
            return FALSE;
        }


}
public function getHolidayDetails($date,$school_code) {
    $session_id=$this->getSessionByDate($date,$school_code);

    $sql="SELECT `holiday_id`,`start_holiday_date`,`end_holiday_date`,`holiday_Occasion`,`holiday_remark`,`holiday_type`,`date_added`  FROM `tm_holiday_list` WHERE '$date' between `start_holiday_date`  and `end_holiday_date` AND `session_id`='$session_id' AND `school_code`='$school_code'";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting holiday : '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function isLeave($date,$school_code) {
    $session_id=$this->getSessionByDate($date,$school_code);

    $sql="SELECT `application_id` FROM `tm_leave_master` WHERE '$date' between `leave_start_date`  and `leave_end_date` AND `session_id`='$session_id' AND `status`='Approved'";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in checking leave : '.mysqli_error($this->conn));
        
        $num_rows = mysqli_num_rows($result);
        if($num_rows!==0)
        {
            return TRUE;
        }
        else{
            return FALSE;
        }


}
public function isStudentOnLeave($date,$student_enrollment_no,$school_code) {
    $session_id=$this->getSessionByDate($date,$school_code);

    $sql="SELECT `application_id` FROM `tm_leave_master` WHERE '$date' between `leave_start_date`  and `leave_end_date` AND `applicant_id`='$student_enrollment_no' AND `session_id`='$session_id' AND `status`='2'";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in checking student leave : '.mysqli_error($this->conn));
        
        $num_rows = mysqli_num_rows($result);
        
        if($num_rows!==0)
        {

            return TRUE;
        }
        else{
            return FALSE;
        }


}
public function isStaffOnLeave($date,$staff_id,$school_code) {
    $session_id=$this->getSessionByDate($date,$school_code);

    $sql="SELECT `application_id` FROM `tm_leave_master` WHERE '$date' between `leave_start_date`  and `leave_end_date` AND `applicant_id`='$staff_id' AND `session_id`='$session_id' AND `status`='2'";

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in checking staff leave : '.mysqli_error($this->conn));
        
        $num_rows = mysqli_num_rows($result);
        
        if($num_rows!==0)
        {

            return TRUE;
        }
        else{
            return FALSE;
        }


}


public function getParticularClassAttendence($class_id,$section_id,$month,$year,$school_code)
{


        if(date('m')==$month)
        {
            $days=date('d') ;   
        }
        else{
           $days="31"; 
        }

        

    for ($i=1; $i <=$days ; $i++) { 
        
        $d=strtotime("$year-$month-$i");
        $date= date('Y-m-d',$d);
        

        unset($data);
        unset($result);
        unset($student);
        $session_id=$this->getSessionByDate($date,$school_code);
        $student=$this->getStudentCount($class_id,$section_id,$session_id,$school_code);

         $sql="SELECT `attendence`,COUNT(*) AS total FROM `tm_student_attendence` WHERE  `class_id`='$class_id' AND `section_id`='$section_id'  AND `attendence_date`='$date'  AND `status`='Active' AND `school_code`='$school_code' GROUP BY`attendence`";

         //echo $sql;

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attendence : '.mysqli_error($this->conn));

        $data['attendence_date']=$date;
        $data['student']=$student;
        
        $num_rows = mysqli_num_rows($result);
        //echo $num_rows . '<br />';

        if ($num_rows!==0) 
         {


                $data['status']="Taken";
                $student_by_date=$this->getStudentByDateCount($class_id,$section_id,$date,$school_code);
                $data['student_by_date_count']=$student_by_date;
                while ($row = $result->fetch_assoc()) {
                    
                        $data[$row['attendence']]=$row['total'];
                }
         }
         else{

            $isSunday=$this->isSunday($date);
            if($isSunday)
            {
    
                $data['status']="Sunday";
            }
            else if($this->isHoliday($date,$school_code))
            {
            
                   $data['status']="Holiday"; 
                   $holidays=$this->getHolidayDetails($date,$school_code);
                   $data['holidays']=$holidays; 


            }
            else{
            
                $data['status']="Not Taken";
                

            }
                /*$student_by_date=$this->getStudentByDate($class_id,$section_id,$date,$school_code);
                if($student_by_date)
                {
                    $data['student_by_date']=$student_by_date;
                }
                else{
                   $data['student_by_date']="0"; 
                }
               */
            
         }
                
        $arr[]= $data;       
    }
    

   
        return $arr;


}
public function getParticularClassAttendenceStatus($class_id,$section_id,$month,$year,$school_code)
{


        if(date('m')==$month)
        {
            $days=date('d') ;   
        }
        else{
           $days="31"; 
        }

    for ($i=1; $i <=$days ; $i++) { 
        
        $d=strtotime("$year-$month-$i");
        $date= date('Y-m-d',$d);
        

        unset($data);
        unset($result);
        unset($student);
        $session_id=$this->getSessionByDate($date,$school_code);
        $student=$this->getCurrentStudent($class_id,$section_id,$session_id,$school_code);

         $sql="SELECT `attendence`,COUNT(*) AS total FROM `tm_student_attendence` WHERE  `class_id`='$class_id' AND `section_id`='$section_id'  AND `attendence_date`='$date'  AND `status`='Active' AND `school_code`='$school_code' GROUP BY`attendence`";

         //echo $sql;

              
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attendence : '.mysqli_error($this->conn));

        $data['attendence_date']=$date;
        $data['student']=count($student);
        
        $num_rows = mysqli_num_rows($result);
        //echo $num_rows . '<br />';

        if ($num_rows!==0) 
         {


                $data['status']="Taken";
                $student_by_date=$this->getStudentByDate($class_id,$section_id,$date,$school_code);
                $data['student_by_date_count']=count($student_by_date);
                while ($row = $result->fetch_assoc()) {
                    
                        $data[$row['attendence']]=$row['total'];
                }
         }
         else{

            $isSunday=$this->isSunday($date);
            if($isSunday)
            {
    
                $data['status']="Sunday";
            }
            else if($this->isHoliday($date,$school_code))
            {
            
                   $data['status']="Holiday"; 
                   $holidays=$this->getHolidayDetails($date,$school_code);
                   $data['holidays']=$holidays; 


            }
            else{
            
                $data['status']="Not Taken";
                $student_by_date=$this->getStudentByDate($class_id,$section_id,$date,$school_code);
                if($student_by_date)
                {
                    $data['student_by_date']=$student_by_date;
                }
                else{
                   $data['student_by_date']="0"; 
                }
                

            }
            
         }
                
        $arr[]= $data;       
    }
    

   
        return $arr;


}
public function getStaffAttendanceOfMonthYear($month,$year,$school_code)
{
        if(date('m')==$month)
        {
            $days=date('d') ;   
        }
        else{
           $days="31"; 
        }

    for ($i=1; $i <=$days ; $i++) { 
        
        $d=strtotime("$year-$month-$i");
        $date= date('Y-m-d',$d);
        

        unset($data);
        unset($result);
        unset($student);
        $session_id=$this->getSessionByDate($date,$school_code);
        //$student=$this->getCurrentStudent($class_id,$section_id,$session_id);

         $sql="SELECT `attendance`,COUNT(*) AS total FROM `tm_staff_attendance` WHERE  `attendance_date`='$date'  AND `status`='Active' AND `school_code`='$school_code' GROUP BY`attendance`";

         //echo $sql;          
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff attendance : '.mysqli_error($this->conn));

        $data['attendance_date']=$date;
       // $data['student']=count($student);
        
        $num_rows = mysqli_num_rows($result);
        if ($num_rows!==0) 
         {

                $data['status']="Taken";
                $staff=$this->getAllStaffAttendanceDetails($date,$school_code);
                $data['staff']=$staff;
         }
         else{
            $isSunday=$this->isSunday($date);
            if($isSunday)
            {
                $data['status']="Sunday";
                $staff=$this->getAllStaffAttendanceDetails($date,$school_code);
                $data['staff']=$staff;

            }
            else if($this->isHoliday($date,$school_code))
            {
                   $data['status']="Holiday"; 
                   $holidays=$this->getHolidayDetails($date,$school_code);
                   $data['holidays']=$holidays; 
                   $staff=$this->getAllStaffAttendanceDetails($date,$school_code);
                  $data['staff']=$staff;



            }
            else{
               
                $data['status']="Not Taken";

                $staff=$this->getAllStaffAttendanceDetails($date,$school_code);
                $data['staff']=$staff;

            }
            
         }
                
        $arr[]= $data;       
    }
    

   
        return $arr;


}
public function getAllStaffAttendanceDetails($date,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`staff_name`,a.`department_id`,b.`department_name`,a.`staff_gender`,a.`staff_image_path`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='Delisted' AND a.`school_code`='$school_code'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all staff basic detail: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $staff_id=$row['staff_id'];
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));  
                $attendance=$this->getStaffAttendance($staff_id,$date); 
                if($attendance)
                {
                    $row['attendance_status']="Taken";
                    $row['attendance']=$attendance;
                }
                else{
                    $row['attendance_status']="Not Taken";
                    $row['attendance']=$attendance;
                }
                       
                $data[] = $row;
         }

     return $data;    
}
public function getStaffAttendance($staff_id,$date)
{
    
     $sql="SELECT `attendance` FROM `tm_staff_attendance` WHERE `staff_id`='$staff_id' AND `attendance_date`='$date' AND `status`='Active'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all staff attendance: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {         
                $data[] = $row;
         }
    return $data[0]['attendance']; 
}


public function getStaffAttendanceDetails($staff_id,$month,$year,$school_code)
{
        
    $days=cal_days_in_month(CAL_GREGORIAN,$month, $year);
    $today = date('Y-m-d');
    //echo $today;


    for ($i=1; $i <=$days ; $i++) { 
        
        $d=strtotime("$year-$month-$i");
        $date= date('Y-m-d',$d);
        

        unset($data);
        unset($result);
       
        $session_id=$this->getSessionByDate($date,$school_code);
        
         $sql="SELECT `attendance`,COUNT(*) AS total FROM `tm_staff_attendance` WHERE  `staff_id`='$staff_id'  AND `attendance_date`='$date'  AND `status`='Active' AND `school_code`='$school_code' GROUP BY`attendance`";
              
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attendence : '.mysqli_error($this->conn));

        $data['attendance_date']=$date;    
        $num_rows = mysqli_num_rows($result);
        
        if ($num_rows!==0) 
         {

                $data['status']="Taken";
                while ($row = $result->fetch_assoc()) {
                    
                        $data['attendance']=$row['attendance'];
                }
         }
         else{
            $isSunday=$this->isSunday($date);
            if($isSunday)
            {
                $data['status']="Sunday";
                $data['attendance']="N/A";

            }
            else if($this->isHoliday($date,$school_code))
            {
                   $data['status']="Holiday";   
                   $holidays=$this->getHolidayDetails($date,$school_code);
                   $data['holidays']=$holidays;  
                   $data['attendance']="N/A";  

            }
            else if($this->isStaffOnLeave($date,$staff_id,$school_code) && ($date>$today))
            {
                   $data['status']="OnLeave";  
                   $data['attendance']="N/A"; 
                    
            }           
            else{
               
                $data['status']="Not Taken";
                $data['attendance']="N/A";
                
            }
            
         }
                
        $arr[]= $data;       
    }
    
 return $arr;


}


public function getParticularClassHomeWork($class_id,$section_id,$month,$year,$school_code)
{

        $servername=$_SERVER['SERVER_NAME'];
        $days=cal_days_in_month(CAL_GREGORIAN,$month, $year);

    for ($i=1; $i <=$days ; $i++) { 
        
        $d=strtotime("$year-$month-$i");
        $date= date('Y-m-d',$d);
        

        unset($data);
        unset($subject);
        unset($result_subject);
        $session_id=$this->getSessionByDate($date,$school_code);
       

        $data['homework_date']=$date;
        $isSunday=$this->isSunday($date);
        if($isSunday)
        {
            $data['day']="Sunday";
        }
        else if($this->isHoliday($date,$school_code))
        {
             $data['day']="Holiday";         
        }
        else{
            $data['day']="SchoolDay"; 
        }
    

        $sql="SELECT a.`subject_id`,b.`subject_name` FROM `tm_class_subject` a LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code' AND `status`='Active') b ON a.`subject_id`=b.`subject_id` WHERE a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
        //echo $sql;

              
         $result_subject=mysqli_query($this->conn,$sql)or die ('Error in getting  subject in home work : '.mysqli_error($this->conn));
          while ($row = $result_subject->fetch_assoc()) {
                    
                    $subject_id=$row['subject_id'];

                    unset($result);
                    unset($hw);
                     $sql="SELECT `session_id`,`homework_id`,`home_work`,`homework_img` FROM `tm_class_homework` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `homework_date`='$date' AND `status`='Active' AND `school_code`='$school_code'";   

                     $result=mysqli_query($this->conn,$sql)or die ('Error in getting  homework : '.mysqli_error($this->conn));

                  
                    $num_rows = mysqli_num_rows($result);
                    if ($num_rows!==0) 
                     {

                            $row['status']="Assigned";
                            while ($row2 = $result->fetch_assoc()) {
                                $hw_img=$row2['homework_img'];
                                if($hw_img!='')
                                {

                                 $img='http://'.$servername."/".$hw_img;
                                 $row2['homework_img']=trim(preg_replace('/\s\s+/', '', $img));
                                }
                              $hw[]=$row2; 
                            
                        }
                        $row['class_homework']=$hw;
                     }
                     else{
                        
                        $row['status']="Not Assigned";
                        
                     }
                     $subject[]=$row;
                                               
                }
                                           
            $data['subjects']=$subject;   
            $arr[]=$data;                           

    }
     
    
return $arr;


}

public function getClassSubjectHomework($class_id,$section_id,$subject_id,$homework_date,$school_code)
{

    $session_id=$this->getSessionByDate($homework_date,$school_code);
    
    $sql="SELECT `homework_id`,`home_work`,`homework_img` FROM `tm_class_homework` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `homework_date`='$homework_date' AND `status`='Active' AND `school_code`='$school_code'";   

                     $result=mysqli_query($this->conn,$sql)or die ('Error in getting  homework : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}


public function getClassWithBoard($school_code,$session_id)
{
    $board=$this->getBoard($school_code,$session_id);
    $data['board']=$board;

    $medium=$this->getMedium($school_code,$session_id);
    $data['medium']=$medium;

    $class=$this->getClassAndSection($school_code,$session_id);
    $data['class']=$class;
    

    return $data;

}

public function getClassAndSection($school_code,$session_id)
{

    $sql="SELECT a.`school_code`,a.`session_id`,a.`class_id`,a.`class_name`,a.`board_id`,b.`board_name`,a.`medium_id`,c.`medium_name` FROM `tm_class` a LEFT JOIN (SELECT * FROM `tm_board` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`board_id`=b.`board_id`
        LEFT JOIN (SELECT * FROM `tm_medium` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') c ON a.`medium_id`=c.`medium_id` WHERE a.`session_id`='$session_id' AND a.`status`='Active' AND a.`school_code`='$school_code' ORDER BY a.`id` ASC"; 
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   ClassWithSection '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        $class_id=$row['class_id'];
                        $section=$this->getClassSection($class_id,$session_id,$school_code);
                        if($section)
                        {
                                
                                 $row['section']=$section;
                        }
                        else{
                                $row['section']='No';
                                $section_id='No';
                                
                                
                        }
                        
                        $data[] = $row;
                 }
        return $data;

}

public function getClassWithStudentCount($school_code,$session_id)
{
    $board=$this->getBoard($school_code,$session_id);
    $data['board']=$board;

    $medium=$this->getMedium($school_code,$session_id);
    $data['medium']=$medium;

    $class=$this->getClassWithSectionDetails($school_code,$session_id);
    $data['class']=$class;
    

    return $data;

}
public function getBoard($school_code,$session_id)
{
    $sql="SELECT `board_id`,`board_name` FROM `tm_board` WHERE `status`='Active' AND `school_code`='$school_code' AND `session_id`='$session_id' ORDER BY `id` ASC";

     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   board '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getMedium($school_code,$session_id)
{
    $sql="SELECT `medium_id`,`medium_name` FROM `tm_medium` WHERE `status`='Active' AND `school_code`='$school_code' AND `session_id`='$session_id' ORDER BY `id` ASC";     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   medium '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getClassWithSectionDetails($school_code,$session_id)
{

    $sql="SELECT a.`school_code`,a.`session_id`,a.`class_id`,a.`class_name`,a.`board_id`,b.`board_name`,a.`medium_id`,c.`medium_name` FROM `tm_class` a LEFT JOIN (SELECT * FROM `tm_board` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`board_id`=b.`board_id`
        LEFT JOIN (SELECT * FROM `tm_medium` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') c ON a.`medium_id`=c.`medium_id` WHERE a.`session_id`='$session_id' AND a.`status`='Active' AND a.`school_code`='$school_code' ORDER BY a.`id` ASC"; 
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   ClassWithSection '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        $class_id=$row['class_id'];
                        $section=$this->getClassSectionWithDetails($class_id,$session_id,$school_code);
                         if($section)
                        {
                                
                                 $row['section']=$section;
                        }
                        else{
                                $row['section']='No';
                                $section_id='No';
                                $student=$this->getStudentCount($class_id,$section_id,$session_id,$school_code);
                                $row['student']=$student;
                                $class_teacher_id=$this->getClassTeacher($class_id,$section_id,$session_id,$school_code);
                                $class_teacher_name=$this->getStaffName($class_teacher_id);
                                $row['class_teacher_id']=$class_teacher_id;
                                $row['class_teacher_name']=$class_teacher_name;

                                
                        }
                        
                        $data[] = $row;
                 }
        return $data;

}


public function getClassTeacher($class_id,$section_id,$session_id,$school_code)
{
    $sql="SELECT `class_teacher_id` FROM `tm_class_teacher` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   class teacher '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['class_teacher_id'];

}
public function getClassTeacherList($session_id,$school_code)
{
    $sql="SELECT `staff_id`,`staff_name` FROM `tm_staff_master` WHERE `staff_role`='Class Teacher' AND `status`='Active'  AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   class teacher list'.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $staff_id=$row['staff_id'];
                        $class_of_class_teacher=$this->getClassOfClassTeacher($session_id,$staff_id);
                        $row['class_of_class_teacher']=$class_of_class_teacher;
                        $data[] = $row;
                 }
        return $data;

}
public function getClassOfClassTeacher($session_id,$staff_id)
{
    $sql="SELECT `class_id`,`section_id`,`session_id` FROM `tm_class_teacher` WHERE `class_teacher_id`='$staff_id' AND `session_id`='$session_id' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   class of class teacher'.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0];

}

public function getStudentImageDir($enrollment_no)
{
    $sql="SELECT `student_img_path` FROM `tm_student_admission` WHERE `student_enrollment_no`='$enrollment_no'";

     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student img dir '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['student_img_path'];

}
public function getStudentName($enrollment_no)
{
    $sql="SELECT `stu_name` FROM `tm_student_admission` WHERE `student_enrollment_no`='$enrollment_no'";

     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student img dir '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['stu_name'];
}
public function getDashBoard($staff_id,$school_code,$system_code,$CurrentVersionCode)
{
    $is_in_app_call='true';
    $panel="Clerk";
    
    $session=$this->getCurrentSessionName($school_code);
    $dashboard['current_session']=$session;

   /* $allSession=$this->getAllSession($school_code);
    $dashboard['all_session']=$allSession;*/

    $session_id=$this->getCurrentSession($school_code);
    $total=$this->getTotalStudent_count($session_id,$school_code);
    $dashboard['total_student']=$total;
    $dashboard['privilege']=$this->getPrivilege($staff_id);

    $SchoolDetails=$this->getSchoolDetails($school_code);
    $dashboard['SchoolDetails']=$SchoolDetails;

    $AdsControl=$this->getAdsControl($school_code,$panel);
    $dashboard['AdsControl']=$AdsControl;

    $Announcement=$this->getAnnouncement($school_code,$panel);
    $dashboard['Announcement']=$Announcement;

    $app_update=$this->getCurrentAppVersion($CurrentVersionCode,$is_in_app_call,$panel);
    $dashboard['app_update']=$app_update;

    $product_account=$this->getProductAccountStatus($school_code,$system_code);
    $dashboard['product_account']=$product_account;



    return $dashboard;

}
public function getTeacherDashBoard($staff_id,$school_code,$system_code,$CurrentVersionCode)
{
    $is_in_app_call='true';
    $panel="Teacher";
    
    $session=$this->getCurrentSessionName($school_code);
    $dashboard['current_session']=$session;

   /* $allSession=$this->getAllSession($school_code);
    $dashboard['all_session']=$allSession;*/

    $session_id=$this->getCurrentSession($school_code);
    $total=$this->getTotalStudent_count($session_id,$school_code);
    $dashboard['total_student']=$total;
    $dashboard['privilege']=$this->getPrivilege($staff_id);

    $SchoolDetails=$this->getSchoolDetails($school_code);
    $dashboard['SchoolDetails']=$SchoolDetails;

    $AdsControl=$this->getAdsControl($school_code,$panel);
    $dashboard['AdsControl']=$AdsControl;

    $Announcement=$this->getAnnouncement($school_code,$panel);
    $dashboard['Announcement']=$Announcement;

    $app_update=$this->getCurrentAppVersion($CurrentVersionCode,$is_in_app_call,$panel);
    $dashboard['app_update']=$app_update;

    $product_account=$this->getProductAccountStatus($school_code,$system_code);
    $dashboard['product_account']=$product_account;


    return $dashboard;

}

public function getPrivilege($staff_id)
{
     $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`staff_id`,b.`module_name`,b.`icons_dir`,b.`module_icon`,b.`module_activity`,b.`package_name`,b.`module_type`,b.`module_index`,b.`status`,b.`software_section` FROM `tm_privilege_master` a LEFT JOIN  `tm_modules` b ON a.`module_id`=b.`module_id` WHERE a.`status`='Active' AND a.`staff_id`='$staff_id' AND b.`status`='Active' AND b.`granted_status`='Granted'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  privilege '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                    $icons_dir=$row['icons_dir'];
                    $module_icon=$row['module_icon'];

                    $img='http://'.$server_name."/".$icons_dir.$module_icon;
                    $row['icon_img']=trim(preg_replace('/\s\s+/', '', $img));
                    $data[] = $row;
                 }
        return $data;

}

public function getTotalStudent_count($session_id,$school_code)
{
    $sql="SELECT count(*) as total FROM `tm_student_class` WHERE `status`='Active' AND `session_id`='$session_id' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   total student '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['total'];

}
public function getInActiveStudent_count($session_id,$school_code)
{
    $sql="SELECT count(*) as total FROM `tm_student_class` WHERE `status`='InActive' AND `session_id`='$session_id' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   total inactive student '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['total'];

}

public function findStudent($enrollment_no,$session_id,$aadhar_no,$school_code)
{
    
    unset($data);
    $server_name=$_SERVER['SERVER_NAME'];
     if (strlen($enrollment_no)!= 0){

        $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`father_name`FROM `tm_student_admission` WHERE `student_enrollment_no`='$enrollment_no' AND `status`!='InActive'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                         $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $class_id=$class[0]['class_id'];
                         $section_id=$class[0]['section_id'];
                         $record_id=$class[0]['id'];
                         $row['class']=$class;
                         $data[] = $row;
                 }             
         }
         else{
            return $result;

         }
     }
     else{

            $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`father_name`FROM `tm_student_admission` WHERE  `adharcard_no`='$aadhar_no' AND `status`!='InActive'";
     
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
            if($result)
            {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                        $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $class_id=$class[0]['class_id'];
                         $section_id=$class[0]['section_id'];
                         $record_id=$class[0]['id'];
                         $row['class']=$class;
                        $data[] = $row;
                 }        

            }
            else{
                return $result;
            }
                 
     }
     $next=$this->getNextStudentId($record_id,$session_id,$class_id,$section_id,$school_code);
     $data[0]['next_student']=$next;
     $prev=$this->getPrevStudentId($record_id,$session_id,$class_id,$section_id,$school_code);
     $data[0]['prev_student']=$prev;
     return $data;
         

}
public function getNextStudentId($record_id,$session_id,$class_id,$section_id,$school_code)
{

     $sql="SELECT `id`,`student_enrollment_no` FROM `tm_student_class` WHERE `id` = (select min(`id`) from `tm_student_class` WHERE `id` >'$record_id') AND `class_id` = '$class_id' AND `section_id` = '$section_id' AND `session_id`='$session_id' AND `school_code` = '$school_code'";
     //echo $sql;

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  next class student: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getPrevStudentId($record_id,$session_id,$class_id,$section_id,$school_code)
{

     $sql="SELECT `id`,`student_enrollment_no` FROM `tm_student_class` WHERE `id` = (select max(`id`) from `tm_student_class` WHERE `id` <'$record_id') AND `class_id` = '$class_id' AND `section_id` = '$section_id' AND `session_id`='$session_id' AND `school_code` = '$school_code'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  prev class student: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getStudentDetails($enrollment_no,$session_id,$school_code)
{
    unset($data);
       $server_name=$_SERVER['SERVER_NAME'];
    
        $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`father_name`,`sr_admission_no`,`bloodgroup`,`religion`,`nationality`,`community`,`current_address`,`permanent_address`,`mother_name`,`email_id` FROM `tm_student_admission` WHERE `student_enrollment_no`='$enrollment_no' AND `status`!='InActive'";
        //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                         $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        
                         $row['class']=$class;
                         $data[] = $row;
                 }             
         }
         else{
            return $result;

         }
     
     
     return $data;
         

}
public function getSelectedStudentDetails($selected_student_ids,$session_id,$school_code)
{
    unset($data);
        $arr_selected_student_ids = json_decode($selected_student_ids, TRUE);
       
        $str_selected_student_ids= "'" . implode ( "', '", $arr_selected_student_ids ) . "'";
       $server_name=$_SERVER['SERVER_NAME'];
    
        $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`father_name`,`sr_admission_no`,`bloodgroup`,`religion`,`nationality`,`community`,`current_address`,`permanent_address`,`mother_name`,`email_id` FROM `tm_student_admission` WHERE `student_enrollment_no` IN ($str_selected_student_ids) AND `status`!='InActive'";
        //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                         $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        
                         $row['class']=$class;
                         $data[] = $row;
                 }             
         }
         
     
     return $data;
         

}


public function getStudentContactDetails($enrollment_no)
{
    
    $sql="SELECT `student_enrollment_no`,`contact_number`,`contact_person_relation`,`contact_person_name` FROM `tm_student_contact` WHERE `student_enrollment_no`='$enrollment_no' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student contact details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getStudentContactHistory($enrollment_no,$school_code)
{
    
    $sql="SELECT `student_enrollment_no`,`contact_number`,`contact_person_relation`,`contact_person_name` FROM `tm_student_contact` WHERE `student_enrollment_no`='$enrollment_no' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student contact details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function searchStudentdetails($enrollment_no,$session_id,$aadhar_no,$school_code)
{
    
    $server_name=$_SERVER['SERVER_NAME'];

    if (strlen($enrollment_no)!= 0){

    $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`adharcard_no`,`nationality`,`community`,`religion`,`birthday`,`current_address`,`permanent_address`,`father_name`,`father_img_path`,`mother_name`,`mother_img_path`,`email_id` FROM `tm_student_admission` WHERE (`student_enrollment_no`='$enrollment_no') AND `status`!='InActive'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));

                        $father_img_path=$row['father_img_path'];
                        $img_father='http://'.$server_name."/".$father_img_path;
                        $row['father_img_path']=trim(preg_replace('/\s\s+/', '', $img_father));

                        $mother_img_path=$row['mother_img_path'];
                        $img_mother='http://'.$server_name."/".$mother_img_path;
                        $row['mother_img_path']=trim(preg_replace('/\s\s+/', '', $img_mother));

                        $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $class_id=$class[0]['class_id'];
                        $row['class']=$class;

                        $fee=$this->getStudentFeeDetails($enrollment_no,$class_id,$session_id,$school_code);
                        $row['fee_details']=$fee;
                       

                        $contact=$this->getStudentContactDetails($enrollment_no);
                        $row['contact_details']=$contact;

                        $gaurdian_details=$this->getStudentFamilyDetails($enrollment_no);
                        $row['family_details']=$gaurdian_details;

                        $gaurdian_details=$this->getStudentGaurdianDetails($enrollment_no);
                        $row['gaurdian_details']=$gaurdian_details;
                        $data[] = $row;
                 }

                

         }
         else{
            return $result;

         }

    }
    else{
         $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`adharcard_no`,`nationality`,`community`,`religion`,`birthday`,`current_address`,`permanent_address`,`father_name`,`father_img_path`,`mother_name`,`mother_img_path`FROM `tm_student_admission` WHERE (`adharcard_no`='$aadhar_no') AND `status`!='InActive'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                         $father_img_path=$row['father_img_path'];
                        $img_father='http://'.$server_name."/".$father_img_path;
                        $row['father_img_path']=trim(preg_replace('/\s\s+/', '', $img_father));

                        $mother_img_path=$row['mother_img_path'];
                        $img_mother='http://'.$server_name."/".$mother_img_path;
                        $row['mother_img_path']=trim(preg_replace('/\s\s+/', '', $img_mother));

                        $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $class_id=$class[0]['class_id'];
                        $row['class']=$class;

                        $fee=$this->getStudentFeeDetails($enrollment_no,$class_id,$session_id,$school_code);
                        $row['fee_details']=$fee;
                       

                        $contact=$this->getStudentContactDetails($enrollment_no);
                        $row['contact_details']=$contact;

                        $gaurdian_details=$this->getStudentFamilyDetails($enrollment_no);
                        $row['family_details']=$gaurdian_details;

                        $gaurdian_details=$this->getStudentGaurdianDetails($enrollment_no);
                        $row['gaurdian_details']=$gaurdian_details;
                        $data[] = $row;
                 }

                

         }
         else{
            return $result;

         }
    }
               
        return $data;
}
public function getStudentFeeDetails_withStudentDetails($enrollment_no,$session_id,$aadhar_no,$school_code)
{
    $parent=new getFunctionsParents();
     $server_name=$_SERVER['SERVER_NAME'];

    if (strlen($enrollment_no)!= 0){

    $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`adharcard_no`,`nationality`,`community`,`religion`,`birthday`,`current_address`,`permanent_address`,`father_name`,`father_img_path`,`mother_name`,`mother_img_path` FROM `tm_student_admission` WHERE (`student_enrollment_no`='$enrollment_no') AND `status`!='InActive'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));

                        $father_img_path=$row['father_img_path'];
                        $img_father='http://'.$server_name."/".$father_img_path;
                        $row['father_img_path']=trim(preg_replace('/\s\s+/', '', $img_father));

                        $mother_img_path=$row['mother_img_path'];
                        $img_mother='http://'.$server_name."/".$mother_img_path;
                        $row['mother_img_path']=trim(preg_replace('/\s\s+/', '', $img_mother));

                        $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $class_id=$class[0]['class_id'];
                        $row['class']=$class;

                        $fee=$this->getStudentFeeDetails($enrollment_no,$class_id,$session_id,$school_code);
                        $row['fee_details']=$fee;

                        $all_session=$this->getAllSession($school_code);
                        for ($i=0; $i <count($all_session) ; $i++) { 

                            $session_id_new=$all_session[$i]['session_id'];
                            $class=$this->getClassOfStudent($enrollment_no,$session_id_new,$school_code);
                            $class_id=$class[0]['class_id'];
                            $section_id=$class[0]['section_id'];

                            $pay=$this->getStudentPayDetails($enrollment_no,$class_id,$section_id,$session_id_new,$school_code);
                             $arr=explode('#',$pay);
                             $total_due=$arr[0];
                             $total_recieved=$arr[1];
                             $pay_data[0]['current_due']=$total_due;
                             $pay_data[0]['total_recieved']=$total_recieved;
                             $pay_data[0]['total_fee']=$arr[2];
                             $pay_data[0]['total_due']=$arr[3];
                             $pay_data[0]['due_settlement']=$arr[4];
                             $all_session[$i]['pay_details']=$pay_data;
                        }
                      
                        $row['all_session_pay_details']=$all_session;

                        $sibling=$parent->getMySiblingsDetails($enrollment_no,$school_code);
                         for ($i=0; $i <count($sibling); $i++) {

                            $sib_enrollment_no=$sibling[$i]['student_enrollment_no'];
                            $class=$this->getClassOfStudent($sib_enrollment_no,$session_id,$school_code);
                            $class_id=$class[0]['class_id'];
                            $section_id=$class[0]['section_id'];
                            
                            $pay=$this->getStudentPayDetails($sib_enrollment_no,$class_id,$section_id,$session_id,$school_code);
                           
                             $arr=explode('#',$pay);
                             $total_due=$arr[0];
                             $total_recieved=$arr[1];
                             $pay_data[0]['current_due']=$total_due;
                             $pay_data[0]['total_recieved']=$total_recieved;
                             $pay_data[0]['total_fee']=$arr[2];
                             $pay_data[0]['total_due']=$arr[3];
                             $pay_data[0]['due_settlement']=$arr[4];
                             $sibling[$i]['pay_details']=$pay_data;
                         }

                        $row['siblings_pay_details']=$sibling;

                        $due=$this->getStudentOldDue($enrollment_no,$school_code);
                        $row['old_due']=$due;
                        $data[] = $row;
                       

                 }

                

         }
         else{
            return $result;

         }

    }
    else{
         $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`adharcard_no`,`nationality`,`community`,`religion`,`birthday`,`current_address`,`permanent_address`,`father_name`,`father_img_path`,`mother_name`,`mother_img_path`FROM `tm_student_admission` WHERE (`adharcard_no`='$aadhar_no') AND `status`!='InActive'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                         $father_img_path=$row['father_img_path'];
                        $img_father='http://'.$server_name."/".$father_img_path;
                        $row['father_img_path']=trim(preg_replace('/\s\s+/', '', $img_father));

                        $mother_img_path=$row['mother_img_path'];
                        $img_mother='http://'.$server_name."/".$mother_img_path;
                        $row['mother_img_path']=trim(preg_replace('/\s\s+/', '', $img_mother));

                        $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $class_id=$class[0]['class_id'];
                        $row['class']=$class;

                        $fee=$this->getStudentFeeDetails($enrollment_no,$class_id,$session_id,$school_code);
                        $row['fee_details']=$fee;


                        $all_session=$this->getAllSession($school_code);
                        for ($i=0; $i <count($all_session) ; $i++) { 

                            $session_id=$all_session[$i]['session_id'];
                            $pay=$this->getStudentPayDetails($enrollment_no,$class_id,$section_id,$session_id,$school_code);
                             $arr=explode('#',$pay);
                             $total_due=$arr[0];
                             $total_recieved=$arr[1];
                             $pay_data[0]['current_due']=$total_due;
                             $pay_data[0]['total_recieved']=$total_recieved;
                             $pay_data[0]['total_fee']=$arr[2];
                             $pay_data[0]['total_due']=$arr[3];
                             $pay_data[0]['due_settlement']=$arr[4];
                             $all_session[$i]['pay_details']=$pay_data;
                        }
                      
                        $row['all_session_pay_details']=$all_session;

                        $sibling=$parent->getMySiblingsDetails($enrollment_no,$school_code);
                         for ($i=0; $i <count($sibling); $i++) {

                            $sib_enrollment_no=$sibling[$i]['student_enrollment_no'];
                            $class=$this->getClassOfStudent($sib_enrollment_no,$session_id,$school_code);
                            $class_id=$class[0]['class_id'];
                            $section_id=$class[0]['section_id'];
                            
                            $pay=$this->getStudentPayDetails($sib_enrollment_no,$class_id,$section_id,$session_id,$school_code);
                           
                             $arr=explode('#',$pay);
                             $total_due=$arr[0];
                             $total_recieved=$arr[1];
                             $pay_data[0]['current_due']=$total_due;
                             $pay_data[0]['total_recieved']=$total_recieved;
                             $pay_data[0]['total_fee']=$arr[2];
                             $pay_data[0]['total_due']=$arr[3];
                             $pay_data[0]['due_settlement']=$arr[4];
                             $sibling[$i]['pay_details']=$pay_data;
                         }

                        $row['siblings_pay_details']=$sibling;
                        
                        $due=$this->getStudentOldDue($enrollment_no,$school_code);
                        $row['old_due']=$due;
                        $data[] = $row;
                       
                       
                 }

                

         }
         else{
            return $result;

         }
    }
               
        return $data;

}

public function getStudentGaurdianDetails($enrollment_no)
{
    
    $sql="SELECT `gaurdian_id`,`student_enrollment_no`,`gaurdian_name`,`gaurdian_relation`,`gaurdian_contact_no`,`gaurdian_aadhar`,`gaurdian_img_path` FROM `tm_student_guardian` WHERE `student_enrollment_no`='$enrollment_no' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student gaurdian details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getStudentFamilyDetails($enrollment_no)
{
    
    $sql="SELECT `father_name`,`father_occupation`,`father_img_path`,`mother_name`,`mother_occupation`,`mother_img_path`,`email_id` FROM `tm_student_admission` WHERE `student_enrollment_no`='$enrollment_no' ";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student family details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getClassOfStudent($enrollment_no,$session_id,$school_code)
{
    $sql="SELECT a.`id`, a.`student_enrollment_no` , a.`student_roll_no` , a.`session_id`, f.`session_name` , a.`class_id` , b.`class_name` , a.`section_id` , c.`section_name` , a.`board_id`,d.`board_name` , a.`medium_id`,e.`medium_name`,a.`status` 
        FROM  `tm_student_class` a
        LEFT JOIN  (SELECT * FROM `tm_class` WHERE `school_code`='$school_code' AND `session_id`='$session_id') b ON a.`class_id` = b.`class_id` 
        LEFT JOIN  `tm_section_master` c ON a.`section_id` = c.`section_id` 
        LEFT JOIN (SELECT * FROM `tm_board` WHERE `school_code`='$school_code' AND `session_id`='$session_id') d ON a.`board_id`=d.`board_id`
        LEFT JOIN (SELECT * FROM `tm_medium` WHERE `school_code`='$school_code' AND `session_id`='$session_id')  e ON a.`medium_id`=e.`medium_id`
        LEFT JOIN (SELECT * FROM `tm_session` WHERE `school_code`='$school_code' AND `session_id`='$session_id')  f ON a.`session_id`=f.`session_id`

        WHERE a.`student_enrollment_no` ='$enrollment_no'
        AND a.`session_id` ='$session_id'";

       // echo $sql;

       $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student class '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}

public function getStudentFeeDetails($enrollment_no,$class_id,$session_id,$school_code)
{

    $common=new Common();
    $index=0;
    if($common->isCurrentSession($session_id,$school_code))
    {
        $today=date('Y-m-d');
        //echo $today;
        $start_date=$this->getSessionStartDate($session_id,$school_code);
        //echo $start_date;
        $count=$this->getNoOfMonth( $start_date,$today);
        //echo $count;
       
    }
    else{
        $end_date=$this->getSessionEndDate($session_id,$school_code);
        //echo $end_date.'/';
        $start_date=$this->getSessionStartDate($session_id,$school_code);
       // echo $start_date.'/';
        $count=$this->getNoOfMonth( $start_date,$end_date);
        

    }
    for ($i=0; $i <=$count ; $i++) { 

            $month=date("Y-m",strtotime("+$i Months,$start_date"));
            $month2=date("F-Y",strtotime("+$i Months,$start_date"));
           // echo $month;
           
            unset($applicable_fee);

            $sql="SELECT a.`fee_id`,a.`fee_value`,b.`fee_name` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code' ) b ON a.`fee_id`=b.`fee_id` WHERE INSTR(  a.`applicable_month` , '$month' )  AND a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee '.mysqli_error($this->conn));
              
                 while ($row = $result->fetch_assoc()) {

                        $fee_id=$row['fee_id'];
                       
                        unset($result2);


                        $sql="SELECT  `fee_id` ,`fee_payable`,SUM(  `fee_paid` ) AS fee_paid FROM  `tm_fee_payment` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id` = '$fee_id' AND `year_month` = '$month' AND `status` = '2' AND `school_code` = '$school_code'";

                        $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee2 '.mysqli_error($this->conn));
                            $row2 = $result2->fetch_assoc();

                           
                            if($row2['fee_id']!=NULL)
                            {
                                if($row2['fee_payable']==$row2['fee_paid'])
                                {
                                    $row['payment_status']="Paid";
                                    $row['fee_value']=$row2['fee_payable'];
                                    $row['amount_paid']=$row2['fee_paid'];
                                    $row['outstanding']=$row2['fee_payable']-$row2['fee_paid'];


                                }
                                else{
                                    $due=$row2['fee_payable']-$row2['fee_paid'];
                                    $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$due,$school_code);
                                    if($settlement)
                                    {
                                        $row=array_merge($row, $settlement);

                                    }
                                    else{
                                        $row['payment_status']="Due";
                                        $row['fee_value']=$row2['fee_payable'];
                                        $row['amount_paid']=$row2['fee_paid'];
                                        $row['outstanding']=$row2['fee_payable']-$row2['fee_paid'];
                                    }
                                    
                                    
                                }
                                
                            }
                            else{

                                $special_case_fee=$this->isSpecialCase($enrollment_no,$class_id,$session_id,$fee_id,$school_code);
                                if (strlen($special_case_fee)!= 0){

                                    $fee_value=$special_case_fee;
                                    $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                    if($settlement)
                                    {
                                        $settlement['isSpecialCase']="Yes";
                                        $settlement['class_fee']=$row['fee_value'];
                                        $row=array_merge($row, $settlement);

                                    }
                                    else{

                                        $row['payment_status']="Not Paid";
                                        $row['isSpecialCase']="Yes";
                                        $row['class_fee']=$row['fee_value'];
                                        $row['fee_value']=$special_case_fee;
                                        $row['amount_paid']="0";
                                        $row['outstanding']=$special_case_fee;
                                    }
                                   
                                }
                                else{
                                    //normal case student
                                   $special_fee=$this->getSpecialFee($school_code);
                                   if($fee_id==$special_fee[0]['fee_id'])
                                    {
                                        //special fee
                                       $admission_type=$this->getAdmissionType($enrollment_no,$class_id,$session_id);
                                       if($admission_type=="ADMTYPE01")
                                       {
                                            $regfee=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);

                                             $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$regfee,$school_code);
                                            if($settlement)
                                            {
                                                $settlement['isSpecialCase']="No";
                                                $row=array_merge($row, $settlement);

                                             }
                                             else{
                                                 $row['payment_status']="Not Paid";
                                                 $row['isSpecialCase']="No";
                                                 $row['fee_value']=$regfee;
                                                 $row['amount_paid']="0";
                                                 $row['outstanding']=$regfee;
                                            }
                                           

                                       }
                                       else{
                                            $regfee=$row['fee_value'];
                                            $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$regfee,$school_code);
                                            if($settlement)
                                            {
                                                $settlement['isSpecialCase']="No";
                                                $row=array_merge($row, $settlement);

                                            }
                                            else{
                                                $row['payment_status']="Not Paid";
                                                $row['isSpecialCase']="No";
                                                $row['amount_paid']="0";
                                                $row['outstanding']=$row['fee_value'];
                                            }
                                        
                                       }


                                  }
                                  else{
                                    //normal class fee
                                    $fee_value=$row['fee_value'];
                                    $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                            if($settlement)
                                            {
                                                $settlement['isSpecialCase']="No";
                                                $row=array_merge($row, $settlement);

                                            }else{
                                                 $row['payment_status']="Not Paid";
                                                 $row['isSpecialCase']="No";
                                                 $row['amount_paid']="0";
                                                 $row['outstanding']=$row['fee_value'];

                                            }

                                   
                                   }


                                    
                                }
                               
                            }
                            

                       $applicable_fee[] = $row;
                 }
                $transport_fee=$this->getTransportFee_IfTransportGranted($enrollment_no,$session_id,$class_id,$month,$school_code);
                if($transport_fee)
                {
                   if($transport_fee['payment_status']=='Paid')
                   {       
                       
                          $applicable_fee[]=$transport_fee;
;
                   }
                   else{
                      
                        $outstanding=$transport_fee['outstanding'];
                        $fee_id=$transport_fee['fee_id'];
                        $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$outstanding,$school_code);
                        if($settlement)
                        {
                            $transport_fee=array_merge($transport_fee, $settlement);
                            $applicable_fee[]=$transport_fee;

                        }
                        else{
                            $applicable_fee[]=$transport_fee;
                        }
                   }
                      
                }
                if($applicable_fee)
                {
                    
                    $data[$index]['month']=$month;
                    $data[$index]['month2']=$month2;
                    $data[$index]['applicable_fee']=$applicable_fee; 
                    $index++;
                    
                }
                
                 
                  
        
    }
    
    return $data;
}

public function getTransportFee_IfTransportGranted($enrollment_no,$session_id,$class_id,$month,$school_code)
{
    unset($data);
    unset($row);

     $sql="SELECT `transport_fee` FROM `tm_transport_student` WHERE INSTR(`applicable_month` , '$month') AND `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  transport fee: '.mysqli_error($this->conn));
           while ($row_tf = $result->fetch_assoc()) {
            
                $data[] = $row_tf;
            }
                                     
         
         if($data)
         {
            
            $transport_fee=$data[0]['transport_fee']; 
            $special_fee=$this->getSpecialFee($school_code);
            $fee_id=$special_fee[1]['fee_id'];
            $fee_name=$special_fee[1]['fee_name'];

            $row['fee_id']=$fee_id;
            $row['fee_name']=$fee_name;
            $row['fee_value']=$transport_fee;
            
            unset($result2);

                $sql="SELECT  `fee_id` ,`fee_payable`,SUM(  `fee_paid` ) AS fee_paid FROM  `tm_fee_payment` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id` = '$fee_id' AND `year_month` = '$month' AND `status` = '2' AND `school_code` = '$school_code'";

                $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee2 '.mysqli_error($this->conn));
                    $row2 = $result2->fetch_assoc();

                   
                    if($row2['fee_id']!=NULL)
                    {
                        if($row2['fee_payable']==$row2['fee_paid'])
                        {
                            $row['payment_status']="Paid";
                            $row['fee_value']=$row2['fee_payable'];
                            $row['amount_paid']=$row2['fee_paid'];
                            $row['outstanding']=$row2['fee_payable']-$row2['fee_paid'];


                        }
                        else{
                            $row['payment_status']="Due";
                            $row['fee_value']=$row2['fee_payable'];
                            $row['amount_paid']=$row2['fee_paid'];
                            $row['outstanding']=$row2['fee_payable']-$row2['fee_paid'];
                            
                            
                        }
                        
                    }
                    else{

                            $row['payment_status']="Not Paid";
                            $row['isSpecialCase']="No";
                            $row['amount_paid']="0";
                            $row['fee_value']=$transport_fee;
                            $row['outstanding']=$transport_fee;
                       
                    }

            
         }

   return $row;
}
public function isSpecialCase($student_id,$class_id,$session_id,$fee_id,$school_code)
{
    
     $sql="SELECT `fee_value` FROM `tm_fee_special_case` WHERE `student_id`='$student_id' AND `class_id`='$class_id' AND `session_id`='$session_id' AND `fee_id`='$fee_id' AND `status`='Active' AND `school_code`='$school_code'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  special case fee: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data[0]['fee_value'];    
}
public function getAdmissionType($enrollment_no,$class_id,$session_id)
{
    
     $sql="SELECT `admission_type_id` FROM `tm_student_class` WHERE `student_enrollment_no`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id'";
    

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  admission type: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data[0]['admission_type_id'];    
}
public function getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code)
{
    
     $sql="SELECT `fee_value` FROM `tm_fee_registration_existing_student` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id`='$fee_id' AND `school_code`='$school_code'";
    

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  existing student reg fee: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data[0]['fee_value'];    
}
public function getStudentFeeCard($enrollment_no,$session_id,$school_code)
{

    $index=0;
    $student_data=$this->findStudent($enrollment_no,$session_id,$aadhar_no,$school_code);
    $class_id=$student_data[0]['class'][0]['class_id'];
    //echo $class_id.'/';
    $response['student_details']=$student_data;
    $end_date=$this->getSessionEndDate($session_id,$school_code);
    //echo $end_date.'/';
    $start_date=$this->getSessionStartDate($session_id,$school_code);
   // echo $start_date.'/';
    $count=$this->getNoOfMonth( $start_date,$end_date);
    //echo $count.'/';
    for ($i=0; $i <=$count ; $i++) { 

            $month=date("Y-m",strtotime("+$i Months,$start_date"));
            $month2=date("F-Y",strtotime("+$i Months,$start_date"));
           // echo $month;
           
            unset($applicable_fee);

            $sql="SELECT a.`fee_id`,a.`fee_value`,b.`fee_name` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code' ) b ON a.`fee_id`=b.`fee_id` WHERE INSTR(  a.`applicable_month` , '$month' )  AND a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
            
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee '.mysqli_error($this->conn));
              
                 while ($row = $result->fetch_assoc()) {

                        $fee_id=$row['fee_id'];
                        unset($result2);


                        $sql="SELECT  `fee_id` ,`fee_payable`,SUM(  `fee_paid` ) AS fee_paid FROM  `tm_fee_payment` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id` = '$fee_id' AND `year_month` = '$month' AND `status` = '2' AND `school_code` = '$school_code'";

                        $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee2 '.mysqli_error($this->conn));
                            $row2 = $result2->fetch_assoc();

                           
                            if($row2['fee_id']!=NULL)
                            {
                                if($row2['fee_payable']==$row2['fee_paid'])
                                {
                                    $row['payment_status']="Paid";
                                    $row['fee_value']=$row2['fee_payable'];
                                    $row['amount_paid']=$row2['fee_paid'];
                                    $row['outstanding']=$row2['fee_payable']-$row2['fee_paid'];


                                }
                                else{
                                    $due=$row2['fee_payable']-$row2['fee_paid'];
                                    $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$due,$school_code);
                                    if($settlement)
                                    {
                                        $row=array_merge($row, $settlement);

                                    }
                                    else{
                                        $row['payment_status']="Due";
                                        $row['fee_value']=$row2['fee_payable'];
                                        $row['amount_paid']=$row2['fee_paid'];
                                        $row['outstanding']=$row2['fee_payable']-$row2['fee_paid'];
                                    }
                                    
                                    
                                }
                                
                            }
                            else{

                                $special_case_fee=$this->isSpecialCase($enrollment_no,$class_id,$session_id,$fee_id,$school_code);
                                if (strlen($special_case_fee)!= 0){

                                    $fee_value=$special_case_fee;
                                    $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                    if($settlement)
                                    {
                                        $settlement['isSpecialCase']="Yes";
                                        $settlement['class_fee']=$row['fee_value'];
                                        $row=array_merge($row, $settlement);

                                    }
                                    else{

                                        $row['payment_status']="Not Paid";
                                        $row['isSpecialCase']="Yes";
                                        $row['class_fee']=$row['fee_value'];
                                        $row['fee_value']=$special_case_fee;
                                        $row['amount_paid']="0";
                                        $row['outstanding']=$special_case_fee;
                                    }
                                   
                                }
                                else{
                                    //normal case student
                                   $special_fee=$this->getSpecialFee($school_code);
                                   if($fee_id==$special_fee[0]['fee_id'])
                                    {
                                        //special fee
                                       $admission_type=$this->getAdmissionType($enrollment_no,$class_id,$session_id);
                                       if($admission_type=="ADMTYPE01")
                                       {
                                            $regfee=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);

                                             $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$regfee,$school_code);
                                            if($settlement)
                                            {
                                                $settlement['isSpecialCase']="No";
                                                $row=array_merge($row, $settlement);

                                             }
                                             else{
                                                 $row['payment_status']="Not Paid";
                                                 $row['isSpecialCase']="No";
                                                 $row['fee_value']=$regfee;
                                                 $row['amount_paid']="0";
                                                 $row['outstanding']=$regfee;
                                            }
                                           

                                       }
                                       else{
                                            $regfee=$row['fee_value'];
                                            $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$regfee,$school_code);
                                            if($settlement)
                                            {
                                                $settlement['isSpecialCase']="No";
                                                $row=array_merge($row, $settlement);

                                            }
                                            else{
                                                $row['payment_status']="Not Paid";
                                                $row['isSpecialCase']="No";
                                                $row['amount_paid']="0";
                                                $row['outstanding']=$row['fee_value'];
                                            }
                                        
                                       }


                                  }
                                  else{
                                    //normal class fee
                                    $fee_value=$row['fee_value'];
                                    $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                            if($settlement)
                                            {
                                                $settlement['isSpecialCase']="No";
                                                $row=array_merge($row, $settlement);

                                            }else{
                                                 $row['payment_status']="Not Paid";
                                                 $row['isSpecialCase']="No";
                                                 $row['amount_paid']="0";
                                                 $row['outstanding']=$row['fee_value'];

                                            }

                                   
                                   }


                                    
                                }
                               
                            }
                            

                       $applicable_fee[] = $row;
                 }
                $transport_fee=$this->getTransportFee_IfTransportGranted($enrollment_no,$session_id,$class_id,$month,$school_code);
                if($transport_fee)
                {
                  if($transport_fee['payment_status']=='Paid')
                   {       
                       
                          $applicable_fee[]=$transport_fee;
;
                   }
                   else{
                      
                        $outstanding=$transport_fee['outstanding'];
                        $fee_id=$transport_fee['fee_id'];
                        $settlement=$this->getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$outstanding,$school_code);
                        if($settlement)
                        {
                            $transport_fee=array_merge($transport_fee, $settlement);
                            $applicable_fee[]=$transport_fee;

                        }
                        else{
                            $applicable_fee[]=$transport_fee;
                        }
                   }   
                }
                if($applicable_fee)
                {
                    
                    $data[$index]['month']=$month;
                    $data[$index]['month2']=$month2;
                    $data[$index]['applicable_fee']=$applicable_fee; 
                    $index++;
                    
                }
                
                 
                  
        
    }
    
    $response['fee_details']=$data;
    return $response;
}
public function getSessionStartDate($session_id,$school_code)
{
     $sql="SELECT `start_date` FROM `tm_session` WHERE `session_id`='$session_id' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  session start date '.mysqli_error($this->conn));
    $row = $result->fetch_assoc();
                 
                
        return $row['start_date'];
}
public function getSessionEndDate($session_id,$school_code)
{
     $sql="SELECT `end_date` FROM `tm_session` WHERE `session_id`='$session_id' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  session start date '.mysqli_error($this->conn));
    $row = $result->fetch_assoc();
                 
                
        return $row['end_date'];
}

public function getNoOfMonth($date1, $date2)
{
    
        $ts1 = strtotime($date1);
        $ts2 = strtotime($date2);

        $year1 = date('Y', $ts1);
        $year2 = date('Y', $ts2);

        $month1 = date('m', $ts1);
        $month2 = date('m', $ts2);

        $diff = (($year2 - $year1) * 12) + ($month2 - $month1);
        return $diff;
}

public function getFirebaseTokenId($strRecipient,$school_code)
{
       $common=new Common();
        $staff_prefix_code=$common->getStaffIdPrefix($school_code);

        $session_id=$this->getCurrentSession($school_code);
        $arrRecipient = json_decode($strRecipient, TRUE);
        for ($i=0; $i <count($arrRecipient) ; $i++) { 
            
            $recipient=$arrRecipient[$i];
            $prefix = preg_replace('/[0-9]+/', '', $recipient);
            
            if($recipient=="ALL_STUDENT" || $recipient=="ALL_CLASS")
            {

                $sql="SELECT `student_enrollment_no` FROM `tm_student_admission` WHERE `status`='Active' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   students enrollment number '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_enrollment_no=$row['student_enrollment_no'];
                        //echo $student_enrollment_no;

                        $sql="SELECT `firebase_id` FROM  `tm_student_firebase_token` WHERE `student_enrollment_no` = '$student_enrollment_no' AND `school_code`='$school_code'";
                         $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   students firebase ids '.mysqli_error($this->conn));
                         
                         while ($row2 = $result2->fetch_assoc()) {
                                $firebase_id=$row2['firebase_id'];
                                $data[] = $firebase_id;
                            }
                       
                 }
                //print_r($data);
                return $data;

            }
            else if($prefix=="CLS#SEC" || $prefix=="CLS#No")
            {

                $temp=explode("#",$recipient);
                $class_id=$temp[0];
                $section_id=$temp[1];

                 $sql="SELECT `student_enrollment_no` FROM `tm_student_class` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `status`='Active' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   students enrollment number '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_enrollment_no=$row['student_enrollment_no'];
                        //echo $student_enrollment_no;

                        $sql="SELECT `firebase_id` FROM  `tm_student_firebase_token` WHERE `student_enrollment_no` = '$student_enrollment_no' AND `school_code`='$school_code'";
                         $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   students firebase ids '.mysqli_error($this->conn));
                         
                         while ($row2 = $result2->fetch_assoc()) {
                                $firebase_id=$row2['firebase_id'];
                                $data[] = $firebase_id;
                            }
                       
                 }
                 //print_r($data);
                return $data;

            }
            else if($prefix==$staff_prefix_code)
            {

                 $sql="SELECT `firebase_id` FROM `tm_staff_master` WHERE `staff_id`='$recipient' AND `status`='Active' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   staff firebase ids '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $firebase_id=$row['firebase_id'];
                        $data[] = $firebase_id;
                 }
                
                return $data;
            }
            else if($recipient=="ALL_STAFF")
            {

                $sql="SELECT `firebase_id` FROM `tm_staff_master` WHERE  `status`='Active' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   staff firebase ids '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $firebase_id=$row['firebase_id'];
                        $data[] = $firebase_id;
                 }
                
                return $data;
            }
            else if($recipient=="GLOBAL")
            {
                $sql="SELECT `student_enrollment_no` FROM `tm_student_admission` WHERE `status`='Active' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   students enrollment number '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_enrollment_no=$row['student_enrollment_no'];
                        //echo $student_enrollment_no;

                        $sql="SELECT `firebase_id` FROM  `tm_student_firebase_token` WHERE `student_enrollment_no` = '$student_enrollment_no'";
                         $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   students firebase ids '.mysqli_error($this->conn));
                         
                         while ($row2 = $result2->fetch_assoc()) {
                                $firebase_id=$row2['firebase_id'];
                                $data[] = $firebase_id;
                            }
                       
                 }

                 $sql="SELECT `firebase_id` FROM `tm_staff_master` WHERE  `status`='Active' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   staff firebase ids '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $firebase_id=$row['firebase_id'];
                        $data[] = $firebase_id;
                 }

                return $data;

            }
            else{

                 $sql="SELECT `firebase_id` FROM  `tm_student_firebase_token` WHERE `student_enrollment_no` = '$recipient' AND `school_code`='$school_code'";
                 $result=mysqli_query($this->conn,$sql)or die ('Error in getting   students firebase ids '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $firebase_id=$row['firebase_id'];
                        $data[] = $firebase_id;
                 }
                
                return $data;

            }

        }    

   
}

public function getStudentNoticeBoard($school_code,$session_id,$staff_id,$login_type)
{
    

    $common=new Common();
    $prefix_for_enroll_no=$common->getStudentEnrollmentPrefix($school_code);
    $prefix_for_staff_id=$common->getStaffidPrefix($school_code);
    $length1=strlen($prefix_for_enroll_no);
    $length2=strlen($prefix_for_staff_id);

    if($login_type=='Admin')
    {
         $sql="SELECT `notice_id`,`staff_id`,`notice`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by`,DATE(`date_added`) AS notice_date FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STUDENT' OR `recipient_id`='ALL_CLASS' OR INSTR(`recipient_id` ,  'CLS' ) OR LEFT(`recipient_id`,$length1)='$prefix_for_enroll_no') AND LEFT(`recipient_id`,$length2)!='$prefix_for_staff_id' AND `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code' AND `session_id`='$session_id'  GROUP BY `notice_id` ORDER BY `date_added` DESC";
    }
    else{
         $sql="SELECT `notice_id`,`staff_id`,`notice`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by`,DATE(`date_added`) AS notice_date FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STUDENT' OR `recipient_id`='ALL_CLASS' OR INSTR(`recipient_id` ,  'CLS' ) OR LEFT(`recipient_id`,$length1)='$prefix_for_enroll_no') AND LEFT(`recipient_id`,$length2)!='$prefix_for_staff_id' AND `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code' AND `session_id`='$session_id' AND `staff_id`='$staff_id' GROUP BY `notice_id` ORDER BY `date_added` DESC";
    }
   
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student notice board: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $notice_date=$row['notice_date'];
                $notice_date2=date("d-F-Y",strtotime($notice_date));
                $row['notice_date2']=$notice_date2;

                $staff_id=$row['staff_id'];
                $sender_staff=$this->getStaffName($staff_id);
                $row['sender_staff']=$sender_staff;
                
                $data[] = $row;
         }

     return $data;    
}

public function getStaffNoticeBoard($school_code,$session_id,$staff_id,$login_type)
{
    

    $common=new Common();
    $prefix_for_staff_id=$common->getStaffidPrefix($school_code);
    //echo $prefix_for_staff_id;

    if($login_type=='Admin')
    {
         $sql="SELECT `notice_id`,`staff_id`,`notice`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by`,DATE(`date_added`) AS notice_date FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STAFF'  OR INSTR(`recipient_id` ,  '$prefix_for_staff_id' )) AND `session_id`='$session_id' AND `school_code`='$school_code' AND `status`='Active'  GROUP BY `notice_id` ORDER BY `date_added` DESC";
    }
    else{
         $sql="SELECT `notice_id`,`staff_id`,`notice`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by`,DATE(`date_added`) AS notice_date FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STAFF'  OR INSTR(`recipient_id` ,  '$prefix_for_staff_id' )) AND `session_id`='$session_id' AND `school_code`='$school_code' AND `status`='Active' AND `staff_id`='$staff_id' GROUP BY `notice_id` ORDER BY `date_added` DESC";
    } 
   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff notice board: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $notice_date=$row['notice_date'];
                $notice_date2=date("d-F-Y",strtotime($notice_date));
                $row['notice_date2']=$notice_date2;

                $staff_id=$row['staff_id'];
                $sender_staff=$this->getStaffName($staff_id);
                $row['sender_staff']=$sender_staff;
                

                $data[] = $row;
         }

     return $data;    
}
public function getStaffAllNotice($school_code,$session_id,$staff_id,$login_type)
{
    

        $common=new Common();
        $prefix_for_staff_id=$common->getStaffidPrefix($school_code);
       
        if($login_type=='Admin')
        {
                 $sql="SELECT `notice_id`,`staff_id`,`notice`,`status`,`date_added`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by` FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STAFF'  OR INSTR(`recipient_id` ,  '$prefix_for_staff_id' )) AND `session_id`='$session_id' AND `school_code`='$school_code'  GROUP BY `notice_id`";
        }
        else{
             $sql="SELECT `notice_id`,`staff_id`,`notice`,`status`,`date_added`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by` FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STAFF'  OR INSTR(`recipient_id` ,  '$prefix_for_staff_id' )) AND `session_id`='$session_id' AND `school_code`='$school_code' AND `staff_id`='$staff_id' GROUP BY `notice_id`";
        }
   
    
    
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff all notice : '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getStudentAllNotice($school_code,$session_id,$staff_id,$login_type)
{
    

        $common=new Common();
        $prefix_for_enroll_no=$common->getStudentEnrollmentPrefix($school_code);
        $prefix_for_staff_id=$common->getStaffidPrefix($school_code);
        $length1=strlen($prefix_for_enroll_no);
        $length2=strlen($prefix_for_staff_id);

        if($login_type=='Admin')
        {
             $sql="SELECT `notice_id`,`staff_id`,`notice`,`status`,`date_added`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by` FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STUDENT' OR `recipient_id`='ALL_CLASS' OR INSTR(`recipient_id` ,  'CLS' ) OR LEFT(`recipient_id`,$length1)='$prefix_for_enroll_no') AND LEFT(`recipient_id`,$length2)!='$prefix_for_staff_id' AND `session_id`='$session_id' AND `school_code`='$school_code'  GROUP BY `notice_id`";
        }
        else{
             $sql="SELECT `notice_id`,`staff_id`,`notice`,`status`,`date_added`,`recipient_id`,count(`notice_id`)as recipient_count,`ordered_by` FROM `tm_notice_board` WHERE  (`recipient_id`='GLOBAL' OR `recipient_id`='ALL_STUDENT' OR `recipient_id`='ALL_CLASS' OR INSTR(`recipient_id` ,  'CLS' ) OR LEFT(`recipient_id`,$length)='$prefix_for_enroll_no') AND LEFT(`recipient_id`,$length2)!='$prefix_for_staff_id' AND `session_id`='$session_id' AND `school_code`='$school_code' AND `staff_id`='$staff_id'  GROUP BY `notice_id`";
        }

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  notification: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getStudentLeave($session_id,$school_code)
{


    $sql="SELECT a.`application_id`,a.`applicant_id`,a.`applicant_type`,a.`leave_start_date`,a.`leave_end_date`,a.`authority`,a.`subject`,a.`application_content`,a.`session_id`,a.`date_added`,a.`status`,b.`status_name` FROM `tm_leave_master` a LEFT JOIN `tm_leave_status_master` b ON a.`status`=b.`status_id` WHERE a.`applicant_type`='Student' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code' ORDER BY a.`id` DESC";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student leave: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $applicant_id=$row['applicant_id'];
                $student = $this->findStudent($applicant_id,$session_id,$aadhar_no,$school_code);
                $row['applicant']=$student;
                $data[] = $row;
         }

     return $data;   
}
public function getStaffLeave($session_id,$school_code)
{


    $sql="SELECT a.`application_id`,a.`applicant_id`,a.`applicant_type`,a.`leave_start_date`,a.`leave_end_date`,a.`authority`,a.`subject`,a.`application_content`,a.`session_id`,a.`date_added`,a.`status`,b.`status_name` FROM `tm_leave_master` a LEFT JOIN `tm_leave_status_master` b ON a.`status`=b.`status_id` WHERE a.`applicant_type`='Staff' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code' ORDER BY a.`id` DESC";
   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff leave: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

            
        
                $applicant_id=$row['applicant_id'];
                $staff = $this->getSingleStaff($applicant_id);
                $row['applicant']=$staff;
                $data[] = $row;
         }

     return $data;   
}

public function updateLeaveStatus($application_id,$status,$staff_id,$school_code)
{


    $auto= new Automation();

    $sql="UPDATE `tm_leave_master` SET `status` = '$status',`who_approved` = '$staff_id' WHERE `application_id` ='$application_id' AND `school_code` ='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in updating leave status: '.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {

                $sql="SELECT `application_id`,`applicant_id`,`leave_start_date`,`leave_end_date` FROM `tm_leave_master` WHERE `application_id`='$application_id' AND `school_code` ='$school_code'";
                $result2=mysqli_query($this->conn,$sql)or die ('Error in getting  leave: '.mysqli_error($this->conn));
                                     
                while ($row2= $result2->fetch_assoc()) {
            
                $applicant_id=$row2['applicant_id'];
                $leave_start_date=$row2['leave_start_date'];
                $leave_end_date=$row2['leave_end_date'];

                $auto->NotifyStudentLeaveStatus($applicant_id,$staff_id,$status,$leave_start_date,$leave_end_date,$school_code);
                
                }

                return true;  
            }
            else{
            
                return false;
            }

}



public function getImageGallery()
{

        $servername=$_SERVER['SERVER_NAME'];

         $sql="SELECT `sender_id`,`session_id`,`image_id`,`caption`,`description`,`img_path`,`date_added` FROM `tm_event_gallery` WHERE `status`='Active'";   

                     $result=mysqli_query($this->conn,$sql)or die ('Error in getting  gallery : '.mysqli_error($this->conn));
                      while ($row= $result->fetch_assoc()) {
                                $img=$row['img_path'];
                                if($img!='')
                                {

                                 $img_url='http://'.$servername."/".$img;
                                 $row['event_image']=trim(preg_replace('/\s\s+/', '', $img_url));
                                }
                              $data[]=$row; 
                            
                        }

       return $data;         

}
public function getAllNotification($session_id,$limit,$offset,$school_code)
{

     $sql="SELECT `notification_id`,`recipient_id`,`notification_title`,`notification`,`department`,`date_added` FROM `tm_notification_master` WHERE  `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code' ORDER BY `date_added` DESC LIMIT $offset,$limit";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all notification: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getAllComments($session_id,$limit,$offset,$school_code)
{

    $sql="SELECT `session_id`,`comment_id`,`sender_id`,`comment`,`comment_for`,`comment_type`,`date_added`,`status` FROM `tm_comments` WHERE  `session_id`='$session_id' AND `parent_comment_id`='0' AND `status`='Active' AND `school_code`='$school_code' ORDER BY `date_added` DESC LIMIT $offset,$limit ";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all comments: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $sender_id=$row['sender_id'];

                $sender_name=$this->getStaffName($sender_id);
                if($sender_name!=NULL)
                {
                    $row['sender_name']=$sender_name;
                }
                else 
                {
                   $sender_name= $this->getStudentName($sender_id);
                   $row['sender_name']=$sender_name;
                }
                $comment_id=$row['comment_id'];
                $reply=$this->getCommentReply($comment_id,$school_code);
                $row['reply']=$reply;

            
                $data[] = $row;
         }

     return $data;    
}


public function getCommentReply($comment_id,$school_code)
{

    $sql="SELECT `comment_id`,`sender_id`,`comment`,`comment_for`,`comment_type`,`date_added` FROM `tm_comments` WHERE `parent_comment_id`='$comment_id' AND `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting comment reply: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $sender_id=$row['sender_id'];

                $sender_name=$this->getStaffName($sender_id);
                if($sender_name!=NULL)
                {
                    $row['sender_name']=$sender_name;
                    $row['staff_image_path']=$this->getStaffImage($sender_id);
                }
                $data[] = $row;
         }

     return $data;    
}
public function getStaffImage($staff_id)
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT `staff_image_path` FROM `tm_staff_master` WHERE `staff_id`='$staff_id'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting staff img: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));            
                $data[] = $row;
         }

     return $data[0]['staff_image_path'];    
}
public function getAttendanceStudent($date,$class_id,$section_id,$school_code)
{

    $session_id=$this->getSessionByDate($date,$school_code);

    $sql="SELECT `student_enrollment_no`,`class_id`,`section_id`,`session_id`,`attendence_date`,`attendence` FROM `tm_student_attendence` WHERE `attendence_date`='$date' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `status`='Active' AND `school_code`='$school_code' ORDER BY `student_enrollment_no` ASC";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting attendance student: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $student_enrollment_no=$row['student_enrollment_no'];
                $student = $this->getStudentDetails($student_enrollment_no,$session_id,$school_code);
                $row['student_details']=$student;
                $contact=$this->getStudentContactDetails($student_enrollment_no);
                $row['contact_details']=$contact;
            
                $data[] = $row;
         }

     return $data;    
}


public function getDepartment($school_code)
{

    $sql="SELECT a.`department_id`,a.`department_name`,b.`department_head`,c.`staff_name` FROM `tm_department` a LEFT JOIN (SELECT * FROM `tm_department_head` WHERE `school_code`='$school_code' AND `status`='Active') b ON a.`department_id`=b.`department_id` LEFT JOIN `tm_staff_master` c ON b.`department_head`=c.`staff_id` WHERE a.`status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting department: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

            
                $data[] = $row;
         }

     return $data;    
}
public function getStaff($school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`password`,a.`aadhar_no`,a.`staff_name`,a.`department_id`,b.`department_name`,a.`staff_gender`,a.`staff_phone`,a.`staff_email`,a.`staff_dob`,a.`registration_date`,a.`joining_date`,a.`staff_role`,a.`login_type`,a.`staff_religion`,a.`nationality`,a.`staff_address`,a.`staff_image_path`,a.`status`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='InActive' AND a.`school_code`='$school_code'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all staff: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $staff_id=$row['staff_id'];
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
                $qualification=$this->getStaffQualification($staff_id);
                $row['qualification']=$qualification;
            
                $data[] = $row;
         }

     return $data;    
}
public function getStaffQualification($staff_id)
{

     $sql="SELECT `id`,`staff_id`,`staff_degree`,`staff_university`,`staff_passing_year`,`staff_percentage` FROM `tm_staff_education` WHERE `staff_id`='$staff_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting qualification: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getAllStaffTeachingClassAndSubject()
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`aadhar_no`,a.`staff_name`,a.`department_id`,b.`department_name`,`staff_role`,a.`staff_image_path`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='InActive'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all staff: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $staff_id=$row['staff_id'];
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
                $teaching_class=$this->getStaffTeachingClass($staff_id);
                $row['teaching_class']=$teaching_class;
            
                $data[] = $row;
         }

     return $data;    
}
public function getStaffTeachingClass($staff_id)
{

     $sql="SELECT a.`class_id`,c.`class_name`,a.`section_id`,d.`section_name`,e.`board_id`,e.`medium_id` FROM `tm_timetable_details` a LEFT JOIN `tm_timetable` b ON a.`timetable_id`=b.`timetable_id`  LEFT JOIN `tm_class` c ON a.`class_id`=c.`class_id` LEFT JOIN `tm_section_master` d ON a.`section_id`=d.`section_id` LEFT JOIN `tm_class` e ON a.`class_id`=e.`class_id` WHERE b.`status`='Active' AND a.`staff_id`='$staff_id' AND a.`status`='Active' GROUP BY a.`class_id`,a.`section_id`";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting staff teaching class: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                        $class_id=$row['class_id'];  
                        $section_id=$row['section_id'];  
                        $subjects=$this->getStaffTeachingSubject($class_id,$section_id,$staff_id);
                        $row['teaching_subject']= $subjects;                   
                        $data[] = $row;
            
         }

     return $data;    
}

public function getStaffTeachingSubject($class_id,$section_id,$staff_id)
{

     $sql="SELECT a.`period_id`,a.`subject_id`,c.`subject_name`,a.`subject_part_id`,a.`teaching_days` FROM `tm_timetable_details` a LEFT JOIN `tm_timetable` b ON a.`timetable_id`=b.`timetable_id` LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code') c ON a.`subject_id`=c.`subject_id` WHERE b.`status`='Active' AND a.`staff_id`='$staff_id' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`status`='Active' ";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting staff teaching subject: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {                    
                        $data[] = $row;
            
         }

     return $data;    
}

public function getStaffDetails($staff_id)
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`school_code`,a.`password`,a.`aadhar_no`,a.`staff_name`,a.`department_id`,b.`department_name`,a.`staff_gender`,a.`staff_phone`,a.`staff_email`,a.`staff_dob`,a.`registration_date`,a.`joining_date`,a.`staff_role`,a.`login_type`,a.`staff_religion`,a.`nationality`,a.`staff_address`,a.`staff_image_path`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='InActive' AND a.`staff_id`='$staff_id'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff profile: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $staff_id=$row['staff_id'];
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
                $qualification=$this->getStaffQualification($staff_id);
                $row['qualification']=$qualification;

                $subject=$this->getStaffSubject($staff_id);
                $row['subjects']=$subject;
            
                $data[] = $row;
         }

     return $data;    
}

public function getSingleStaff($staff_id)
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`password`,a.`aadhar_no`,a.`staff_name`,a.`department_id`,b.`department_name`,a.`staff_gender`,a.`staff_phone`,a.`staff_email`,a.`staff_dob`,a.`registration_date`,a.`joining_date`,a.`staff_role`,a.`login_type`,a.`staff_religion`,a.`nationality`,a.`staff_address`,a.`staff_image_path`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='InActive' AND a.`staff_id`='$staff_id'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff profile: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $staff_id=$row['staff_id'];
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
                
                $data[] = $row;
         }

     return $data;    
}


public function getStaffProfile($staff_id)
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`aadhar_no`,a.`staff_name`,a.`department_id`,b.`department_name`,a.`staff_gender`,a.`staff_phone`,a.`staff_email`,a.`staff_dob`,a.`registration_date`,a.`joining_date`,a.`staff_role`,a.`login_type`,a.`staff_religion`,a.`nationality`,a.`staff_address`,a.`staff_image_path`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='InActive' AND a.`staff_id`='$staff_id'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff profile: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $staff_id=$row['staff_id'];
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));
                $qualification=$this->getStaffQualification($staff_id);
                $row['qualification']=$qualification;

                $subject=$this->getStaffSubject($staff_id);
                $row['subjects']=$subject;
            
                $data[] = $row;
         }

     return $data;    
}


public function getStaffSubject($staff_id)
{

      $sql="SELECT a.`staff_id`,a.`subject_id`,b.`subject_name`,a.`subject_type`,a.`teaching_classes` FROM `tm_staff_subject` a LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code') b ON a.`subject_id`=b.`subject_id` WHERE a. `staff_id`='$staff_id' AND a.`status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting subject: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $teaching_classes_id=$row['teaching_classes'];
                $classes=$this->getStaffTeachingClassName($teaching_classes_id);
                $row['teaching_classes']=$classes;
                $data[] = $row;
         }

     return $data;     
}
public function getStaffTeachingClassName($teaching_classes_id)
{

    $arr= explode(',', $teaching_classes_id);
    for ($i=0; $i <count($arr) ; $i++) { 

        $class_id=$arr[$i];
         $sql="SELECT `class_id`,`class_name` FROM `tm_class` WHERE `class_id`='$class_id'";
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting staff teaching class name: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }
        
    }

   

     return $data;    
}
public function getStaffImageDir($staff_id)
{
    $sql="SELECT `staff_image_path` FROM `tm_staff_master` WHERE `staff_id`='$staff_id'";

     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   staff img dir '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['staff_image_path'];

}
public function getStaffName($staff_id)
{

    $sql="SELECT `staff_name` FROM `tm_staff_master` WHERE `staff_id`='$staff_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting staff name: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data[0]['staff_name'];    
}

public function getStaffDepartment($staff_id)
{

     $sql="SELECT b.`department_name` FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE a.`staff_id`='$staff_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting department: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data[0]['department_name'];    
}
public function getClassSubject($class_id,$session_id,$school_code)
{

     $sql="SELECT a.`class_id`,a.`subject_id`,a.`subject_code`,a.`book_name`,b.`subject_name` FROM `tm_class_subject` a LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code' AND `status`='Active') b ON a.`subject_id`=b.`subject_id` WHERE a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting class subject: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $subject_id=$row['subject_id'];
                $subject_part=$this->getClassSubjectParts($class_id,$subject_id,$session_id,$school_code);
                $row['subject_part']=$subject_part;
                $data[] = $row;
         }

     return $data;    
}
public function getClassSubjectParts($class_id,$subject_id,$session_id,$school_code)
{

     $sql="SELECT a.`class_id`,a.`subject_id`,a.`subject_part_id`,b.`subject_part_name`,a.`subject_code`,a.`book_name` FROM `tm_class_subject_part` a  LEFT JOIN (SELECT * FROM `tm_subject_part` WHERE `school_code`='$school_code') b ON a.`subject_part_id`=b.`subject_part_id` WHERE a.`subject_id`='$subject_id' AND a.`class_id`='$class_id' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting class subject part: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                
                $data[] = $row;
         }

     return $data;    
}



public function getSubjectMasterList($school_code)
{

     $sql="SELECT `subject_id`,`subject_name` FROM `tm_subject` WHERE `school_code`='$school_code' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject master list: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $subject_id=$row['subject_id'];
                $subject_part=$this->getSubjectPart($subject_id,$school_code);
                $row['subject_part']=$subject_part;
                $data[] = $row;
         }

     return $data;    
}

public function getSubjectPart($subject_id,$school_code)
{

     $sql="SELECT `subject_id`,`subject_part_id`,`subject_part_name` FROM `tm_subject_part` WHERE `subject_id`='$subject_id' AND `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject part : '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getClassListWithSubject_Board_Medium($session_id,$school_code)
{
    $board=$this->getBoard($school_code,$session_id);
    $data['board']=$board;

    $medium=$this->getMedium($school_code,$session_id);
    $data['medium']=$medium;

    $class=$this->getClassListWithSubject($session_id,$school_code);
    $data['class']=$class;
    

    return $data;

}

public function getClassListWithSubject($session_id,$school_code)
{
    $sql="SELECT `id`,`class_id`,`class_name`,`board_id`,`medium_id` FROM `tm_class` WHERE `status`='Active' AND `session_id`='$session_id' AND `school_code`='$school_code' ORDER BY `id` ASC ";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   Class With Subject '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        $class_id=$row['class_id'];                      
                        $section=$this->getClassSection($class_id,$session_id,$school_code);
                         if($section)
                        {
                                for ($i=0; $i<count($section) ; $i++) { 
                                    $section_id=$section[$i]['section_id'];
                                   
                                    

                                }
                                 $row['section']=$section;
                        }
                        else{
                                 $row['section']='No';
                                 $section_id='No';
                                 
                                
                        }
                        $subject=$this->getClassSubject($class_id,$session_id,$school_code);
                        $row['subject']=$subject;
                        
                        $data[] = $row;
                 }
        return $data;  
}

public function getClassListWithSubjectPartAndPaper_Board_Medium($session_id,$exam_id,$school_code)
{
    $board=$this->getBoard($school_code,$session_id);
    $data['board']=$board;

    $medium=$this->getMedium($school_code,$session_id);
    $data['medium']=$medium;

    $class=$this->getClassListWithSubjectPartAndPaper($session_id,$exam_id,$school_code);
    $data['class']=$class;
    

    return $data;

}



public function getClassListWithSubjectPartAndPaper($session_id,$exam_id,$school_code)
{
    $sql="SELECT a.`class_id`,b.`class_name`,a.`section_id`,c.`section_name`,b.`board_id`,d.`board_name`,b.`medium_id`,e.`medium_name`,a.`subject_ids` FROM `tm_exam_participating_class` a 
        LEFT JOIN  (SELECT * FROM `tm_class` WHERE  `session_id`='$session_id' AND `school_code`='$school_code' AND `status`='Active') b ON a.`class_id` = b.`class_id` 
        LEFT JOIN  `tm_section_master` c ON a.`section_id` = c.`section_id` 
        LEFT JOIN (SELECT * FROM `tm_board` WHERE  `session_id`='$session_id' AND `school_code`='$school_code' AND `status`='Active') d ON b.`board_id`=d.`board_id`
        LEFT JOIN (SELECT * FROM `tm_medium` WHERE  `session_id`='$session_id' AND `school_code`='$school_code' AND `status`='Active')  e ON b.`medium_id`=e.`medium_id`WHERE a.`exam_id`='$exam_id' AND a.`status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   Class With Subject '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $class_id=$row['class_id'];
                        $section_id=$row['section_id'];

                        $subject_ids=$row['subject_ids'];    
                        $arrSubject_ids=explode(',',$subject_ids);
                        unset($subject_data);

                        for ($i=0; $i <count($arrSubject_ids) ; $i++) { 
                            $subject_id=$arrSubject_ids[$i];
                            $subject=$this->getSingleSubjectDetails($class_id,$subject_id,$session_id,$school_code);
                            $subject_paper=$this->getSubjectPaper($exam_id,$class_id,$section_id,$subject_id,$school_code);
                            $subject[0]['subject_paper']=$subject_paper;
                            $subject_data[]=$subject[0];
                            
                        }
                        
                        $row['subject']=$subject_data;  

                        $data[] = $row;

                 }
        return $data;  
}

public function getSubjectPaper($exam_id,$class_id,$section_id,$subject_id,$school_code)
{

     $sql="SELECT `exam_paper_id`,`exam_paper_name`,`is_mark_system`,`max_mark`,`is_grade_system`,`max_grade` FROM `tm_exam_paper` WHERE `exam_id`='$exam_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `status`='Active'  AND `school_code`='$school_code'";
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject paper : '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $exam_paper_id=$row['exam_paper_id'];
                $exam_paper_details=$this->getSubjectPaperDetails($exam_paper_id,$school_code);
                $row['exam_paper_details']=$exam_paper_details;
                $data[] = $row;
         }

     return $data;    
}

public function getSubjectPaperDetails($exam_paper_id,$school_code)
{

     $sql="SELECT `exam_paper_id`,`subject_part_id`,`subject_part_name`,`is_mark_system`,`max_mark`,`is_grade_system`,`max_grade` FROM `tm_exam_paper_details` WHERE `exam_paper_id`='$exam_paper_id' AND `status`='Active' AND `school_code`='$school_code' AND `is_trashed`='0'";
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject paper details : '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getSingleSubjectDetails($class_id,$subject_id,$session_id,$school_code)
{

     $sql="SELECT `subject_id`,`subject_name` FROM `tm_subject` WHERE `status`='Active' AND `subject_id`='$subject_id' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  single subject details: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $subject_id=$row['subject_id'];
                $subject_part=$this->getClassSubjectParts($class_id,$subject_id,$session_id,$school_code);
                $row['subject_part']=$subject_part;
            
                $data[] = $row;
         }

     return $data;    
}


public function getAllModules()
{
    $server_name=$_SERVER['SERVER_NAME'];
     $sql="SELECT `module_id`,`parent_id`,`module_name`,`icons_dir`,`module_icon`,`module_type`,`grade_id`,`module_index`, `status`,`granted_status` FROM `tm_modules` WHERE `granted_status`='Granted'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  all modules: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $icons_dir=$row['icons_dir'];
                $module_icon=$row['module_icon'];

                $img='http://'.$server_name."/".$icons_dir.$module_icon;
                $row['icon_img']=trim(preg_replace('/\s\s+/', '', $img));
            
                $data[] = $row;
         }

     return $data;    
}

public function getClerkAllActiveModules($system_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
     $sql="SELECT `module_id`,`parent_id`,`module_name`,`module_activity`,`component_name`,`package_name`,`icons_dir`,`module_icon`,`module_type`,`grade_id`,`software_section`,`module_index`, `status`,`granted_status` FROM `tm_modules` WHERE INSTR (`system_code` ,'$system_code') AND `granted_status`='Granted' AND `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  all modules: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $icons_dir=$row['icons_dir'];
                $module_icon=$row['module_icon'];

                $img='http://'.$server_name."/".$icons_dir.$module_icon;
                $row['icon_img']=trim(preg_replace('/\s\s+/', '', $img));
            
                $data[] = $row;
         }

     return $data;    
}
public function getAllAdminModules($school_code,$system_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
     $sql="SELECT `module_id`,`parent_id`,`module_name`,`module_activity`,`component_name`,`package_name`,`icons_dir`,`module_icon`,`module_type`,`grade_id`,`module_index`, `status`,`granted_status` FROM `tm_modules_admin` WHERE INSTR (`system_code` ,'$system_code') AND `granted_status`='Granted' AND `status`='Active' ORDER BY `module_index` ASC ";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  all modules admin: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $icons_dir=$row['icons_dir'];
                $module_icon=$row['module_icon'];

                $img='http://'.$server_name."/".$icons_dir.$module_icon;
                $row['icon_img']=trim(preg_replace('/\s\s+/', '', $img));
            
                $data[] = $row;
         }

     return $data;    
}

public function getStaffPrivilege($staff_id)
{

    $server_name=$_SERVER['SERVER_NAME'];
     $sql="SELECT `module_id`,`module_name`,`icons_dir`,`module_icon`,`module_type`,`grade_id` FROM `tm_modules` WHERE `status`='Active' AND `granted_status`='Granted'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff privilege: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                    $icons_dir=$row['icons_dir'];
                    $module_icon=$row['module_icon'];

                    $img='http://'.$server_name."/".$icons_dir.$module_icon;
                    $row['icon_img']=trim(preg_replace('/\s\s+/', '', $img));

                $module_id=$row['module_id'];
                $status=$this->checkPrivilege($module_id,$staff_id);
                $row['status']=$status;
                $data[] = $row;
         }

     return $data;    
}
public function checkPrivilege($module_id,$staff_id)
{
    unset($status);
    unset($data);
    unset($result);
    $sql="SELECT `module_id`,`staff_id`,`status` FROM `tm_privilege_master` WHERE `staff_id`='$staff_id' AND `module_id`='$module_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in checking  staff privilege: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }
       
          $status=$data[0]['status'];

          if(!is_null($status))
          {
             if($status=='Active')
             {
            
                return "Granted";
             }
             else if($status=='InActive')
             {
            
                return "Denied";
             }
          }
         else{
                
            return "Denied";
        }
           
   
}

public function getStaffCredentials($staff_id)
{
     $sql="SELECT `staff_id`,`password`,`staff_phone`,`staff_email` FROM `tm_staff_master` WHERE `staff_id`='$staff_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff auth: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
        
                $data[] = $row;
         }

     return $data;    
}
public function getStudentCredentials($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,b.`sr_admission_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN  `tm_student_admission` b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;
                        $contact=$this->getStudentContactDetails($enrollment_no);
                        $row['contact_details']=$contact;
                        $data[] = $row;
                 }
        return $data;
    
}

public function authenticatePasscode($staff_id,$passcode)
{
     $sql="SELECT `staff_id`,`passcode` FROM `tm_passcode` WHERE `staff_id`='$staff_id' AND `passcode`='$passcode'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  staff auth: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {      
                $data[] = $row;
         }

     return $data;    
}
public function getApplicableFeeAndMode($school_code)
{
     $applicable_fee=$this->getApplicableFee($school_code);
     $data['applicable_fee']=$applicable_fee;
     $mode=$this->getFeeCollectionMode(); 
     $data['mode']=$mode;
     $special_fee=$this->getSpecialFee($school_code);
     $data['special_fee']=$special_fee;
     $session=$this->getCurrentSessionName($school_code);
     $data['current_session']=$session;
     return $data;
}

public function getApplicableFee($school_code)
{
     $sql="SELECT `school_code`,`fee_id`,`fee_name` FROM `tm_fee_applicable` WHERE `status`='Active' AND `school_code`='$school_code' ORDER BY `id` ASC";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee applicable '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {                 
                $data[] = $row;
         }

     return $data;    
}

public function getFeeCollectionMode()
{
    $sql="SELECT `mode_id`,`mode` FROM `tm_fee_collection_mode` WHERE `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee mode '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {                 
                $data[] = $row;
         }

     return $data;    
}
public function getClassApplicableFee($class_id,$session_id,$school_code)
{

        $sql="SELECT `fee_id` FROM `tm_fee_special` WHERE `status`='Active' AND `school_code`='$school_code'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  special fee: '.mysqli_error($this->conn));
                                     
            while ($row = $result->fetch_assoc()) {
           
                $data[] = $row;
           }
        $registration_fee=$data[0]['fee_id'];


     $sql="SELECT a.`class_id`,a.`session_id`,a.`fee_id`,b.`fee_name`,a.`fee_value`,a.`applicable_month`,a.`mode_id`,c.`mode` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code' AND `status`='Active') b ON a.`fee_id`=b.`fee_id` LEFT JOIN `tm_fee_collection_mode` c ON a.`mode_id`=c.`mode_id`  WHERE a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
    $result2=mysqli_query($this->conn,$sql)or die ('Error in getting class fee: '.mysqli_error($this->conn));
                                     
         while ($row2 = $result2->fetch_assoc()) {

                $fee_id=$row2['fee_id'];
                if($fee_id==$registration_fee)
                {
                    $value2=$this->getSpecialFeeValue($session_id,$class_id,$fee_id,$school_code);
                    
                }
            
            $row2['fee_value_for_existing_student']=$value2;
            $data2[] = $row2;
         }

     return $data2;    
}
public function getSpecialFeeValue($session_id,$class_id,$fee_id,$school_code)
{

    $sql="SELECT `fee_value` FROM `tm_fee_registration_existing_student`   WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id`='$fee_id' AND `school_code`='$school_code' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting class special fee: '.mysqli_error($this->conn));
    while ($row = $result->fetch_assoc()) {
           
        $data[] = $row;
    } 
   return $data[0]['fee_value'];
}

public function getStudentSpecialFee($enrollment_no,$session_id,$class_id,$school_code)
{

     $sql="SELECT a.`class_id`,a.`fee_id`,b.`fee_name`,a.`fee_value` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code` = '$school_code') b ON a.`fee_id`=b.`fee_id` WHERE a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting class fee: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            $fee_id=$row['fee_id'];
            $special_case=$this->checkStudentSpecialFee($enrollment_no,$session_id,$class_id,$fee_id,$school_code);
                if($special_case)
                {
                    $row['special_case']="Yes";
                    $row['special_value']=$special_case[0]['fee_value'];
                }
                else{
                    $special_fee=$this->getSpecialFee($school_code);
                    if($fee_id==$special_fee[0]['fee_id'])
                    {
            
                       $admission_type=$this->getAdmissionType($enrollment_no,$class_id,$session_id);
                       if($admission_type=="ADMTYPE01")
                       {
                            $class_fee=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);

                            $row['special_case']="No";
                            $row['special_value']="No";
                            $row['fee_value']=$class_fee;
                            
                       }
                       else{

                         $row['special_case']="No";
                         $row['special_value']="No";
                       }
                       

                    }
                     else{
                        $row['special_case']="No";
                        $row['special_value']="No";
                    }
                    
                }            
                $data[] = $row;
         }

     return $data;    
}
public function checkStudentSpecialFee($enrollment_no,$session_id,$class_id,$fee_id,$school_code)
{

     $sql="SELECT `fee_value` FROM `tm_fee_special_case` WHERE `student_id`='$enrollment_no' AND `class_id`='$class_id' AND `session_id`='$session_id' AND `fee_id`='$fee_id' AND `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting class fee: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $fee_value=$row['fee_value'];               
            
                $data[] = $row;
         }

     return $data;    
}
public function getStudentSiblings($enrollment_no,$school_code)
{

    $server_name=$_SERVER['SERVER_NAME'];
    $session_id=$this->getCurrentSession($school_code);

    $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`father_name`FROM `tm_student_admission` WHERE `student_enrollment_no`='$enrollment_no' AND `status`!='InActive'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                        $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $row['class']=$class;

                         $siblings=$this->getSiblingsDetails($enrollment_no,$school_code);
                         $row['siblings']=$siblings;

                        $data[] = $row;
                 }             
         }
         else{
            return $result;

         }

         return $data;
    
}
public function getSiblingsDetails($enrollment_no,$school_code)
{
    $session_id=$this->getCurrentSession($school_code);
    $sql="SELECT `sib_enrollment_no` FROM `tm_student_siblings` WHERE INSTR(`sib_enrollment_no` ,'$enrollment_no') AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting siblings: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $sib_enrollment_no=$row['sib_enrollment_no']; 
                $arr= explode(',', $sib_enrollment_no);
            
                for ($i=0; $i <sizeof($arr) ; $i++) { 
                    $enrollment_no=$arr[$i];
                    $sib=$this->findStudent($enrollment_no,$session_id,$aadhar_no,$school_code);
                    $sibdata[]=$sib[0];
                }
                $row=$sibdata;         
             $data[]= $row;
         }

    return $data[0];

}


public function getAllSiblings($school_code)
{

    $common=new Common();
    $sql="SELECT `sib_enrollment_no` FROM `tm_student_siblings` WHERE  `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting siblings: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $sib_enrollment_no=$row['sib_enrollment_no']; 
                $arr= explode(',', $sib_enrollment_no);
            
                unset($sibdata);
                for ($i=0; $i <sizeof($arr) ; $i++) { 
                    $enrollment_no=$arr[$i];
                     //echo $enrollment_no.'/';
                    $session_id=$common->getStudentLastSession($enrollment_no,$school_code);
                    //echo $session_id.'/';
                    $sib=$this->getStudentDetails($enrollment_no,$session_id,$school_code);
                    if($sib)
                    {
                         $sibdata[]=$sib[0];
                    }
                   
                }
                $row['siblings_details']=$sibdata;         
             $data[]= $row;
         }

    return $data;
    
}

public function getSpecialCaseStudents($session_id,$school_code)
{
    $sql="SELECT `student_id`, `class_id` FROM `tm_fee_special_case` WHERE `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code' GROUP BY  `student_id`";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting special students: '.mysqli_error($this->conn));                                    
         while ($row = $result->fetch_assoc()) {
                $student_id=$row['student_id'];
                $class_id=$row['class_id'];               

                $student=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);  
                $row['student_details']=$student;  
                $fee_details=$this->getStudentSpecialFee($student_id,$session_id,$class_id,$school_code);
                $row['fee_details']=$fee_details;
                $data[]= $row;
         }

    return $data;
    
}


public function getClassFee($session_id,$class_id,$fee_id)
{
    $sql="SELECT `fee_value` FROM `tm_class_fee` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id`='$fee_id' AND `status`='Active'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting class fee: '.mysqli_error($this->conn));                                    
         while ($row = $result->fetch_assoc()) {
               
                $data[]= $row;
         }

    return $data[0]['fee_value'];
    
}
public function getGuestDashBoard()
{

    $dashboard['banners']=$this->getAppBanners();
    $dashboard['news_and_updates']=$this->getNewsAndUpdates();
    $dashboard['facility']=$this->getFacilities();
    $dashboard['faculty']=$this->getOurFaculty();
    $dashboard['events']=$this->getImageGallery();
    $dashboard['infrastructure']=$this->getInfrastructure();
    $dashboard['class']=$this->getClassWithSection();
    $dashboard['directors']=$this->getDirectors();
    $dashboard['awards']=$this->getAwards();
    $dashboard['features']=$this->getSchoolFeatures();
    

    $response[]=$dashboard;

    return $response;

}
public function getFacilities()
{
    unset($data);
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `facility_id`,`facility_name`,`facility_type`,`facility_description`,`facility_img_dir` FROM `tm_facility_master` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  facilities : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $facility_img_dir=$row['facility_img_dir'];
                        $img='http://'.$server_name."/".$facility_img_dir;
                        $row['facility_img_dir']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }             
         }
         return $data;
        
    
}
public function getAppBanners()
{
    unset($data);
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `banner_id`,`banner_caption`,`banner_img_dir` FROM `tm_app_banner` WHERE `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  banners : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $banner_img_dir=$row['banner_img_dir'];
                        $img='http://'.$server_name."/".$banner_img_dir;
                        $row['banner_img_dir']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }             
         }
         return $data;
        
    
}

public function getOurFaculty()
{
    $server_name=$_SERVER['SERVER_NAME'];

     $sql="SELECT a.`staff_id`,a.`staff_name`,a.`department_id`,b.`department_name`,a.`staff_gender`,a.`staff_image_path`FROM `tm_staff_master` a LEFT JOIN `tm_department` b ON a.`department_id`=b.`department_id`  WHERE  a.`status`!='InActive'";

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting faculty: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $staff_image_path=$row['staff_image_path'];
                $img='http://'.$server_name."/".$staff_image_path;
                $row['staff_image_path']=trim(preg_replace('/\s\s+/', '', $img));            
                $data[] = $row;
         }

     return $data;    
}
public function getInfrastructure()
{
    unset($data);
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `building_id`,`building_name`,`description`,`bulding_img_dir`,`image_names` FROM `tm_infrastructure` WHERE `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  infrastruture : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $bulding_img_dir=$row['bulding_img_dir'];
                        $image_names=$row['image_names'];
                        unset($temp);
                        unset($image_path);
                        $temp=explode('#', $image_names);

                        for ($i=0; $i <count($temp) ; $i++) { 
                            $img='http://'.$server_name."/".$bulding_img_dir.$temp[$i];
                            $image_path[]['image_url']=trim(preg_replace('/\s\s+/', '', $img));
                    
                            
                        }
                        $row['images']=$image_path;
                        
                        $data[] = $row;
                 }             
         }
         return $data;
        
    
}
public function getNewsAndUpdates()
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `news_id`,`news_updates_title`,`news_updates`,`authority`,`authority_name`,`news_img_dir`,`date_added` FROM `tm_news_and_updates` WHERE `status`='Active'";   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  news and updates :'.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $news_img_dir=$row['news_img_dir'];
                        $img='http://'.$server_name."/".$news_img_dir;
                        $row['image_url']=trim(preg_replace('/\s\s+/', '', $img));  
                        $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getDirectors()
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `director_id`,`director_name`,`position`,`qualification`,`experience`,`director_img_dir`,`about_director`,`director_message` FROM `tm_directors` WHERE `status`='Active'";   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  directors :'.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $director_img_dir=$row['director_img_dir'];
                        $img='http://'.$server_name."/".$director_img_dir;
                        $row['image_url']=trim(preg_replace('/\s\s+/', '', $img));  
                        $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getAwards()
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `award_id`,`award_name`,`award_img_dir`,`awarded_by`,`date` FROM `tm_school_awards` WHERE `status`='Active'";   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  award :'.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $award_img_dir=$row['award_img_dir'];
                        $img='http://'.$server_name."/".$award_img_dir;
                        $row['image_url']=trim(preg_replace('/\s\s+/', '', $img));  
                        $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getSchoolFeatures()
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `feature_id`,`feature_name`,`feature_img_dir` FROM `tm_school_features` WHERE `status`='Active'";   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  award :'.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $feature_img_dir=$row['feature_img_dir'];
                        $img='http://'.$server_name."/".$feature_img_dir;
                        $row['image_url']=trim(preg_replace('/\s\s+/', '', $img));  
                        $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getPaymentHistory($student_id,$session_id,$school_code)
{
    $aadhar_no="";
    $student = $this->findStudent($student_id,$session_id,$aadhar_no,$school_code);
    $data['student_details']=$student;

    $sql="SELECT `transaction_id`,`session_id`,`student_id`,`class_id`,`section_id`,`paid_amount`,`remark`,`payment_mode`,`transaction_date`,`transaction_for`,`date_added` FROM `tm_transaction_master` WHERE `student_id`='$student_id' AND `session_id`='$session_id'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  payment history : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        
                        $data2[] = $row;
                 }             
         }
         $data['payment_history']=$data2;
         $response[]=$data;
         return $response;
            
}

public function getPaymentDetails($transaction_id,$school_code)
{

    $aadhar_no="";
    $payee=$this->getPaymentPayeeId($transaction_id,$school_code);
    $student_id=$payee[0]['student_id'];
    $session_id=$payee[0]['session_id'];

    $student = $this->findStudent($student_id,$session_id,$aadhar_no,$school_code);
    $data['student_details']=$student;

    $sql="SELECT a.`transaction_id`,a.`student_id`,a.`class_id`,a.`section_id`,a.`session_id`,a.`fee_id`,b.`fee_name`,a.`fee_payable`,a.`fee_paid`,a.`year_month`,a.`date_added` FROM `tm_fee_payment` a LEFT jOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code') b ON a.`fee_id`=b.`fee_id` WHERE a.`transaction_id`='$transaction_id' AND a.`school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  payment details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $data2[] = $row;
                 }             
         }
         $data['payment_details']=$data2;
         $response[]=$data;
         return $response;
            
}

public function getPaymentPayeeId($transaction_id,$school_code)
{
   
    $sql="SELECT `transaction_id`,`session_id`,`student_id` FROM `tm_transaction_master` WHERE  `transaction_id`='$transaction_id' AND `school_code`='$school_code' ";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Payment Payee Id : '.mysqli_error($this->conn));
             while ($row = $result->fetch_assoc()) {
        
                    
                    $data[] = $row;
             }             
     
        return $data;
            
}


public function getAllTransaction($session_id,$school_code)
{
   
    $sql="SELECT `transaction_id`,`session_id`,`student_id`,`class_id`,`section_id`,`paid_amount`,`remark`,`payment_mode`,`transaction_date`,`transaction_for`,`date_added` FROM `tm_transaction_master` WHERE  `session_id`='$session_id' AND `school_code`='$school_code' ORDER BY `id` DESC";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  all  transaction : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        
                        $data[] = $row;
                 }             
         }
                return $data;
            
}

public function getRouteList($school_code)
{
    $FLAG_COUNT=true;
    $sql="SELECT `route_id`,`route_name`,`start_from`,`end_to`,`route_distance` FROM `tm_route_master` WHERE `status`='Active' AND `school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  route list : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     $route_id=$row['route_id'];               
                     $pickup_points=$this->getPickupPoints($route_id,$FLAG_COUNT,$school_code);  
                     $row['pickup_points']=$pickup_points; 
            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getPickupPoints($route_id,$FLAG_COUNT,$school_code)
{
    $session_id=$this->getCurrentSession($school_code);
    $sql="SELECT `route_id`,`pickup_point_id`,`pickup_point_name`,`distance_from_school`,`geolocation` FROM `tm_route_pickup_points` WHERE `route_id`='$route_id' AND `status`='Active' AND `school_code`='$school_code' ";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  pickup points : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $pickup_point_id=$row['pickup_point_id'];
                        // $student=$this->getTransportStudentOfPickupPoint($pickup_point_id,$session_id,$FLAG_COUNT,$school_code);  
                        $row['students']=$student; 
                        $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getTransportStudentOfPickupPoint($pickup_point_id,$session_id,$FLAG_COUNT,$school_code)
{
    $sql="SELECT `student_id` FROM `tm_transport_student` WHERE `session_id`='$session_id' AND `pickup_point_id`='$pickup_point_id' AND `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Transport Student Of PickupPoint: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     $student_id=$row['student_id']; 
                     $student = $this->findStudent($student_id,$session_id,$aadhar_no,$school_code);
                     
                     if(!$FLAG_COUNT)
                     {
                      $transport = $this->getStudentTransportDetails($student_id,$session_id,$school_code);
                      $student[0]['transport_info'] = $transport;
                     }
                     
                     $data[] = $student[0];
                 }             
         }
         if($FLAG_COUNT)
         {
            return count($data);
         }
         else{
            return $data;
         }

         
            
}
public function getAllVehicles($school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `vehicle_id`,`vehicle_name`,`vehicle_number`,`vehicle_type`,`vehicle_image_url` FROM `tm_vehicle_master` WHERE `status`='Active' AND `school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  vehicles : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $vehicle_image_url=$row['vehicle_image_url'];
                        $img='http://'.$server_name."/".$vehicle_image_url;
                        $row['vehicle_image_url']=trim(preg_replace('/\s\s+/', '', $img)); 
                        $data[] = $row;
                 }             
         }
         return $data;
            
}

public function getVehicleDetails($vehicle_id)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `vehicle_id`,`vehicle_name`,`vehicle_number`,`vehicle_type`,`vehicle_image_url` FROM `tm_vehicle_master` WHERE `status`='Active' AND `vehicle_id`='$vehicle_id'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  vehicles : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
            
                        $vehicle_image_url=$row['vehicle_image_url'];
                        $img='http://'.$server_name."/".$vehicle_image_url;
                        $row['vehicle_image_url']=trim(preg_replace('/\s\s+/', '', $img)); 

                        $routes=$this->getVehicleRoutes($vehicle_id);
                        $row['route_list']=$routes;
                        $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getVehicleRoutes($vehicle_id)
{
    $sql="SELECT a.`pickup_round_id`,a.`route_id`,a.`start_pickup`,b.`route_name`,b.`start_from`,b.`end_to`,b.`route_distance` FROM `tm_vehicle_pickup_round` a LEFT JOIN `tm_route_master` b ON a.`route_id`=b.`route_id` WHERE a.`vehicle_id`='$vehicle_id' AND a.`status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  route list : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                                   
                     $pickup_round_id=$row['pickup_round_id']; 
                     $FLAG_COUNT=true;             
                     $pickups=$this->getVehicleActivePickupOfRound($pickup_round_id,$FLAG_COUNT);  
                     $row['active_pickups']=$pickups; 
            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getAllRouteVehicle()
{
    $FLAG_COUNT=false;   
    $sql="SELECT `route_id`,`route_name`,`start_from`,`end_to`,`route_distance` FROM `tm_route_master` WHERE `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  route list : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     $route_id=$row['route_id'];              
                     $vehicle=$this->getVehicleOfRoute($route_id,$FLAG_COUNT);  
                     $row['vehicles']=$vehicle; 
            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getVehicleOfRoute($route_id,$FLAG_COUNT)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT a.`pickup_round_id`,a.`vehicle_id`,a.`route_id`,a.`start_pickup`,b.`vehicle_name`,b.`vehicle_number`,b.`vehicle_type`,b.`vehicle_image_url` FROM `tm_vehicle_pickup_round` a LEFT JOIN `tm_vehicle_master` b ON a.`vehicle_id`=b.`vehicle_id` WHERE a.`route_id`='$route_id' AND a.`status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  route vehicle : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                       $vehicle_image_url=$row['vehicle_image_url'];
                        $img='http://'.$server_name."/".$vehicle_image_url;
                        $row['vehicle_image_url']=trim(preg_replace('/\s\s+/', '', $img)); 

                     $pickup_round_id=$row['pickup_round_id'];                               
                     $pickups=$this->getVehicleActivePickupOfRound($pickup_round_id,$FLAG_COUNT);  
                     $row['active_pickups']=$pickups; 
            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getVehicleActivePickupOfRound($pickup_round_id,$FLAG_COUNT)
{
    $session_id=$this->getCurrentSession();
    $sql="SELECT a.`active_pickup_points` AS pickup_point_id ,a.`pickup_time`,a.`pickup_index`,b.`pickup_pont_name`,b.`distance_from_school`,b.`geolocation` FROM `tm_vehicle_route_active_pickups`a LEFT JOIN `tm_route_pickup_points` b ON a.`active_pickup_points`=b.`pickup_point_id` AND a.`route_id`=b.`route_id` WHERE a.`pickup_round_id`='$pickup_round_id' AND a.`status`='Active' ORDER BY a.`pickup_index` ASC";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  active pickup points : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     $pickup_point_id=$row['pickup_point_id'];              
                     $student=$this->getTransportStudentOfPickupPointOfRound($pickup_round_id,$pickup_point_id,$session_id,$FLAG_COUNT);  
                     $row['students']=$student; 
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getTransportStudentOfPickupPointOfRound($pickup_round_id,$pickup_point_id,$session_id,$FLAG_COUNT)
{
    $sql="SELECT `student_id` FROM `tm_transport_student` WHERE `session_id`='$session_id' AND `pickup_round_id`='$pickup_round_id' AND `pickup_point_id`='$pickup_point_id' AND `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Transport Student Of PickupPoint Of Round : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     $student_id=$row['student_id']; 
                     $student = $this->findStudent($student_id,$session_id,$aadhar_no);
                     $data[] = $student[0];
                 }             
         }
         if($FLAG_COUNT)
         {
            return count($data);
         }
         else{
            return $data;
         }

         
            
}
public function getTransportStudent($session_id,$school_code)
{
    $sql="SELECT `student_id` FROM `tm_transport_student` WHERE `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Transport Student  : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                    
                     $student_id=$row['student_id']; 
                     $student= $this->findStudent($student_id,$session_id,$aadhar_no,$school_code);
                     $transport = $this->getStudentTransportDetails($student_id,$session_id,$school_code);
                     $student[0]['transport_info'] = $transport;
                     $data[]=$student[0];
                 }             
         }
         return $data;
            
}
public function getStudentTransportDetails($student_id,$session_id,$school_code)
{
    $sql="SELECT a.`vehicle_id`,c.`vehicle_name`,c.`vehicle_number`,c.`vehicle_type`,c.`vehicle_image_url`,a.`pickup_round_id`,a.`pickup_point_id`,e.`pickup_point_name`,e.`distance_from_school`,e.`geolocation`,b.`route_id`,d.`route_name`,b.`pickup_time`,a.`applicable_month`,a.`transport_fee`  FROM `tm_transport_student` a LEFT JOIN `tm_vehicle_route_active_pickups` b ON a.`vehicle_id`=b.`vehicle_id` AND a.`pickup_round_id`=b.`pickup_round_id` AND a.`pickup_point_id`=b.`active_pickup_points` LEFT JOIN `tm_vehicle_master`c ON a.`vehicle_id`=c.`vehicle_id` LEFT JOIN `tm_route_master` d ON b.`route_id`=d.`route_id` LEFT JOIN `tm_route_pickup_points` e ON b.`route_id`=e.`route_id` AND a.`pickup_point_id`=e.`pickup_point_id` WHERE a.`student_id`='$student_id' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code' AND a.`status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   Student  transport details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getVehicleRouteDetails($pickup_round_id)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $session_id=$this->getCurrentSession();
    $sql="SELECT a.`pickup_round_id`,a.`vehicle_id`,c.`vehicle_name`,c.`vehicle_number`,c.`vehicle_type`,c.`vehicle_image_url`,a.`route_id`,d.`route_name`,d.`start_from`,d.`end_to`,d.`route_distance`,a.`active_pickup_points` AS pickup_point_id ,a.`pickup_time`,a.`pickup_index`,b.`pickup_pont_name`,b.`distance_from_school`,b.`geolocation` FROM `tm_vehicle_route_active_pickups`a LEFT JOIN `tm_route_pickup_points` b ON a.`active_pickup_points`=b.`pickup_point_id` AND a.`route_id`=b.`route_id` LEFT JOIN `tm_vehicle_master`c ON a.`vehicle_id`=c.`vehicle_id` LEFT JOIN `tm_route_master` d ON a.`route_id`=d.`route_id` WHERE a.`pickup_round_id`='$pickup_round_id' AND a.`status`='Active' ORDER BY a.`pickup_index` ASC"; 
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  active pickup points : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $vehicle_image_url=$row['vehicle_image_url'];
                        $img='http://'.$server_name."/".$vehicle_image_url;
                        $row['vehicle_image_url']=trim(preg_replace('/\s\s+/', '', $img)); 


                     $pickup_point_id=$row['pickup_point_id'];              
                     $student=$this->getTransportStudentOfPickupPointOfRound($pickup_round_id,$pickup_point_id,$session_id,$FLAG_COUNT);  
                     $row['students']=$student; 
                     $data[] = $row;
                 }             
         }
         return $data;
            
}


public function getAllPickupPoint($school_code)
{
    $session_id=$this->getCurrentSession($school_code);
    $sql="SELECT `pickup_point_id`,`pickup_point_name`,`distance_from_school`,`geolocation` FROM `tm_route_pickup_points` WHERE `status`='Active' AND `school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  all pickup point : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                         /*$FLAG_COUNT=true;
                         $pickup_point_id=$row['pickup_point_id'];
                         $student=$this->getTransportStudentOfPickupPoint($pickup_point_id,$session_id,$FLAG_COUNT);  
                         $row['student']=$student; */
                
                     $data[] = $row;
                 }             
         }
         return $data;
            
}

public function getRouteDetails($route_id)
{
    
    $sql="SELECT `route_id`,`route_name`,`start_from`,`end_to`,`route_distance` FROM `tm_route_master` WHERE `route_id`='$route_id' AND `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  route details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                     $route_id=$row['route_id']; 
                    
                     $vehicle=$this->getVehicleOnRoute_BasicInfo($route_id);  
                     $row['vehicles_on_route']=$vehicle;   

                     $FLAG_COUNT=false;
                     $pickup_points=$this->getPickupPoints($route_id,$FLAG_COUNT); 
                     for ($i=0; $i <count($pickup_points) ; $i++) { 
                          $row2=$pickup_points[$i];
                          $pickup_point_id=$row2['pickup_point_id'];
                          $row2['vehicle_on_pickup_point']=$this->getVehicleOnPickupPoint_BasicInfo($pickup_point_id);
                          $pickup_points[$i]=$row2;
                      } 
                     $row['pickup_points']=$pickup_points; 
            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getVehicleOnRoute_BasicInfo($route_id)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT a.`pickup_round_id`,a.`vehicle_id`,a.`route_id`,a.`start_pickup`,b.`vehicle_name`,b.`vehicle_number`,b.`vehicle_type`,b.`vehicle_image_url` FROM `tm_vehicle_pickup_round` a LEFT JOIN `tm_vehicle_master` b ON a.`vehicle_id`=b.`vehicle_id` WHERE a.`route_id`='$route_id' AND a.`status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  vehicle on route  : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                       $vehicle_image_url=$row['vehicle_image_url'];
                        $img='http://'.$server_name."/".$vehicle_image_url;
                        $row['vehicle_image_url']=trim(preg_replace('/\s\s+/', '', $img)); 

            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getVehicleOnPickupPoint_BasicInfo($pickup_point_id)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT a.`pickup_round_id`,a.`vehicle_id`,a.`active_pickup_points`,a.`pickup_time`,b.`vehicle_name`,b.`vehicle_number`,b.`vehicle_type`,b.`vehicle_image_url` FROM `tm_vehicle_route_active_pickups` a LEFT JOIN `tm_vehicle_master` b ON a.`vehicle_id`=b.`vehicle_id` WHERE a.`active_pickup_points`='$pickup_point_id' AND a.`status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   vehicle on pickup point: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                       $vehicle_image_url=$row['vehicle_image_url'];
                        $img='http://'.$server_name."/".$vehicle_image_url;
                        $row['vehicle_image_url']=trim(preg_replace('/\s\s+/', '', $img)); 

            
                     $data[] = $row;
                 }             
         }
         return $data;
            
}


public function getExamList($session_id,$school_code)
{
    $FLAG_COUNT=false;
    $sql="SELECT a.`exam_id`,a.`exam_name`,a.`session_id`,a.`start_date`,a.`status`,b.`status_name` FROM `tm_exam_master` a LEFT jOIN `tm_exam_status` b ON a.`status`=b.`status_code` WHERE a.`session_id`='$session_id' AND a.`status`!='InActive' AND a.`school_code`='$school_code' ORDER BY a.`id` DESC";  

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   exam list: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                    $exam_id=$row['exam_id'];
                    $session_id=$row['session_id'];
                    $participatingclass=$this->getExamParticipatingClass($session_id,$exam_id,$FLAG_COUNT,$school_code);
                    $row['participating_class']=count($participatingclass);
                    $row['participating_class_list']=$participatingclass;
                    
                    $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getExamParticipatingClass($session_id,$exam_id,$FLAG_COUNT,$school_code)
{
    unset($data);
    $sql="SELECT a.`exam_id`,a.`class_id`,b.`class_name`,a.`section_id`,c.`section_name`,a.`subject_ids` FROM `tm_exam_participating_class` a LEFT JOIN (SELECT * FROM `tm_class` WHERE `school_code`='$school_code' AND `session_id`='$session_id') b ON a.`class_id`=b.`class_id` LEFT JOIN `tm_section_master`c ON a.`section_id`=c.`section_id` WHERE a.`exam_id`='$exam_id'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   exam participating class: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

                    $data[] = $row;
                 }             
         }
         if($FLAG_COUNT)
         {
            return count($data);
         }
         else{
           return $data; 
         }        
            
}
public function getExamClassResultStatus($exam_id,$session_id,$class_id,$section_id,$school_code)
{
    
     $sql="SELECT `subject_ids` FROM `tm_exam_participating_class` WHERE `exam_id`='$exam_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `status`='Active' AND `school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   exam  class status: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

                    unset($subject_data);
                    
                    
                    $student=$this->getClassSectionStudents($class_id,$section_id,$session_id,$school_code);
                    $total_student=count($student);
                    $row['student']=$total_student;

                    $subject_ids=$row['subject_ids'];
                    $arrSubject_ids= explode(',', $subject_ids);
                        for ($i=0; $i <count($arrSubject_ids); $i++) { 
                            unset($subject);

                           $subject_id=$arrSubject_ids[$i];                       

                            $subject=$this->getSingleSubjectDetails($class_id,$subject_id,$session_id,$school_code);
                            $subject_paper=$this->getSubjectPaper($exam_id,$class_id,$section_id,$subject_id,$school_code);
                            

                            unset($subject_paper_data);

                            for ($j=0; $j <count($subject_paper) ; $j++) { 
                                
                               $exam_paper_id=$subject_paper[$j]['exam_paper_id'];
                               $sub=$this->getClassSubjectMarkStatus($exam_id,$exam_paper_id,$class_id,$section_id,$subject_id,$total_student);
                               $subject_paper_data[]=$subject_paper[$j]+$sub[0];

                            }

                            $subject[0]['subject_paper']=$subject_paper_data;

                            $subject_data[]=$subject[0];
                        }
                        $row['subjects']=$subject_data;
                    $data[] = $row;
                 }             
         }
        return $data; 
}
public function getClassSubjectMarkStatus($exam_id,$exam_paper_id,$class_id,$section_id,$subject_id,$total_student)
{

                $FLAG_COUNT=true;
   
               $row['total_student']=$total_student;
                $student_mark_added=$this->getStudent_MarkAdded_InExam($exam_id,$exam_paper_id,$class_id,$section_id,$subject_id,$FLAG_COUNT);
                $row['student_mark_added']=$student_mark_added;
                $student_absent=$this->getStudent_Absent_InExam($exam_id,$exam_paper_id,$class_id,$section_id,$subject_id,$FLAG_COUNT);
                $row['student_absent']=$student_absent;
                $row['student_mark_not_added']=$total_student-($student_mark_added+$student_absent);
                $data[] = $row;

     return $data;    
}
public function getStudent_MarkAdded_InExam($exam_id,$exam_paper_id,$class_id,$section_id,$subject_id,$FLAG_COUNT)
{

     $sql="SELECT `student_id` FROM `tm_exam_student_mark` WHERE `exam_id`='$exam_id' AND  `exam_paper_id`='$exam_paper_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id'
        AND `obtained_mark`!='AA' AND `obtained_mark`!='AB'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student mark added: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {       
                $data[] = $row;
         }
    if($FLAG_COUNT)
    {
     return count($data);    
    }
    else{
        return $data; 
    }
}
public function getStudent_Absent_InExam($exam_id,$exam_paper_id,$class_id,$section_id,$subject_id,$FLAG_COUNT)
{

     $sql="SELECT `student_id` FROM `tm_exam_student_mark` WHERE `exam_id`='$exam_id' AND  `exam_paper_id`='$exam_paper_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' 
      AND (`obtained_mark`='AA' OR `obtained_mark`='A')";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student mark added: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {       
                $data[] = $row;
         }
    if($FLAG_COUNT)
    {
     return count($data);    
    }
    else{
        return $data; 
    }
}




public function getClassStudentMarks($session_id,$exam_id,$class_id,$section_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,b.`sr_admission_no`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN  `tm_student_admission` b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $student_enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($student_enrollment_no,$session_id,$school_code);
                        $row['class']=$class;

                         $mark=$this->getStudentMarks($session_id,$exam_id,$class_id,$section_id,$student_enrollment_no,$school_code);
                        
                        $row['mark_details']=$mark;
                        $data[] = $row;
                 }
        return $data;

    /*$sql="SELECT `student_enrollment_no` FROM `tm_student_class` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students marks: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_enrollment_no=$row['student_enrollment_no'];
                        $aadhar_no="";
                        $student=$this->getStudentDetails($student_enrollment_no,$session_id,$school_code);
                        //$mark=$this->getStudentMarks($session_id,$exam_id,$class_id,$section_id,$student_enrollment_no,$school_code);
                        $student[0]['mark_details']=$mark;

                        $data[] = $student[0];
                 }
        return $data;*/

}


public function getStudentMarks($session_id,$exam_id,$class_id,$section_id,$student_id,$school_code)
{
    unset($data);
    $sql="SELECT `subject_ids` FROM `tm_exam_participating_class` WHERE `exam_id`='$exam_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `status`='Active' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students marks: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $subject_ids=$row['subject_ids'];
                        $arrSubject_ids= explode(',', $subject_ids);
                        
                        for ($i=0; $i <count($arrSubject_ids); $i++) { 
                            unset($subject);
                            $subject_id=$arrSubject_ids[$i];                       

                            $subject=$this->getSingleSubjectDetails($class_id,$subject_id,$session_id,$school_code);
                            $subject_paper=$this->getSubjectPaper($exam_id,$class_id,$section_id,$subject_id,$school_code);
                            

                            for ($j=0; $j <count($subject_paper) ; $j++) {

                                unset($mark);
                                $exam_paper_id=$subject_paper[$j]['exam_paper_id'];  
                                $mark=$this->getStudentSubjectMark($exam_id,$session_id,$exam_paper_id,$subject_id,$class_id,$section_id,$student_id,$school_code);                         
                                $subject_paper[$j]['mark']=$mark;
                             
                            }
                            $subject[0]['subject_paper']=$subject_paper;

                            $subject_data[]=$subject[0];
                        }
                        $row['subjects']=$subject_data;    
                        $data[] = $row;                  
                 }
        return $data;

}
public function getStudentSubjectMark($exam_id,$session_id,$exam_paper_id,$subject_id,$class_id,$section_id,$student_id,$school_code)
{

    unset($data);
    $sql="SELECT a.`subject_id`,b.`subject_name`,a.`is_mark_system`,a.`obtained_mark`,a.`max_mark`,a.`is_grade_system`,a.`max_grade`,a.`grade_obtained` FROM `tm_exam_student_mark`a LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code') b ON a.`subject_id`=b.`subject_id` WHERE a.`exam_id`='$exam_id' AND a.`exam_paper_id`='$exam_paper_id' AND a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`subject_id`='$subject_id' AND a.`student_id`='$student_id'AND a.`school_code`='$school_code'" ;
   
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students marks: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                                              
                        $data[] = $row;
                 }

        return $data;     
        

}

public function getStudentExamResult($session_id,$exam_id,$class_id,$section_id,$student_id,$school_code)
{

        $data=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);
        $result=$this->getStudentMarks($session_id,$exam_id,$class_id,$section_id,$student_id,$school_code);
        $data[0]['result']=$result;

        $rank=$this->getExamStudentRank($student_id,$exam_id,$class_id, $section_id,$session_id,$school_code);
        $data[0]['rank']=$rank;
        return $data;     
        

}
public function getExamStudentRank($key_student_id,$exam_id,$class_id, $section_id,$session_id,$school_code)
{
    $rank=0;
    $sql="SELECT a.`student_id`,SUM(a.`obtained_mark`) As obtained_mark,SUM(a.`max_mark`) As max_mark,a.`exam_id`,a.`class_id`,a.`section_id`,a.`session_id`,b.`class_id`,b.`section_id`,b.`student_roll_no`,b.`session_id` FROM `tm_exam_student_mark` a  LEFT JOIN (SELECT * FROM `tm_student_class` WHERE `school_code` = '$school_code' AND `class_id` = '$class_id' AND `section_id` = '$section_id' AND `session_id`='$session_id') b ON a.`student_id`=b.`student_enrollment_no` WHERE a.`school_code`='$school_code' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`exam_id`='$exam_id' GROUP BY a.`student_id` ORDER BY obtained_mark DESC";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   exam class section rank: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                    $rank=$rank+1;
                    $student_id=$row['student_id'];
                    if($student_id==$key_student_id)
                    {
                        return $rank;
                    }
                    
                 }             
         }

         return 0;
            
}


public function getStudentReportCard($student_id,$class_id,$section_id,$session_id,$report_card_id,$school_code)
{

        $data=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);

        $ExamInReportCard=$this->getReportCardExamList($student_id,$class_id,$section_id,$session_id,$report_card_id,$school_code);
        $data[0]['ExamInReportCard']=$ExamInReportCard;

        $ReportCardMarkingSystem=$this->getReportCardMarkingSystem($class_id,$section_id,$session_id,$report_card_id,$school_code);
        $data[0]['ReportCardMarkingSystem']=$ReportCardMarkingSystem;

      
        return $data;     
        

}

public function getReportCardExamList($student_id,$class_id,$section_id,$session_id,$report_card_id,$school_code)
{
   
    $sql="SELECT a.`report_card_id`,a.`exam_id`,b.`exam_name`,a.`class_id`,a.`section_id`,a.`marking_system_id`,a.`marking_value_id` FROM `tm_exam_school_marking_system` a LEFT JOIN (SELECT * FROM `tm_exam_master` WHERE  `school_code`='$school_code') b ON a.`exam_id`=b.`exam_id` WHERE a.`report_card_id`='$report_card_id' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id'  AND a.`school_code`='$school_code' AND a.`status`='Active'"; 
    //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting report card   exam list: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                    $exam_id=$row['exam_id'];   
                    $mark=$this->getStudentMarks($session_id,$exam_id,$class_id,$section_id,$student_id,$school_code);
                    $row['result']=$mark;
                    $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getReportCardMarkingSystem($class_id,$section_id,$session_id,$report_card_id,$school_code)
{
   
    $sql="SELECT a.`report_card_id`,b.`report_card_name`,a.`exam_id`,a.`class_id`,a.`section_id`,a.`marking_system_id`,c.`marking_name`,a.`marking_value_id` FROM `tm_exam_school_marking_system` a LEFT  JOIN (SELECT * FROM `tm_exam_report_card` WHERE `report_card_id`='$report_card_id' AND `session_id`='$session_id' AND `school_code`='$school_code') b ON a.`report_card_id`=b.`report_card_id` LEFT JOIN `tm_exam_marking_system_master` c ON a.`marking_system_id`=c.`marking_system_id` WHERE a.`report_card_id`='$report_card_id' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id'  AND a.`school_code`='$school_code' AND a.`status`='Active' LIMIT 1"; 
    //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   ReportCardMarkingSystem: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                    $marking_system_id=$row['marking_system_id'];   
                    $marking_value_id=$row['marking_value_id'];   
                    $MarkingSystemValue=$this->getSchoolReportCardMarkingSystemValue($marking_system_id,$marking_value_id,$school_code);
                    $row['MarkingSystemValue']=$MarkingSystemValue;
                    $data[] = $row;
                 }             
         }
         return $data;
            
}
public function getSchoolReportCardMarkingSystemValue($marking_system_id,$marking_value_id,$school_code){
   
    $sql=" SELECT `from_value`,`to_value`,`marking`,`remark`,`performance_descriptors`,`result` FROM `tm_exam_school_marking_system_value` WHERE `marking_system_id`='$marking_system_id' AND `marking_value_id`='$marking_value_id' AND `school_code`='$school_code' AND `status`='Active'"; 
    //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting ReportCardMarkingSystemValue: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                   
                    $data[] = $row;
                 }             
         }
         return $data;


}

public function getSchoolRepordCardList($school_code)
{
   
    $sql="SELECT `school_code`,`session_id`,`report_card_id`,`report_card_name` FROM `tm_exam_report_card` WHERE `school_code`='$school_code' AND `status_code`='1'"; 
    //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting SchoolProgressCardList: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                   
                    $data[] = $row;
                 }             
         }
         return $data;


}

public function getExamClassSectionRank($exam_id,$class_id, $section_id,$session_id,$school_code)
{
    
    $sql="SELECT a.`student_id`,SUM(a.`obtained_mark`) As obtained_mark,SUM(a.`max_mark`) As max_mark,a.`exam_id`,a.`class_id`,a.`section_id`,a.`session_id`,b.`class_id`,b.`section_id`,b.`student_roll_no`,b.`session_id` FROM `tm_exam_student_mark` a  LEFT JOIN (SELECT * FROM `tm_student_class` WHERE `school_code` = '$school_code' AND `class_id` = '$class_id' AND `section_id` = '$section_id' AND `session_id`='$session_id') b ON a.`student_id`=b.`student_enrollment_no` WHERE a.`school_code`='$school_code' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`exam_id`='$exam_id' GROUP BY a.`student_id` ORDER BY obtained_mark DESC";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   exam class section rank: '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                    $student_id=$row['student_id'];
                    $data=$this->getStudentDetails($student_id,$session_id,$school_code);
                    $temp[0]=$row;
                    $data[0]['rank']=$temp;
                    
                    $data2[] = $data[0];
                 }             
         }
         return $data2;
            
}


public function getSubjectName($subject_id,$school_code)
{

     $sql="SELECT `subject_name` FROM `tm_subject` WHERE `status`='Active' AND `subject_id`='$subject_id' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject name: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data[0]['subject_name'];    
}

public function getTransportFeeStructure($session_id)
{

     $sql="SELECT `session_id`,`distance_from`,`distance_to`,`transport_fee`,`vehicle_type` FROM `tm_transport_fee_structure` WHERE `session_id`='$session_id' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  transport fee structure '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

//......................Time Table.....................................................................
public function getTimeSlot()
{

     $sql="SELECT `time_slot_id`,`time_slot_name`,`school_start_time`,`prayer_time`,`period_start`,`period_duration`,`number_of_period`,`period_before_lunch`,`period_after_lunch` FROM `tm_time_slot` WHERE `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  time slot: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

//....................Vendor................................................................
public function getVendorList($school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
     $sql="SELECT `vendor_id`,`vendor_name`,`address`,`phone`,`email`,`description`,`vendor_img_dir` FROM `tm_vendor` WHERE `status`='Active' AND `school_code`='$school_code'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  vendor: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $vendor_img_dir=$row['icons_dir'];
                $img='http://'.$server_name."/".$vendor_img_dir;
                $row['vendor_img_dir']=trim(preg_replace('/\s\s+/', '', $img));
            
                $data[] = $row;
         }

     return $data;    
}
//.....................................Accessories..............................................

public function getAccessoriesCategory($school_code)
{
     $sql="SELECT `category_id`,`category_name` FROM `tm_accessories_category` WHERE `status`='Active' AND `school_code`='$school_code'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories category: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

            
                $data[] = $row;
         }

     return $data;    
}
public function getAccessoriesPublication($school_code)
{
     $sql="SELECT `publication_id`,`publication_name`,`address`,`description` FROM `tm_accessories_publications` WHERE `status`='Active' AND `school_code`='$school_code'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories publication: '.mysqli_error($this->conn));

                                     
         while ($row = $result->fetch_assoc()) {

            
                $data[] = $row;
         }

     return $data;    
}

public function getSpecialFee($school_code)
{
     $sql="SELECT `fee_id`,`fee_name`,`remark` FROM `tm_fee_special` WHERE `status`='Active' AND `school_code`='$school_code' ORDER BY `id` ASC";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  special fee: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

            
                $data[] = $row;
         }

     return $data;    
}

public function getAdmisionDashboard($session_id,$school_code)
{
    
    $total=$this->getTotalStudent_count($session_id,$school_code);
    $dashboard['total_student']=$total;

    return $dashboard;

}



public function getFeeCollectionByDate($date,$school_code)
{
    $sql="SELECT `transaction_id`,`student_id`,`class_id`,`section_id`,`staff_id`,`paid_amount`,`remark`,`payment_mode`,`transaction_date` FROM `tm_transaction_master` WHERE `transaction_date`='$date' AND `status`='2' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting fee by date: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $student_id=$row['student_id'];                         
                $student=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);  
                $row['student_details']=$student;  
            
                $data[] = $row;
         }

     return $data;    
}

public function getClassStudentOldDuelist($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN `tm_student_admission`b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                    
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;

                        $due=$this->getStudentOldDue($enrollment_no,$school_code);
                        $row['old_due']=$due;
                        $data[] = $row;
                 }
        return $data;     
}

public function getStudentOldDue($enrollment_no,$school_code)
{
    $sql="SELECT `school_code`,`student_id`,`due_id`,`session_name`,`amount`,`remark` FROM `tm_fee_old_due_student` WHERE `school_code`='$school_code' AND `student_id`='$enrollment_no' AND `status`='Active'";
  
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student old due: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $due_id=$row['due_id'];
                $amount_paid=$this->getStudentOldDuePaymentDetails($enrollment_no,$due_id,$school_code);
                $row['amount_paid']=$amount_paid;
                $data[] = $row;
         }

      return $data;

}
public function getStudentOldDuePaymentDetails($student_id,$due_id,$school_code)
{
    $sql="SELECT SUM(`amount_paid`) AS amount_paid FROM `tm_fee_old_due_payment` WHERE `student_id`='$student_id' AND `due_id`='$due_id' AND `school_code`='$school_code'";

   
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student old due payment details: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }
         if($data[0]['amount_paid']!=NULL)
         {
            return $data[0]['amount_paid'];
         }
         else{
            return '0';
         }

      

}
public function getClassStudentPaylist($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN `tm_student_admission`b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                    
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;



                        $pay=$this->getStudentPayDetails($enrollment_no,$class_id,$section_id,$session_id,$school_code);

                        $arr=explode('#',$pay);
                        $total_due=$arr[0];
                        $total_recieved=$arr[1];
                        $pay_data[0]['current_due']=$total_due;
                        $pay_data[0]['total_recieved']=$total_recieved;
                        $pay_data[0]['total_fee']=$arr[2];
                        $pay_data[0]['total_due']=$arr[3];
                        $pay_data[0]['due_settlement']=$arr[4];
                        $row['pay_details']=$pay_data;
                        $data[] = $row;
                 }
        return $data;     
}

public function getStudentPayDetails($enrollment_no,$class_id,$section_id,$session_id,$school_code)
{
    $current_due=0;
    $amount_recieved=0;
    $total_fee=0;
    $total_due=0;
    $due_settlement=0;

            $today=date('Y-m-d');
            $current_month=date('Y-m');
            //echo $enrollment_no;

            $start_date=$this->getSessionStartDate($session_id,$school_code);
            $end_date=$this->getSessionEndDate($session_id,$school_code);
             //echo $start_date;
            $count=$this->getNoOfMonth( $start_date,$end_date);
             //echo 'mm'.$count;
           for ($i=0; $i <=$count ; $i++) { 

            $month=date("Y-m",strtotime("+$i Months,$start_date"));
            $month2=date("F-Y",strtotime("+$i Months,$start_date"));
           // echo $month;
           
             $sql="SELECT a.`fee_id`,a.`fee_value`,b.`fee_name` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code' ) b ON a.`fee_id`=b.`fee_id` WHERE INSTR(  a.`applicable_month` , '$month' )  AND a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
             //echo $sql;
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {


                        $fee_id=$row['fee_id'];
                        unset($result2);


                        $sql="SELECT  `fee_id` ,`fee_payable`,SUM(  `fee_paid` ) AS fee_paid FROM  `tm_fee_payment` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id` = '$fee_id' AND `year_month` = '$month' AND `status` = '2' AND `school_code`='$school_code'";

                        $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee2 '.mysqli_error($this->conn));
                            $row2 = $result2->fetch_assoc();

                           
                            if($row2['fee_id']!=NULL)
                            {
                                if($row2['fee_payable']!=$row2['fee_paid'])
                                {
                                    
                                     $due=$row2['fee_payable']-$row2['fee_paid'];
                                     $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$due,$school_code);
                                     $arr=explode('#',$settlement);
                                     
                                     $current_due=$current_due+$arr[0];
                                     $total_due=$total_due+$arr[1];
                                     $due_settlement=$due_settlement+$arr[2];

                                     
                                }
                                
                                $amount_recieved=$amount_recieved+$row2['fee_paid'];
                                $total_fee=$total_fee+$row2['fee_payable'];

                                                           
                            }
                            else{
                                $special_case_fee=$this->isSpecialCase($enrollment_no,$class_id,$session_id,$fee_id,$school_code);
                                if (strlen($special_case_fee)!= 0){
                                    
                                     $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$special_case_fee,$school_code);
                                     $arr=explode('#',$settlement);
                                     
                                     $current_due=$current_due+$arr[0];
                                     $total_due=$total_due+$arr[1];
                                     $due_settlement=$due_settlement+$arr[2];
                                     $fee_value=$special_case_fee;
                                     
                                }
                                else{
                                   $special_fee=$this->getSpecialFee($school_code);
                                   if($fee_id==$special_fee[0]['fee_id'])
                                    {
                            
                                       $admission_type=$this->getAdmissionType($enrollment_no,$class_id,$session_id);
                                       if($admission_type=="ADMTYPE01")
                                       {
                                            $fee_value=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);
                                           
                                       }
                                       else{
                                        $fee_value=$row['fee_value'];
                                        
                                       }

                                    }
                                    else{
                                        $fee_value=$row['fee_value'];

                                    } 
                                       $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                       $arr=explode('#',$settlement);
                                         
                                       $current_due=$current_due+$arr[0];
                                       $total_due=$total_due+$arr[1];
                                       $due_settlement=$due_settlement+$arr[2];
                                       
                                  
                                }                              
                               
                               $amount_recieved=$amount_recieved+$row['amount_paid'];
                               $total_fee=$total_fee+$fee_value;
                                                              
                            }
                            
                 }
                 
                $transport_fee=$this->getTransportFee_IfTransportGranted($enrollment_no,$session_id,$class_id,$month,$school_code);
                if($transport_fee)
                {
                  if($transport_fee['payment_status']!='Paid')
                   {       
                        $outstanding=$transport_fee['outstanding'];
                        $fee_id=$transport_fee['fee_id'];

                        $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$outstanding,$school_code);
                           $arr=explode('#',$settlement);
                             
                           $current_due=$current_due+$arr[0];
                           $total_due=$total_due+$arr[1];
                           $due_settlement=$due_settlement+$arr[2];
                   }
                 $amount_recieved=$amount_recieved+$transport_fee['amount_paid']; 
                 $total_fee=$total_fee+$transport_fee['fee_value']; 
                 
                }
                
                    
        
    }
   

    return $current_due.'#'.$amount_recieved.'#'.$total_fee.'#'.$total_due.'#'.$due_settlement;
}
public function getFeeDashboard($session_id,$school_code)
{
   // $current_due.'#'.$amount_recieved.'#'.$total_fee.'#'.$total_due.'#'.$due_settlement;


    /*$total_due_and_paid=$this->getStudentTotalDue($session_id,$school_code);
    $arr=explode('#',$total_due_and_paid);
    
    $dashboard['current_due']=$arr[0];
    $dashboard['total_recieved']=$arr[1];
    $dashboard['total_fee']=$arr[2];
    $dashboard['total_due']=$arr[3];
    $dashboard['due_settlement']=$arr[4];*/
    
    $common=new Common();
    if($common->isCurrentSession($session_id,$school_code))
    {
        $current_month=date('Y-m');
            
    }
    else{
        $end_date=$this->getSessionEndDate($session_id,$school_code);
        $current_month=date("Y-m",strtotime($end_date));
        //echo $current_month.'/';
    
    }

    $str_total_fee=$this->getAllStudentTotalFee($current_month,$session_id,$school_code);
    $arr=explode('#',$str_total_fee);
    $total_fee=$arr[0];
   
    $current_fee=$arr[1];
    

    $str_total_settled=$this->getTotalSettlementAmount($current_month,$session_id,$school_code);
    $arr3=explode('#',$str_total_settled);
    $total_settled=$arr3[0];
    $current_settled=$arr3[1];


    $str_total_recieved=$this->getTotalFeeReceivedAmount($current_month,$session_id,$school_code);
    $arr2=explode('#',$str_total_recieved);
    $total_recieved=$arr2[0];
    $current_recieved=$arr2[1];
   

    $total_due=$total_fee-($total_recieved+$total_settled);
    $current_due=$current_fee-($current_recieved+$current_settled);

    $dashboard['current_due']=$current_due.'';
    $dashboard['total_recieved']=$total_recieved;
    $dashboard['total_fee']=$total_fee;
    $dashboard['total_due']=$total_due.'';
    $dashboard['due_settlement']=$total_settled;

    $old_due=$this->getSchoolOldDue($school_code);
    $arr2=explode('#',$old_due);
    $total_old_due_amount=$arr2[0];
    $total_paid=$arr2[1];
    if($total_old_due_amount!='')
    {
        $dashboard['total_old_due_amount']=$total_old_due_amount;
    }
    else{
        $total_old_due_amount="0";
        $dashboard['total_old_due_amount']=$total_old_due_amount;
    }
    
    if($total_paid!='')
    {
        $dashboard['total_old_due_paid']=$total_paid;
    }
    else{
        $total_paid="0";
        $dashboard['total_old_due_paid']=$total_paid;
    }

       

     return $dashboard;    
}

public function getAllStudentTotalFee($current_month,$session_id,$school_code)
{
    $current_fee=0;
    $total_fee=0;
   
           
            
                       
                    $sql2="SELECT a.`class_id`,a.`fee_id`,a.`fee_value`,a.`applicable_month`,b.`fee_name` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code' ) b ON a.`fee_id`=b.`fee_id` WHERE  a.`session_id`='$session_id'   AND a.`status`='Active' AND a.`school_code`='$school_code'";
                      $result2=mysqli_query($this->conn,$sql2)or die ('Error in getting   student fee '.mysqli_error($this->conn));
                 
                      while ($row2 = $result2->fetch_assoc()) {
                        $class_id=$row2['class_id'];
                       
                        $total_class_student=count($this->getClassStudents($class_id,$session_id,$school_code));
                        //echo $total_class_student;
                        
                       
                        $fee_id=$row2['fee_id'];
                        $fee_value=$row2['fee_value'];

                        $strMonth=$row2['applicable_month'];
                        $arrMonth=explode(',',$strMonth);

                        $arrCurrentMonth = array_filter($arrMonth, function ($month) use ($current_month) {
                             return $month <=$current_month;
                        });
                       
                        $special_fee=$this->getSpecialFee($school_code);
                        if($fee_id==$special_fee[0]['fee_id'])
                        {

                            $fee_value_re=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);
                            
                            $reAdm=$this->getClassStudentsReAdmission($class_id,$session_id,$school_code);
                            $total_fee=$total_fee+(count($reAdm)*$fee_value_re*count($arrMonth));
                            $current_fee=$current_fee+(count($reAdm)*$fee_value_re*count($arrCurrentMonth));
                            
                            $newAdm=$this->getClassStudentsNewAdmission($class_id,$session_id,$school_code);
                            $total_fee=$total_fee+(count($newAdm)*$fee_value*count($arrMonth));
                            $current_fee=$current_fee+(count($newAdm)*$fee_value*count($arrCurrentMonth));
                                               

                        }
                        else{
                        
                            $total_fee=$total_fee+($total_class_student*$fee_value*count($arrMonth));
                            $current_fee=$current_fee+($total_class_student*$fee_value*count($arrCurrentMonth));
                           
                        }
                        $str_concession=$this->getFeeSpecialCaseConcession($class_id,$fee_id,$fee_value,$strMonth,$session_id,$current_month,$school_code);
                        $arr=explode('#',$str_concession);
                        $concession=$arr[0];
                        $current_concession=$arr[1];
                       
                        $total_fee=$total_fee-$concession;
                        $current_fee=$current_fee-$current_concession;
                        
                            
                 }
             

                $str_transport_fee=$this->getTotalTransportFeeAmount($current_month,$session_id,$school_code);
                $arr2=explode('#',$str_transport_fee);
                $transport_fee=$arr2[0];
                $current_transport_fee=$arr2[1];
                       
                $total_fee=$total_fee+$transport_fee;
                $current_fee=$current_fee+$current_transport_fee;
                    

    return $total_fee.'#'.$current_fee;
}

public function getFeeSpecialCaseConcession($class_id,$fee_id,$class_fee,$applicable_month,$session_id,$current_month,$school_code)
{
    $concession=0;
    $current_concession=0;
    $arrMonth=explode(',',$applicable_month);  
    $arrCurrentMonth = array_filter($arrMonth, function ($month) use ($current_month) {
        return $month <=$current_month;
    });
                                           
    $sql="SELECT `student_id`,`class_id`,`fee_id`,`fee_value`,`session_id` FROM `tm_fee_special_case` WHERE `class_id`='$class_id' AND `fee_id`='$fee_id' AND `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code'";
   
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting special students: '.mysqli_error($this->conn));                                    
         while ($row = $result->fetch_assoc()) {
                $student_id=$row['student_id'];
                $class_id=$row['class_id'];               
                $fee_value=$row['fee_value'];               
                $fee_id=$row['fee_id']; 

                $special_fee=$this->getSpecialFee($school_code);
                if($fee_id==$special_fee[0]['fee_id'])
                {
        
                   $admission_type=$this->getAdmissionType($student_id,$class_id,$session_id);
                   if($admission_type=="ADMTYPE01")
                   {
                        $class_fee=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);
                        $concession=$concession+($class_fee-$fee_value)*count($arrMonth);
                        $current_concession=$current_concession+($class_fee-$fee_value)*count($arrCurrentMonth);
                   }
                   else{
                     $concession=$concession+($class_fee-$fee_value)*count($arrMonth);
                     $current_concession=$current_concession+($class_fee-$fee_value)*count($arrCurrentMonth);

                   }

                }
                 else{
                    $concession=$concession+($class_fee-$fee_value)*count($arrMonth);
                    $current_concession=$current_concession+($class_fee-$fee_value)*count($arrCurrentMonth);
                    //echo "concession__".$concession.'/';
                }               

               
         }

    return $concession.'#'.$current_concession;
    
}
public function getTotalTransportFeeAmount($current_month,$session_id,$school_code)
{
    $total_transport_fee=0;
    $current_transport_fee=0;
 
    $sql="SELECT `transport_fee` ,`applicable_month` FROM `tm_transport_student` WHERE `school_code`='$school_code' AND `session_id`='$session_id' AND `status`='Active'";
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting   total transport fee amount  '.mysqli_error($this->conn));
                 
        while ($row = $result->fetch_assoc()) {
                    unset($arrMonth);
                    unset($arrCurrentMonth);
                    $transport_fee=$row['transport_fee'];
                    $applicable_month=$row['applicable_month'];
                    $arrMonth=explode(',',$applicable_month);
                    $arrCurrentMonth = array_filter($arrMonth, function ($month) use ($current_month) {

                        return $month <=$current_month;
                    });

                    $total_transport_fee=$total_transport_fee+($transport_fee*count($arrMonth));
                    $current_transport_fee=$current_transport_fee+($transport_fee*count($arrCurrentMonth));

       }
       
       return $total_transport_fee.'#'.$current_transport_fee;
}
public function getTotalSettlementAmount($current_month,$session_id,$school_code)
{
    $settlement_amount="0";
    $current_settled="0";

    $sql="SELECT SUM(`due_amount`) As settlement_amount,Sum(Case When `applicable_month` <= '$current_month' Then `due_amount` Else 0 End) current_settled FROM `tm_fee_due_settlement_request` WHERE `school_code`='$school_code'  AND `session_id`='$session_id' AND `settlement_status`='2'";
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting   total settlement amount  '.mysqli_error($this->conn));
                 
        while ($row = $result->fetch_assoc()) {
                    $data[]=$row;
       }
       if($data[0]['settlement_amount']!=null)
       {
        $settlement_amount=$data[0]['settlement_amount'];
       }
       if($data[0]['current_settled']!=null)
       {
        $current_settled=$data[0]['current_settled'];
       }
      
      return  $settlement_amount.'#'.$current_settled;


}
public function getTotalFeeReceivedAmount($current_month,$session_id,$school_code)
{
    $total_received="0";
    $current_received="0";


    $sql="SELECT SUM(`fee_paid`) As total_received,Sum(Case When `year_month` <= '$current_month' Then `fee_paid` Else 0 End) current_received FROM `tm_fee_payment` WHERE `school_code`='$school_code'  AND `session_id`='$session_id' AND `status`='2'";
    
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   total fee received amount  '.mysqli_error($this->conn));
                 
        while ($row = $result->fetch_assoc()) {
                    $data[]=$row;
       }
       if($data[0]['total_received']!=null)
       {
        $total_received=$data[0]['total_received'];
       }

       if($data[0]['current_received']!=null)
       {
        $current_received=$data[0]['current_received'];
       }
       return $total_received.'#'.$current_received;
       
}

//old method
public function getStudentTotalDue($session_id,$school_code)
{
    $current_due=0;
    $amount_recieved=0;
    $total_fee=0;
    $total_due=0;
    $due_settlement=0;

            $today=date('Y-m-d');
            $current_month=date('Y-m');
           
            $start_date=$this->getSessionStartDate($session_id,$school_code);
            $end_date=$this->getSessionEndDate($session_id,$school_code);
             //echo $start_date;
            $count=$this->getNoOfMonth( $start_date,$end_date);

    $sql="SELECT `student_enrollment_no`,`class_id`,`section_id` FROM `tm_student_class` WHERE `session_id` = '$session_id' AND `school_code`='$school_code' ";
    $result_0=mysqli_query($this->conn,$sql)or die ('Error in getting  student summery: '.mysqli_error($this->conn));
                                     
         while ($row_0 = $result_0->fetch_assoc()) {

            $class_id=$row_0['class_id'];
            $enrollment_no=$row_0['student_enrollment_no'];
            //echo $class_id."/";
            //echo $enrollment_no."/";
            
           for ($i=0; $i <=$count ; $i++) { 

            $month=date("Y-m",strtotime("+$i Months,$start_date"));
            $month2=date("F-Y",strtotime("+$i Months,$start_date"));
           // echo $month;
           
            $sql="SELECT a.`fee_id`,a.`fee_value`,b.`fee_name` FROM `tm_class_fee` a LEFT JOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code' ) b ON a.`fee_id`=b.`fee_id` WHERE INSTR(  a.`applicable_month` , '$month' )  AND a.`session_id`='$session_id' AND a.`class_id`='$class_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
            $result=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {


                        $fee_id=$row['fee_id'];
                        unset($result2);


                        $sql="SELECT  `fee_id` ,`fee_payable`,SUM(  `fee_paid` ) AS fee_paid FROM  `tm_fee_payment` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id` = '$fee_id' AND `year_month` = '$month' AND `status` = '2' AND `school_code`='$school_code'";

                        $result2=mysqli_query($this->conn,$sql)or die ('Error in getting   student fee2 '.mysqli_error($this->conn));
                            $row2 = $result2->fetch_assoc();

                           
                            if($row2['fee_id']!=NULL)
                            {
                                if($row2['fee_payable']!=$row2['fee_paid'])
                                {
                                    
                                     $due=$row2['fee_payable']-$row2['fee_paid'];
                                     $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$due,$school_code);
                                     $arr=explode('#',$settlement);
                                     
                                     $current_due=$current_due+$arr[0];
                                     $total_due=$total_due+$arr[1];
                                     $due_settlement=$due_settlement+$arr[2];

                                     
                                }
                                
                                $amount_recieved=$amount_recieved+$row2['fee_paid'];
                                $total_fee=$total_fee+$row2['fee_payable'];

                                                           
                            }
                            else{
                                $special_case_fee=$this->isSpecialCase($enrollment_no,$class_id,$session_id,$fee_id,$school_code);
                                if (strlen($special_case_fee)!= 0){
                                    
                                     $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$special_case_fee,$school_code);
                                     $arr=explode('#',$settlement);
                                     
                                     $current_due=$current_due+$arr[0];
                                     $total_due=$total_due+$arr[1];
                                     $due_settlement=$due_settlement+$arr[2];
                                     $fee_value=$special_case_fee;
                                     
                                }
                                else{
                                   $special_fee=$this->getSpecialFee($school_code);
                                   if($fee_id==$special_fee[0]['fee_id'])
                                    {
                            
                                       $admission_type=$this->getAdmissionType($enrollment_no,$class_id,$session_id);
                                       if($admission_type=="ADMTYPE01")
                                       {
                                            $fee_value=$this->getExistingStudentRegFee($fee_id,$class_id,$session_id,$school_code);
                                           
                                       }
                                       else{
                                        $fee_value=$row['fee_value'];
                                        
                                       }

                                    }
                                    else{
                                        $fee_value=$row['fee_value'];

                                    } 
                                       $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$fee_value,$school_code);
                                       $arr=explode('#',$settlement);
                                         
                                       $current_due=$current_due+$arr[0];
                                       $total_due=$total_due+$arr[1];
                                       $due_settlement=$due_settlement+$arr[2];
                                       
                                  
                                }                              
                               
                               $amount_recieved=$amount_recieved+$row['amount_paid'];
                               $total_fee=$total_fee+$fee_value;
                                                              
                            }
                            
                 }
                 
                $transport_fee=$this->getTransportFee_IfTransportGranted($enrollment_no,$session_id,$class_id,$month,$school_code);
                if($transport_fee)
                {
                  if($transport_fee['payment_status']!='Paid')
                   {       
                        $outstanding=$transport_fee['outstanding'];
                        $fee_id=$transport_fee['fee_id'];

                        $settlement=$this->getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$outstanding,$school_code);
                           $arr=explode('#',$settlement);
                             
                           $current_due=$current_due+$arr[0];
                           $total_due=$total_due+$arr[1];
                           $due_settlement=$due_settlement+$arr[2];
                   }
                 $amount_recieved=$amount_recieved+$transport_fee['amount_paid']; 
                 $total_fee=$total_fee+$transport_fee['fee_value']; 
                 
                }
                
                    
        
    }
  } 

    return $current_due.'#'.$amount_recieved.'#'.$total_fee.'#'.$total_due.'#'.$due_settlement;
}


public function getDueSettlementStatus($enrollment_no,$class_id,$session_id,$fee_id,$month,$amount,$school_code)
{
    
    unset($row);
    unset($settlement);
     $sql="SELECT `due_amount`,`settlement_status`,`due_payment_status` FROM `tm_fee_due_settlement_request` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id`='$fee_id' AND `applicable_month`='$month' AND `due_amount`='$amount' AND `status`='Active' AND `school_code`='$school_code' AND `isTrashed`='0'";
    

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  due settlement status: '.mysqli_error($this->conn));
                                     
         while ($row_settle = $result->fetch_assoc()) {
            
                $settlement[] = $row_settle;
         }
          if($settlement)
            {
                if($settlement[0]['settlement_status']==1)
                {
                    $row['settlement_status']=1;
                    $row['payment_status']="SR in Progress";
                    $row['fee_value']=$amount;
                    $row['amount_paid']="0";
                    $row['outstanding']=$amount;

                }
                else if($settlement[0]['settlement_status']==2)
                {
                    $row['settlement_status']=2;
                    $row['payment_status']="Due Settled";
                    $row['fee_value']=$amount;
                    $row['amount_paid']="0";
                    $row['amount_settled']=$amount;
                    $row['outstanding']="0";

                }
                else if($settlement[0]['settlement_status']==3)
                {
                    if($settlement[0]['due_payment_status']==1)
                    {
                        $row['settlement_status']=3;
                        $row['payment_status']="Not Paid";
                        $row['fee_value']=$amount;
                        $row['amount_paid']="0";
                        $row['outstanding']=$amount;
                    }
                    else{
                        $row['settlement_status']=3;
                        $row['payment_status']="Due";
                        $row['fee_value']=$amount;
                        $row['amount_paid']="0";
                        $row['outstanding']=$amount;
                    }
                    
                }

            }

     return $row; 
}
public function getDueSettlementStatusAndAmount($enrollment_no,$class_id,$session_id,$fee_id,$month,$amount,$school_code)
{
    $current_due=0;
    $total_due=0;
    $due_settlement=0;
    $current_month=date('Y-m');

    
    unset($row);
    unset($settlement);
     $sql="SELECT `due_amount`,`settlement_status`,`due_payment_status` FROM `tm_fee_due_settlement_request` WHERE `student_id`='$enrollment_no' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id`='$fee_id' AND `applicable_month`='$month' AND `due_amount`='$amount' AND `status`='Active' AND `school_code`='$school_code' AND `isTrashed`='0'";
    

    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  due settlement status and amount: '.mysqli_error($this->conn));
                                     
         while ($row_settle = $result->fetch_assoc()) {
            
                $settlement[] = $row_settle;
         }
          if($settlement)
            {
                
                if($settlement[0]['settlement_status']==2)
                {
                    $due_settlement=$amount;
                }
                else
                {
                    if($month<=$current_month)
                    {
                       $current_due=$amount;
                    }
                    $total_due=$amount;
                    
                }

            }
            else{
                   if($month<=$current_month)
                    {
                       $current_due=$amount;
                    }
                    $total_due=$amount;
            }

     return $current_due.'#'.$total_due.'#'.$due_settlement; 
}

public function getAccessoriesDashBoard($session_id,$school_code)
{
    
    $total_product=$this->getAllAccessoriesProduct($session_id,$school_code);
    $dashboard['total_product']=count($total_product);
    $total_category=$this->getAccessoriesCategory($school_code);
    $dashboard['total_category']=count($total_category);
    $total_publication=$this->getAccessoriesPublication($school_code);
    $dashboard['total_publication']=count($total_publication);

    $total_vendor=$this->getVendorList($school_code);
    $dashboard['total_vendor']=count($total_vendor);

    $total_stock=$this->getTotalStock($school_code);
    if($total_stock)
    {
        $dashboard['total_stock']=$total_stock;
    }
    else{
        $dashboard['total_stock']='0';
    }

    $out_of_stock=$this->getOutOfStockProduct($school_code);
    $dashboard['out_of_stock']=count($out_of_stock);


    $accessories_provided_student=$this->getAccessoriesProvidedStudent($session_id,$school_code);
    $dashboard['accessories_provided_student']=count($accessories_provided_student);

    $total=$this->getTotalStudent_count($session_id,$school_code);
    $dashboard['accessories_not_provided_student']=$total-count($accessories_provided_student);


    return $dashboard;

}

public function getAccessoriesFeeCollection($session_id)
{

    $sql="SELECT `transaction_id`,`student_id`,`class_id`,`section_id`,`staff_id`,`paid_amount`,`remark`,`payment_mode`,`transaction_date` FROM `tm_transaction_master` WHERE `transaction_date`='$date' AND `status`='2' AND `transaction_for`='ACCESSORIES'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting accessories fee collection: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

            
                $data[] = $row;
         }

     return $data;    
}

public function getAccessoriesProvidedStudent($session_id,$school_code)
{
    $sql="SELECT `student_id`,`class_id`,`section_id` FROM `tm_transaction_master` WHERE `transaction_for`='ACCESSORIES' AND `school_code`='$school_code' GROUP BY `student_id`";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting accessories provided student: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {


                $data[] = $row;
         }

     return $data;    
}
public function getAccessoriesProvidedClassStudent($session_id,$class_id,$section_id,$school_code)
{
    $sql="SELECT `student_id`,`class_id`,`section_id` FROM `tm_transaction_master` WHERE `transaction_for`='ACCESSORIES' GROUP BY `student_id`";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting accessories provided student: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $student_id=$row['student_id'];
                $student=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);
                $accessories_product=$this->getAccessoriesClassStudentProduct($student_id,$session_id,$class_id,$section_id,$school_code);  
                $student[0]['accessories_product']=$accessories_product;
                $data[]=$student[0];
         }

     return $data;    
}

public function getAccessoriesClassStudentProduct($student_id,$session_id,$class_id,$section_id,$school_code)
{
    $sql="SELECT a.`transaction_id`,a.`student_id`,a.`class_id`,a.`section_id`,a.`product_id`,b.`product_name`,a.`product_sp`,a.`quantity`,a.`payable_amount`,a.`paid_amount` FROM `tm_accessories_to_student` a LEFT JOIN (SELECT * FROM `tm_accessories_product` WHERE `school_code`='$school_code') b ON a.`product_id`=b.`product_id` WHERE a.`student_id`='$student_id' AND a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories product of student of class: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

        
                $data[] = $row;
         }

     return $data;    
} 

public function getAllAccessoriesProduct($session_id,$school_code)
{
    $sql="SELECT a.`session_id`,a.`product_id`,a.`product_name`,a.`category`,b.`category_name`,a.`in_stock`,a.`remark` FROM `tm_accessories_product` a LEFT jOIN (SELECT * FROM `tm_accessories_category` WHERE `status`='Active' AND `school_code`='$school_code') b ON a.`category`=b.`category_id` WHERE a.`status`='Active' AND a.`school_code`='$school_code' ORDER BY a.`id` DESC";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting total accessories product: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $product_id=$row['product_id'];
                $class_for=$this->getAccessoriesClassFor($product_id,$school_code,$session_id);
                $row['for_class']=$class_for;
                $data[] = $row;
         }

     return $data;    
}

public function getAccessoriesClassFor($product_id,$school_code,$session_id)
{
    $sql="SELECT a.`class_id`,b.`class_name` FROM `tm_accessories_for_class` a LEFT JOIN (SELECT * FROM `tm_class` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`class_id`=b.`class_id` WHERE a.`product_id`='$product_id' AND a.`status`='Active' AND a.`school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories class for: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }

     return $data;    
}
public function getOutOfStockProduct($school_code)
{
    $sql="SELECT `product_id`,`product_name`,`category`,`in_stock` FROM `tm_accessories_product` WHERE `in_stock`=0 AND `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories out of stock: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }

     return $data;    
}
public function getTotalStock($school_code)
{
    $sql="SELECT SUM(`in_stock`) AS 'total_stock' FROM `tm_accessories_product` WHERE `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories total stock: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }
   return $data[0]['total_stock'];
}
public function getAccessoriesProductOfClass($class_id,$school_code)
{
    $sql="SELECT a.`product_id`,a.`class_id`,b.`product_name`,b.`category`,c.`category_name`,b.`in_stock` FROM `tm_accessories_for_class` a LEFT JOIN (SELECT * FROM `tm_accessories_product` WHERE `school_code`='$school_code') b ON a.`product_id`=b.`product_id`  LEFT JOIN (SELECT * FROM `tm_accessories_category` WHERE `status`='Active' AND `school_code`='$school_code') c ON b.`category`=c.`category_id` WHERE a.`class_id`='$class_id' AND a.`status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories product of class: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $product_id=$row['product_id'];
                $in_sell=$this->getAccessoriesInStock($product_id);
                $row['in_sell_stock']=$in_sell;
                $data[] = $row;
         }

     return $data;    
}

public function getAccessoriesInStock($product_id)
{
    $sql="SELECT `stock_id`,`product_id`,`vendor_id`,`quantity_recieved`,`quantity_sold_out`,`quantity_returned`,`quantity_in_stock`,`mrp`,`cp`,`sp`,`status` FROM `tm_accessories_stock` WHERE `status`='InSell' AND `product_id`='$product_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories in sell stock: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }

     return $data;    
}


public function getSchoolOldDue($school_code)
{
    $sql="SELECT SUM(`amount`) AS 'amount' FROM `tm_fee_old_due_student` WHERE `status`='Active' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  old due: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $row['amount_paid']=$this->getSchoolOldDueTotalPayment($school_code);
                $data[] = $row;
         }
   return $data[0]['amount'].'#'.$data[0]['amount_paid'];
}
public function getSchoolOldDueTotalPayment($school_code)
{
    $sql="SELECT SUM(`amount_paid`) AS 'amount_paid' FROM `tm_fee_old_due_payment` WHERE `status`='2' AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  old due: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }
   return $data[0]['amount_paid'];
}

public function getBoardMaster()
{
    $sql="SELECT `id`, `board_name`, `date`, `status` FROM `tm_board_master` WHERE `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  board master: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }

     return $data;    
}
public function getMediumMaster()
{
    $sql="SELECT `id`, `medium_name`, `date`, `status` FROM `tm_medium_master` WHERE `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  medium master: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }

     return $data;    
}

public function getClassMaster()
{
    $sql="SELECT `id`, `class_name`, `date`, `status` FROM `tm_class_master` WHERE `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  class master: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $data[] = $row;
         }

     return $data;    
}

public function getSchoolProfile($school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT a.`school_id`, a.`school_code`, a.`school_name`, a.`school_address`,b.`school_logo_path`,b.`school_tag_line`,b.`school_estb_year`,b.`school_reg_no`,b.`officail_contact_no1`,b.`officail_contact_no2`,b.`officail_email`,b.`website`,b.`scanned_sign_clerk`,b.`scanned_sing_principle`, a.`country`, a.`state`, a.`date_added`, a.`status` FROM `tm_school_master` a  LEFT JOIN `tm_school_details` b ON a.`school_code`=b.`school_code` WHERE a.`school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

                        $school_logo_path=$row['school_logo_path'];
                
                        $img='http://'.$server_name."/".$school_logo_path;
                        $row['school_logo_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }
         }
        
        return $data;
}
public function getSchoolDetails($school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT a.`school_id`, a.`school_code`, a.`school_name`, a.`school_address`,b.`school_logo_path`,b.`school_tag_line`,b.`school_estb_year`,b.`school_reg_no`,b.`officail_contact_no1`,b.`officail_contact_no2`,b.`officail_email`,b.`website`,b.`scanned_sign_clerk`,b.`scanned_sing_principle`, a.`country`, a.`state`, a.`date_added`, a.`status` FROM `tm_school_master` a  LEFT JOIN `tm_school_details` b ON a.`school_code`=b.`school_code` WHERE a.`school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school details : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

                        $school_logo_path=$row['school_logo_path'];
                
                        $img='http://'.$server_name."/".$school_logo_path;
                        $row['school_logo_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getAdsControl($school_code,$panel)
{
    if($panel=='Admin')
    {
        $sql="SELECT `school_code`,`ads_type`,`ads_name`,`ads_network`,`status` FROM `tm_ads_control` WHERE `school_code`='$school_code'  AND `admin_access`='1'";
        //echo $sql;
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  ads controls: '.mysqli_error($this->conn));
                                         
             while ($row = $result->fetch_assoc()) {

                    $data[] = $row;
             }

         return $data;  
     }  

    if($panel=='Clerk')
    {
        $sql="SELECT `school_code`,`ads_type`,`ads_name`,`ads_network`,`status` FROM `tm_ads_control` WHERE `school_code`='$school_code'  AND `clerk_access`='1'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  ads controls: '.mysqli_error($this->conn));
                                         
             while ($row = $result->fetch_assoc()) {

                    $data[] = $row;
             }

         return $data;  
     }  
     if($panel=='Teacher')
    {
        $sql="SELECT `school_code`,`ads_type`,`ads_name`,`ads_network`,`status` FROM `tm_ads_control` WHERE `school_code`='$school_code'  AND `teacher_access`='1'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  ads controls: '.mysqli_error($this->conn));
                                         
             while ($row = $result->fetch_assoc()) {

                    $data[] = $row;
             }

         return $data;  
     }  
     if($panel=='Parents')
    {
        $sql="SELECT `school_code`,`ads_type`,`ads_name`,`ads_network`,`status` FROM `tm_ads_control` WHERE `school_code`='$school_code'  AND `parents_access`='1'";
        $result=mysqli_query($this->conn,$sql)or die ('Error in getting  ads controls: '.mysqli_error($this->conn));
                                         
             while ($row = $result->fetch_assoc()) {

                    $data[] = $row;
             }

         return $data;  
     }  
}
public function getSectionMasterList()
{
    $sql="SELECT `section_id`,`section_name`,`status` FROM `tm_section_master`";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  subject master list: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $data[] = $row;
         }

     return $data;    
}
public function getFeeSettlementDashboard($session_id,$school_code)
{
    $data=$this->getFeeSettlementAmount($session_id,$school_code);
    if($data[0]['settlement_request']!=null)
    {
        $settlement_request=$data[0]['settlement_request'];
    }
    else{
        $settlement_request="0";
    }

    if($data[0]['due_settled_amount']!=null)
    {
        $due_settled_amount=$data[0]['due_settled_amount'];
    }
    else{
        $due_settled_amount="0";
    }

    if($data[0]['fee_settled_amount']!=null)
    {
        $fee_settled_amount=$data[0]['fee_settled_amount'];
    }
    else{
        $fee_settled_amount="0";
    }
   
    
    $dashboard['settlement_request']=$settlement_request;
    $dashboard['due_settled_amount']=$due_settled_amount;
    $dashboard['fee_settled_amount']=$fee_settled_amount;
    $list=$this->getFeeSettlementRequestForDash($session_id,$school_code);
    $dashboard['settlement_request_list']=$list;
    return $dashboard;

}

public function getFeeSettlementAmount($session_id,$school_code)
{
    $sql="SELECT Sum(Case When `settlement_status`='1' Then `due_amount` Else 0 End)As settlement_request,Sum(Case When `settlement_status`='2' AND `due_payment_status`='2' Then `due_amount` Else 0 End)As due_settled_amount,Sum(Case When `settlement_status`='2' AND `due_payment_status`='1' Then `due_amount` Else 0 End)As fee_settled_amount FROM `tm_fee_due_settlement_request` WHERE `school_code`='$school_code' AND `session_id`='$session_id' AND `status`='Active' ";
       $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee settlement amount: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $data[] = $row;
         }

     return $data;    
}
public function getFeeSettlementRequestForDash($session_id,$school_code)
{
    $sql="(SELECT * FROM `tm_fee_due_settlement_request` WHERE `session_id`='$session_id' AND `school_code`='$school_code' AND `settlement_status`='2' ORDER BY `id` DESC LIMIT 3)UNION ALL (SELECT * FROM `tm_fee_due_settlement_request` WHERE `session_id`='$session_id' AND `school_code`='$school_code' AND `settlement_status`='1' ORDER BY `id` DESC LIMIT 3) UNION ALL (SELECT * FROM `tm_fee_due_settlement_request` WHERE `session_id`='$session_id' AND `school_code`='$school_code' AND `settlement_status`='3' ORDER BY `id` DESC LIMIT 3)";
       $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee settlement request dash: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $student_enrollment_no=$row['student_id'];
                $student = $this->getStudentDetails($student_enrollment_no,$session_id,$school_code);
                $row['student_details']=$student;
               
                $data[] = $row;
         }

     return $data;    
}

public function getFeeSettlementRequest($session_id,$limit,$offset,$settlement_status,$school_code)
{
    $sql="SELECT a.`school_code`,a.`settlement_request_id`,a.`sender_id`,a.`approved_by`,a.`student_id`,a.`session_id`,a.`class_id`,a.`section_id`,a.`fee_id`,b.`fee_name`,a.`applicable_month`,a.`due_amount`,a.`due_payment_status`, a.`settlement_status` FROM `tm_fee_due_settlement_request` a LEFT jOIN (SELECT * FROM `tm_fee_applicable` WHERE `school_code`='$school_code') b ON a.`fee_id`=b.`fee_id` WHERE a.`school_code`='$school_code' AND a.`session_id`='$session_id' AND a.`settlement_status`='$settlement_status' AND a.`status`='Active'  LIMIT $offset,$limit";
       $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee settlement request: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $student_enrollment_no=$row['student_id'];
                $student = $this->getStudentDetails($student_enrollment_no,$session_id,$school_code);
                $row['student_details']=$student;
                $data[] = $row;
         }

     return $data;    
}

public function getSchoolAllQueryBySender($sender_id,$session_id,$limit,$offset,$school_code)
{
    $get=new getFunctions();

     $sql="SELECT `session_id`,`query_id`,`sender_id`,`query`,`query_to`,`query_type`,`date_added`,`status` FROM `tm_school_query` WHERE `sender_id`='$sender_id' AND `parent_query_id`='0' AND `session_id`='$session_id' AND `status`='Active' AND `school_code`='$school_code' ORDER BY `date_added` DESC LIMIT $offset,$limit ";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all query: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $sender_id=$row['sender_id'];

                $sender_name=$this->getStaffName($sender_id);
                if($sender_name!=NULL)
                {
                    $row['sender_name']=$sender_name;
                }
                else 
                {
                   $sender_name= $this->getStudentName($sender_id);
                   $row['sender_name']=$sender_name;
                }
                $query_id=$row['query_id'];
                $reply=$get->getQueryReply($query_id);
                $row['reply']=$reply;
            
                $data[] = $row;
         }

     return $data;    
}

public function getQueryReply($query_id)
{
    $get=new getFunctionsCRM();
    $sql="SELECT `query_id`,`sender_id`,`query`,`query_to`,`query_type`,`date_added` FROM `tm_school_query` WHERE `parent_query_id`='$query_id' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting query reply: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $sender_id=$row['sender_id'];

                $sender_name=$get->getEduOkAdminName($sender_id);
                if($sender_name!=NULL)
                {
                    $row['sender_name']=$sender_name;
                    $row['staff_image_path']=$get->getEduOkAdminImage($sender_id);
                }
                $data[] = $row;
         }

     return $data;    
}
public function getSchoolAllQuery($session_id,$limit,$offset,$school_code)
{

    $sql="SELECT `session_id`,`query_id`,`sender_id`,`query`,`query_to`,`query_type`,`date_added`,`status` FROM `tm_school_query` WHERE  `session_id`='$session_id' AND `parent_query_id`='0' AND `status`='Active' AND `school_code`='$school_code' ORDER BY `date_added` DESC LIMIT $offset,$limit ";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting all query: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $sender_id=$row['sender_id'];

                $sender_name=$this->getStaffName($sender_id);
                if($sender_name!=NULL)
                {
                    $row['sender_name']=$sender_name;
                }
                else 
                {
                   $sender_name= $this->getStudentName($sender_id);
                   $row['sender_name']=$sender_name;
                }
                $query_id=$row['query_id'];
                $reply=$this->getQueryReply($query_id);
                $row['reply']=$reply;

            
                $data[] = $row;
         }

     return $data;    
}

public function getFineStructure($session_id,$school_code)
{

    $file_rule=$this->getFileRule();
    $data['file_rule']=$file_rule;

    $fee_day=$this->getFeeDay($session_id,$school_code);
    $data['fee_day']=$fee_day;

    
    

    return $data;

}
public function getFileRule()
{

    $sql="SELECT `fine_rule_id`,`fine_rule_name`,`fine_rule_mode` FROM `tm_fine_rule_master` WHERE `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting file rule: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $data[] = $row;
         }

     return $data;    
}
public function getFeeDay($session_id,$school_code)
{

    $sql="SELECT `open_day`,`close_day`,`fine_day`,`school_code`,`session_id` FROM `tm_fee_day` WHERE `school_code`='$school_code' AND `session_id`='$session_id'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting file rule: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $data[] = $row;
         }

     return $data;    
}

public function getClassFineStructure($school_code,$session_id,$class_id)
{

    $sql="SELECT `fine_rule_id`,`session_id`,`class_id`,`fine_plan` FROM `tm_fine_structure_of_class` WHERE `school_code`='$school_code' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `isTrashed`='0' AND `status`='Active'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting file structure: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
                $data[] = $row;
         }

     return $data;    
}

public function getEduOkProduct()
{
    $server_name=$_SERVER['SERVER_NAME'];
     $sql="SELECT `product_id`,`product_code`,`product_name`,`product_description`,`icon_dir` FROM `tm_crm_my_product`  WHERE `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  eduok product: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {

                $product_code=$row['product_code'];
                $icon_dir=$row['icon_dir'];
            
                $img='http://'.$server_name."/".$icon_dir;
                $row['icon_dir']=trim(preg_replace('/\s\s+/', '', $img));
                $rate=$this->getProductRate($product_code);
                $row['rate_chart']=$rate;
                $data[] = $row;
         }

     return $data;    
}
public function getProductRate($product_code)
{

     $sql="SELECT `rate_id`,`product_code`,`product_rate`,`renewal_rate`,`currency`,`rate_type`,`validity` FROM `tm_crm_product_rate` WHERE `product_code`='$product_code' AND `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  eduok product rate: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getEduOkProfile()
{
    $school=$this->getEduOkSchoolCount();
    $data['school_list']=count($school);

    $teacher=$this->getEduOkTeacherCount();
    $data['teacher']=count($teacher);

    $student=$this->getEduOkStudentCount();
    $data['student']=count($student);
    

     return $data;    
}
public function getEduOkSchoolCount()
{

     $sql="SELECT `id` FROM `tm_school_master` WHERE `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school count: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getEduOkTeacherCount()
{

     $sql="SELECT `id` FROM `tm_staff_master` WHERE `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  teacher count: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}
public function getEduOkStudentCount()
{

     $sql="SELECT `id` FROM `tm_student_admission` WHERE `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student count: '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getStateMaster()
{

     $sql="SELECT `state_id`,`state_name`,`state_code` FROM `tm_state_master` WHERE `status`='Active'";
      $result=mysqli_query($this->conn,$sql)or die ('Error in getting  state : '.mysqli_error($this->conn));
                                     
         while ($row = $result->fetch_assoc()) {
            
                $data[] = $row;
         }

     return $data;    
}

public function getSchoolBillingAddress($school_code)
{

        $sql="SELECT a.`address_id`,a.`school_code`,a.`school_name`,a.`contact_name`,a.`contact_mobile` ,a.`state_id`,c.`state_name`,a.`city_name`,a.`pincode`,a.`address_one`,a.`address_two`,a.`landmark` FROM `tm_school_billing_address` a LEFT JOIN `tm_state_master` c ON a.`state_id`=c.`state_id` WHERE a.`school_code`='$school_code' AND a.`status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  billing address: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;
}


public function getDefaultApplicableTax()
{

        $sql="SELECT `tax_id`,`tax_name`,`tax_value_percentage`,`isDefault` FROM `tm_crm_taxes_master` WHERE `status`='Active' AND `isDefault`='1'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  default tax: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;
}


public function getPromoCodeBenefits($school_code,$promo_code,$product_code)
{

         $promo=$this->isPromoCodeActive($promo_code,$product_code);
         if($promo)
         {
                $promo_code_id=$promo[0]['promo_code_id'];
                $offer=$this->isOfferActive($promo_code_id,$product_code);
                if($offer)
                {
                    $offer_id=$offer[0]['offer_id'];
                    $offer_type=$offer[0]['offer_type'];
                    $temp=$this->isOfferAlreadyAvailed($offer_id,$school_code);
                    if($temp)
                    {
                        
                        return false;
                    }
                    else{
                        $flag=$this->isOfferGrantedToSchool($promo_code_id,$product_code,$school_code);
                        if($flag)
                        {
                            return $promo;
                        }
                        else{
                            
                            return false;
                        }
                        
                    }
                }
                else{
                    
                     return false;
                }
                
         } 
         else{
           
            return false;
         }       
        
}
public function isPromoCodeActive($promo_code,$product_code)
{

        $sql="SELECT `promo_code_id`,`promo_code`,`product_code`,`promo_code_name`,`promo_code_benefit`,`benefit_mode`,`applied_on` FROM `tm_crm_promo_code` WHERE `promo_code`='$promo_code' AND `product_code`='$product_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  promo code benefit: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;   
        
}

public function isOfferActive($promo_code_id,$product_code)
{

        $sql="SELECT `offer_id`,`promo_code_id`,`product_code`,`offer_type` FROM `tm_crm_offers` WHERE `promo_code_id`='$promo_code_id' AND `product_code`='$product_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  offer active: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;      
        
}
public function isOfferAlreadyAvailed($offer_id,$school_code)
{

        $sql="SELECT * FROM `tm_crm_offer_beneficiary` WHERE `offer_id`='$offer_id' AND `school_code`='$school_code' AND `isAvailed`='1'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  offer active: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;       
        
}
public function isOfferGrantedToSchool($promo_code_id,$product_code,$school_code)
{

         $sql="SELECT `offer_id`,`promo_code_id`,`product_code`,`offer_type` FROM `tm_crm_offers` WHERE `promo_code_id`='$promo_code_id' AND `product_code`='$product_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  offer active: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
         $offer_type=$data[0]['offer_type']; 
         $offer_id=$data[0]['offer_id'];  

         if($offer_type==='ALL_SCHOOL')  
         {
            return true; 
         }
         else{

             $sql="SELECT * FROM `tm_crm_offer_beneficiary` WHERE `offer_id`='$offer_id' AND `school_code`='$school_code' AND `isAvailed`='1'";
     
              $result2=mysqli_query($this->conn,$sql)or die ('Error in getting  offer active: '.mysqli_error($this->conn));
                 
                 while ($row2 = $result2->fetch_assoc()) {
                        $data2[] = $row2;
                 }
            if($data2)
            {
                return true; 
            }
            else{
                return false; 
            }     
         }      
              
        
}

public function getSchoolProduct($school_code)
{

        $sql="SELECT `school_code`,`product_code`,`order_id` FROM `tm_crm_order` WHERE `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  ordered product: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $product_code=$row['product_code'];
                        $tmp=$this->getProductDetails($product_code);
                        $data[] = $tmp;
                 }
     return $data;           
        
}
public function getProductDetails($product_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `product_id`,`product_code`,`product_name`,`product_description`,`icon_dir` FROM `tm_crm_my_product` WHERE `product_code`='$product_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  product details: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $product_code=$row['product_code'];
                        $icon_dir=$row['icon_dir'];
            
                        $img='http://'.$server_name."/".$icon_dir;
                        $row['icon_dir']=trim(preg_replace('/\s\s+/', '', $img));

                        $data[] = $row;
                 }
     return $data[0];            
}
public function getSchoolOffer($school_code)
{

        $sql="SELECT `offer_id`,`promo_code_id`,`product_code`,`offer_name`,`offer_description`,`offer_type` FROM `tm_crm_offers` WHERE `offer_type`='ALL_SCHOOL' AND `status`='Active'";

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school  offer: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $promo_code_id=$row['promo_code_id'];
                        $tmp=$this->getPromoCodeDetails($promo_code_id);
                        $row['promo_details']=$tmp;
                        $data[] = $row;
                 }
     return $data;           
        
}
public function getPromoCodeDetails($promo_code_id)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `promo_code_id`,`promo_code`,`product_code`,`promo_code_name`,`promo_code_benefit`,`benefit_mode`,`applied_on` FROM `tm_crm_promo_code` WHERE `promo_code_id`='$promo_code_id' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  promo code details: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        

                        $data[] = $row;
                 }
     return $data;            
}

public function getExamStatusCode()
{
    $sql="SELECT `status_code`,`status_name` FROM `tm_exam_status` WHERE `status`='Active'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   exam status code: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data;
            
}
public function getLastAdmissionNo($school_code)
{
    $sql="SELECT sr_admission_no FROM `tm_student_admission` WHERE `id`=(SELECT MAX(`id`) FROM `tm_student_admission` WHERE `school_code`='$school_code')";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  admission no: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data;
            
}
public function getAnnouncement($school_code,$panel)
{
    if($panel=='Admin')
    {
        $sql="SELECT `announcement_title`,`announcement`,`img_path` FROM `tm_crm_announcement` WHERE `status`='Active' AND `admin_access`='1'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  announcement: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data;
    }

    if($panel=='Clerk')
    {
        $sql="SELECT `announcement_title`,`announcement`,`img_path` FROM `tm_crm_announcement` WHERE `status`='Active' AND `clerk_access`='1'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  announcement: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data;
    }
    if($panel=='Teacher')
    {
        $sql="SELECT `announcement_title`,`announcement`,`img_path` FROM `tm_crm_announcement` WHERE `status`='Active' AND `teacher_access`='1'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  announcement: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data;
    }
    if($panel=='Parents')
    {
        $sql="SELECT `announcement_title`,`announcement`,`img_path` FROM `tm_crm_announcement` WHERE `status`='Active' AND `parents_access`='1'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  announcement: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data;
    }
    
    
            
}

public function getStudentRollNumber($student_id,$class_id,$section_id,$session_id,$school_code)
{
    $sql="SELECT `student_roll_no` FROM `tm_student_class` WHERE `student_enrollment_no`='$student_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";   
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  announcement: '.mysqli_error($this->conn));
         while ($row = $result->fetch_assoc()) {
                      
                     $data[] = $row;
                 } 
         return $data[0]['student_roll_no'];
            
}
public function getBatchShiftStudent($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $temp_session=$this->getCurrentOrUpcomingSession($school_code);
    $new_session_id=$temp_session[0]['session_id'];
    //echo $new_session_id;

    $sql="SELECT a.`student_enrollment_no`,b.`sr_admission_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN (SELECT * FROM `tm_student_class` WHERE `school_code`='$school_code' AND `session_id`='$new_session_id') a1 ON a.`student_enrollment_no`=a1.`student_enrollment_no` LEFT JOIN `tm_student_admission`b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' AND a1.`student_enrollment_no`  IS NULL ORDER BY a.`student_roll_no` ASC";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                         $row['class']=$class;
                        $data[] = $row;
                 }
        return $data;

}
public function getContactUsList()
{
    
         $sql="SELECT `contact_id`,`contact_name`,`contact_number`,`designation`,`languages`,`on_call`,`on_whatsapp` FROM `tm_contact_us` WHERE `status`='Active'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  contact os list : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data;

}

public function getSchoolLogoPath($school_code)
{
    
         $sql="SELECT `school_logo_path` FROM `tm_school_details` WHERE `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  school logo path : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data[0]['school_logo_path'];

}

public function getAttachmentPermission($school_code)
{
    
         $sql="SELECT `document_type_id`,`document_type_name`,`file_type`,`status` FROM `tm_attachment_documents_type` WHERE `status`='Active'";
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting document type : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {                     
                  $document_type_id=$row['document_type_id'];   

                $sql2="SELECT * FROM `tm_attachment_documents_permission` WHERE `document_type_id`='$document_type_id' AND `school_code`='$school_code'";  
                $result2=mysqli_query($this->conn,$sql2)or die ('Error in getting added permissions:'.mysqli_error($this->conn));  
                if(mysqli_affected_rows($this->conn)>0)   
                {

                } 
                else{
                     $sql3="INSERT INTO `tm_attachment_documents_permission` (`id`, `school_code`, `document_type_id`, `server_id`, `isPermissionGranted`, `status`, `date_added`) 
                     VALUES (NULL, '$school_code', '$document_type_id', 'SVR01', '1', 'Active', CURRENT_TIMESTAMP)";


                   $result3=mysqli_query($this->conn,$sql3)or die ('Error in adding permission:'.mysqli_error($this->conn));
                }
                 
         }

         $sql4="SELECT a.`school_code`,a.`document_type_id`,b.`document_type_name`,b.`file_type`,a.`server_id`,a.`isPermissionGranted`,c.`server_name`,c.`server_ip`,c.`server_domain`,c.`document_dir` FROM `tm_attachment_documents_permission` a LEFT JOIN `tm_attachment_documents_type` b ON a.`document_type_id`=b.`document_type_id` LEFT JOIN `tm_attachment_documents_server` c ON a.`server_id`=c.`server_id` WHERE a.`isPermissionGranted`='1' AND a.`status`='Active' AND `school_code`='$school_code'";
     

         $result4=mysqli_query($this->conn,$sql4)or die ('Error in getting  attachment permission : '.mysqli_error($this->conn));
                 
                 while ($row = $result4->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data;

}

public function getClassAttachment($session_id,$class_id,$school_code)
{
    
         $sql="SELECT a.`session_id`,a.`attachment_id`,a.`document_type_id`,b.`document_type_name`,a.`server_ip`,a.`document_dir`,a.`document_name`,a.`subject_id`,c.`subject_name`,a.`topic`,a.`description`,a.`attachment_date`,a.`recipient_id` FROM `tm_attachment_documents` a LEFT JOIN `tm_attachment_documents_type` b ON a.`document_type_id`=b.`document_type_id` LEFT JOIN (SELECT `subject_id`,`subject_name` FROM `tm_subject` WHERE `school_code`='$school_code' AND `status`='Active') c ON a.`subject_id`=c.`subject_id`  WHERE INSTR(a.`recipient_id` , '$class_id') AND a.`session_id`='$session_id' AND a.`school_code`='$school_code' AND  a.`status`='Active' ORDER BY a.`id` DESC";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attachment  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $server_ip=$row['server_ip'];
                        $document_dir=$row['document_dir'];
                        $document_name=$row['document_name'];
                        if($document_dir!='NULL')
                        {

                            $img='http://'.$server_ip."/".$document_dir."/".$document_name;
                            $row['file_url']=trim(preg_replace('/\s\s+/', '', $img));
                        }
                        else{
                            $row['file_url']='NULL'; 
                        }
                       
                        $data[] = $row;
                 }
        return $data;

}
public function getAdmissionLink()
{
    
         $sql="SELECT `admission_link_id`,`admission_link`,`admission_link_name` FROM `tm_admission_base_link` WHERE `status`='Active'";
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  admission link : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data;

}
public function getAttachmentDownloadReport($school_code,$attachment_id,$session_id)
{
    
         $sql="SELECT `recipient_id` FROM `tm_attachment_download_report` WHERE `attachment_id`='$attachment_id' AND `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attachment download report : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       $recipient_id=$row['recipient_id'];
                       $student=$this->findStudent($recipient_id,$session_id,$aadhar_no,$school_code);
 
                       $data[] = $student[0];
                 }
        return $data;

}
public function getHomeworkSolutionSubmitReport($school_code,$class_id,$section_id,$subject_id,$homework_date,$session_id)
{
    
         $sql="SELECT `student_id` FROM `tm_class_homework_solution` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `subject_id`='$subject_id' AND `homework_date`='$homework_date' AND `school_code`='$school_code'";
    

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  homework submit report : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       $student_id=$row['student_id'];
                       $student=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);

                       $data[] = $student[0];
                 }
        return $data;

}
public function getHomeworkSolutionImgPath($student_id,$homework_id,$school_code)
{
    
         $sql="SELECT `homework_solution_img` FROM `tm_class_homework_solution` WHERE `student_id`='$student_id' AND `school_code`='$school_code' AND `homework_id`='$homework_id'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  homework solution path : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data[0]['homework_solution_img'];

}
public function getHomeworkSolution($student_id,$homework_id,$school_code)
{
    
         $server_name=$_SERVER['SERVER_NAME'];
         $sql="SELECT `solution_id`,`homework_id`,`homework_solution`,`homework_solution_img`,`document_name`,`remark` FROM `tm_class_homework_solution` WHERE `homework_id`='$homework_id' AND `student_id`='$student_id' AND `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  homework solution  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                    
                        $homework_solution_img=$row['homework_solution_img'];
                    
                        $img='http://'.$server_name."/".$homework_solution_img;
                        $row['homework_solution_img']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }
        return $data;

}


public function getClassAttachmentExercise($class_id,$section_id,$attachment_id,$school_code)
{
    
    $sql="SELECT `exercise_id`,`staff_id`,`attachment_id`,`session_id`,`class_id`,`section_id`,`subject_id`,`exercise_date`,`exercise_img`,`exercise` FROM `tm_attachment_exercise` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `attachment_id`='$attachment_id' AND `school_code`='$school_code'";   

                     $result=mysqli_query($this->conn,$sql)or die ('Error in getting  class attachment exercise : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
public function getAttachmentExerciseSolutionImgPath($student_id,$exercise_id,$school_code)
{
    
         $sql="SELECT `solution_img` FROM `tm_attachment_solution` WHERE `student_id`='$student_id' AND `exercise_id`='$exercise_id' AND `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  exercise solution path : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data[0]['solution_img'];

}
public function getAttachmentSolution($student_id,$attachment_id,$exercise_id,$school_code)
{
    
         $server_name=$_SERVER['SERVER_NAME'];
         $sql="SELECT `solution_id`,`attachment_id`,`exercise_id`,`solution`,`solution_img`,`document_name`,`remark`,`session_id` FROM `tm_attachment_solution` WHERE `student_id`='$student_id' AND `attachment_id`='$attachment_id' AND `exercise_id`='$exercise_id' AND `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attachment solution  : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                    
                        $solution_img=$row['solution_img'];
                    
                        $img='http://'.$server_name."/".$solution_img;
                        $row['solution_img']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }
        return $data;

}
public function getAttachmentSolutionSubmitReport($school_code,$class_id,$section_id,$attachment_id,$session_id)
{
    
         $sql="SELECT `student_id` FROM `tm_attachment_solution` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `attachment_id`='$attachment_id'  AND `school_code`='$school_code'";
    

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  attachment solution submit report : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       $student_id=$row['student_id'];
                       $student=$this->findStudent($student_id,$session_id,$aadhar_no,$school_code);

                       $data[] = $student[0];
                 }
        return $data;

}

public function getAllAdmissionQuery($school_code,$session_id)
{
    
         $sql="SELECT `school_code`,`request_id`,`session_id`,`student_name`,`gender`,`community`,`religion`,`nationality`,`previous_school_name`,`board_id`,`medium_id`,`previous_class`,`previous_class_id`,`query_class`,`query_class_id`,`father_name`,`contact_number`,`address`,`remark`,`date_added`,`status` FROM `tm_admission_request` WHERE `school_code`='$school_code' AND `session_id`='$session_id'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  admission query : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data;

}
public function getStaffWhoAddedAttachment($school_code,$attachment_id)
{
    
         $sql="SELECT `staff_id` FROM `tm_attachment_documents` WHERE `attachment_id`='$attachment_id' AND `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   staff id : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data[0]['staff_id'];

}

public function getSubjectOfAttachment($school_code,$attachment_id)
{
    
         $sql="SELECT `staff_id` FROM `tm_attachment_documents` WHERE `attachment_id`='$attachment_id' AND `school_code`='$school_code'";
     

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   staff id : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                       
                        $data[] = $row;
                 }
        return $data[0]['staff_id'];

}
public function getStudentTc($admission_no,$student_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `student_id`,`student_admission_no`,`session_id`,`tc_image_path` FROM `tm_student_transfered` WHERE (`student_admission_no`='$admission_no' OR `student_id`='$student_id') AND `school_code`='$school_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student tc : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

                        $tc_image_path=$row['tc_image_path'];
                
                        $img='http://'.$server_name."/".$tc_image_path;
                        $row['tc_image_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getFeeReceiptSettingsData($school_code)
{
    
    $sql="SELECT `school_code`,`setting_id`,`setting_name`,`setting_type`,`setting_value` FROM `tm_fee_receipt_settings` WHERE `school_code`='$school_code'  AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee receipt data : '.mysqli_error($this->conn));
                 while ($row = $result->fetch_assoc()) {

                        $setting_id=$row['setting_id'];
                        $setting_type=$row['setting_type'];
                        if($setting_type=="MCQ")
                        {

                        $option=$this->getFeeReceiptSettings_mcq_options($setting_id);
                        $row['options']=$option;
                        }
                        $data[] = $row;
                 }
        if($data)
        {

           return $data;

        } 
        else{
           $result= $this->addFeeReceiptDefaultSettings($school_code);
           if($result)
           {
                $sql="SELECT `school_code`,`setting_id`,`setting_name`,`setting_type`,`setting_value` FROM `tm_fee_receipt_settings` WHERE `school_code`='$school_code'  AND `status`='Active'";
     
                $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee receipt data : '.mysqli_error($this->conn));
                 while ($row = $result->fetch_assoc()) {

                        $setting_id=$row['setting_id'];
                        $setting_type=$row['setting_type'];
                        if($setting_type=="MCQ")
                        {

                           $option=$this->getFeeReceiptSettings_mcq_options($setting_id);
                           $row['options']=$option;
                        }
                        $data[] = $row;
                 }
                 return $data;


           }
           else{
            return $result;
           }
        }        
        
}
public function getFeeReceiptSettings_mcq_options($setting_id)
{
    
    $sql="SELECT `setting_options` FROM `tm_fee_receipt_settings_master` WHERE `setting_id`='$setting_id'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee receipt data : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $setting_options=$row['setting_options'];
                        $data[] = $row;
         }
         
        return $data;
}
public function addFeeReceiptDefaultSettings($school_code)
{
    
    
    $sql="SELECT `setting_id`,`setting_name`,`setting_type`,`setting_value` FROM `tm_fee_receipt_settings_master` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in adding  default  fee receipt data : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                $setting_id=$row['setting_id'];
                $setting_name=$row['setting_name'];
                $setting_type=$row['setting_type'];
                $setting_value=$row['setting_value'];
                   
                $sql="INSERT INTO `tm_fee_receipt_settings` (`id`, `school_code`, `setting_id`, `setting_name`, `setting_type`, `setting_value`, `date_added`, `status`) 
                VALUES (NULL, '$school_code', '$setting_id', '$setting_name', '$setting_type', '$setting_value', CURRENT_TIMESTAMP, 'Active')";
     
                   $result2=mysqli_query($this->conn,$sql)or die ('Error in adding  default fee receipt data2 : '.mysqli_error($this->conn));           

            }
    return $result2;

}
public function getStaffDashBoard($session_id,$year,$month,$school_code)
{
    
    $staff_list=$this->getStaff($school_code);
    $dashboard['staff_list']=$staff_list;

    $staff_attendance=$this->getStaffAttendanceOfMonthYear($month,$year,$school_code);
    $dashboard['staff_attendance']=$staff_attendance;
    

    return $dashboard;

}
public function getDayBookDashboard($session_id,$school_code)
{
    
    $total_expense_cash_out=$this->getDaybookExpenseCashOut($session_id,$school_code);
    if($total_expense_cash_out==NULL)
    {

       $dashboard['total_expense_cash_out']="0";
    }
    else{

      $dashboard['total_expense_cash_out']=$total_expense_cash_out;
    }

    $total_expense_cash_in=$this->getDaybookExpenseCashIn($session_id,$school_code);
    if($total_expense_cash_in==NULL)
    {

       $dashboard['total_expense_cash_in']="0";
    }
    else{

       $dashboard['total_expense_cash_in']=$total_expense_cash_in;
    }


    return $dashboard;

}

public function getDaybookExpenseCashOut($session_id,$school_code)
{
    
    $sql="SELECT SUM(`amount`)as total_expense_cash_out FROM `tm_daybook_entry` WHERE `entry_type`='CASH_OUT' AND `school_code`='$school_code' AND `session_id`='$session_id' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  day book  expense cash out  : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;
         }
         
        return $data[0]['total_expense_cash_out'];
}
public function getDaybookExpenseCashIn($session_id,$school_code)
{
    
    $sql="SELECT SUM(`amount`)as total_expense_cash_in FROM `tm_daybook_entry` WHERE `entry_type`='CASH_IN' AND `school_code`='$school_code' AND `session_id`='$session_id' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  day book  expense cash out  : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;
         }
         
        return $data[0]['total_expense_cash_in'];
}
public function getDaybookAddExpenseData($school_code)
{
    
    $DaybookCategory=$this->getDaybookCategory($school_code);
    $data['DaybookCategory']=$DaybookCategory;

    $DaybookParty=$this->getDaybookParty($school_code);
    $data['DaybookParty']=$DaybookParty;

    $DaybookRemark=$this->getDaybookRemark($school_code);
    $data['DaybookRemark']=$DaybookRemark;
    

    return $data;

}
public function getDaybookCategory($school_code)
{
    
    $sql="SELECT `school_code`,`category_id`,`category_name` FROM `tm_daybook_category` WHERE `school_code`='$school_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  day book category: '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;
         }
         
        return $data;
}
public function getDaybookParty($school_code)
{
    
    $sql="SELECT `school_code`,`party_id`,`party_name` FROM `tm_daybook_party` WHERE `school_code`='$school_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  day book  party  : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;
         }
         
        return $data;
}
public function getDaybookRemark($school_code)
{
    
    $sql="SELECT `remark` FROM `tm_daybook_entry` WHERE `school_code`='$school_code' AND `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  day book expense remark: '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;
         }
         
        return $data;
}
public function getDaybookExpenseList($session_id,$school_code)
{
    
    $sql="SELECT a.`school_code`,a.`session_id`,a.`entry_id`,a.`party_id`,c.`party_name`,a.`category_id`,b.`category_name`,a.`amount`,a.`entry_date`,a.`entry_type`,a.`remark` FROM `tm_daybook_entry` a LEFT JOIN (SELECT * FROM `tm_daybook_category` WHERE `school_code`='$school_code') b
 ON a.`category_id`=b.`category_id`  LEFT JOIN (SELECT * FROM `tm_daybook_party` WHERE `school_code`='$school_code') c ON a.`party_id`=c.`party_id` WHERE a.`session_id`='$session_id' AND a.`school_code`='$school_code' AND a.`status`='Active' ORDER BY a.`entry_date` DESC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  day book expense list : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;
         }
         
        return $data;
}



public function getPayRollDashboard($session_id,$school_code)
{
    //$this->getStaffSalary($staff_id,$payment_type_id,$salary,$joining_date,$school_code);

    $payroll_staff_list=$this->getPayRollStaffList($session_id,$school_code);
    $data['payroll_staff_list']=$payroll_staff_list;

    $salary_payment_type=$this->getPayRollSalaryPaymentType($school_code);
    $data['salary_payment_type']=$salary_payment_type;

    

    return $data;

}

public function getPayRollSalaryPaymentType($school_code)
{
    
    $sql="SELECT `payment_type_id`,`payment_type_name`,`description` FROM `tm_payroll_payment_type` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  payroll salary payment type : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;

         }
         
        return $data;
}
public function getPayRollStaffList($session_id,$school_code)
{
    
    $sql="SELECT a.`school_code`,a.`staff_id`,b.`staff_name`,a.`payment_type_id`,a.`salary`,a.`salary_circle`,a.`working_hour`,a.`joining_date`,a.`week_off`,a.`is_sms_alert` FROM `tm_payroll_staff_details` a LEFT jOIN `tm_staff_master`
   b ON a.`staff_id`=b.`staff_id` WHERE a.`school_code`='$school_code' AND a.`status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  payroll staff list : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $staff_id=$row['staff_id'];
                        $payment_type_id=$row['payment_type_id'];
                        $salary=$row['salary'];
                        $joining_date=$row['joining_date'];
                        
                        $salary=$this->getStaffSalary($staff_id,$payment_type_id,$salary,$joining_date,$school_code);
                        $row['salary_details']=$salary;
                        $data[] = $row;
                        
         }
         
        return $data;
}
public function calculateStaffSalary($staff_id,$payment_type_id,$salary,$joining_date,$school_code)
{
    
    $sql="SELECT `payment_type_id`,`payment_type_name`,`description` FROM `tm_payroll_payment_type` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  payroll salary payment type : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;

         }
         
        return $data;
}
public function getStaffSalary($staff_id,$payment_type_id,$salary,$joining_date,$school_code)
{
    
    $sql="SELECT `school_code`,`session_id`,`staff_id`,`payment_type_id`,`salary`,`month`,`month2`,`staff_present`,`staff_absent`,`staff_leave`,`paid_leave`,`half_day`,`week_off`,`is_week_off_paid`, `holiday`,`is_holiday_paid`,`net_salary` FROM `tm_payroll_staff_salary` WHERE `staff_id`='$staff_id' AND `session_id`='' AND `payment_type_id`='$payment_type_id' AND `status`='Active' AND `school_code`='$school_code'";
      // echo $sql;
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  payroll salary payment type : '.mysqli_error($this->conn));
            while ($row = $result->fetch_assoc()) {

                        $data[] = $row;

         }
         
        return $data;
}

public function getStudentSearchIndex($school_code)
{

     $sql="SELECT `search_keyword` FROM `tm_student_search_index` WHERE `status`='Active' AND `school_code`='$school_code'";
     $result=mysqli_query($this->conn,$sql)or die ('Error in student search index: '.mysqli_error($this->conn)); 
     while ($row = $result->fetch_assoc()) {
                            
                $data[] = $row;
         }
        return $data;
        
}
public function getStudentSearchOptions($school_code)
{

     $sql="SELECT `search_option`,`search_caption` ,`isChecked`FROM `tm_student_search_options` WHERE `status`='Active'";
     $result=mysqli_query($this->conn,$sql)or die ('Error in search option: '.mysqli_error($this->conn)); 
     while ($row = $result->fetch_assoc()) {
                            
                $data[] = $row;
         }
        return $data;
        
}
public function searchStudentList($keyword,$strOption,$school_code)
{
    $session_id=$this->getCurrentSession($school_code);

    $arrOption = json_decode($strOption, TRUE);    
    $arrOption = json_decode($strOption, TRUE);
     

    for ($i=0; $i <count($arrOption) ; $i++) { 
        if($i==0)
        {
            $option='a.`'.$arrOption[$i].'` like '.'\'%'.$keyword.'%\'';
        
        }
        else{
            $option=$option.' OR '.'a.`'.$arrOption[$i].'` like '.'\'%'.$keyword.'%\'';
        
        }

        //a.`school_name`like '%$keyword%' OR a.`school_code` like '%$keyword%' OR a.`admin_name` like '%$keyword%' OR a.`admin_phone` like '%$keyword%' OR a.`country` like '%$keyword%' OR a.`state` like '%$keyword%'
    }

    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,a.`stu_name` ,a.`gender`,a.`student_img_path`,a.`father_name`FROM `tm_student_admission` a WHERE ($option)  AND a.`status`!='InActive'  AND  a.`school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
          if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;
                        $data[] = $row;
                 }
           $this->prepareStudentSearchIndex($keyword,$school_code);     
         }         
        return $data;

}
public function prepareStudentSearchIndex($keyword,$school_code)
{

     $sql="SELECT * FROM `tm_student_search_index` WHERE `search_keyword`='$keyword' AND  `school_code`='$school_code'";
     $result=mysqli_query($this->conn,$sql)or die ('Error in prepareSearchIndex: '.mysqli_error($this->conn)); 
     while ($row = $result->fetch_assoc()) {
                            
                $data[] = $row;
         }
         if($data)
         {

         }
         else{
            $sql2="INSERT INTO `tm_student_search_index` (`id`,`school_code`, `search_keyword`, `status`, `date_added`) 
            VALUES (NULL,'$school_code', '$keyword', 'Active', CURRENT_TIMESTAMP)";
            $result2=mysqli_query($this->conn,$sql2)or die ('Error in prepareSearchIndex :'.mysqli_error($this->conn));
         }
        
}
public function prepareAllStudentSearchIndex()
{

     $sql="SELECT `school_code`,`school_name`,`school_address`,`country`,`state`,`admin_name`,`admin_phone` FROM `tm_school_master` WHERE `status`='Active'";
     $result=mysqli_query($this->conn,$sql)or die ('Error in prepare all SearchIndex: '.mysqli_error($this->conn)); 
     while ($row = $result->fetch_assoc()) {

                $school_code=$row['school_code'];
                $school_name=$row['school_name'];
                $school_address=$row['school_address'];
                $country=$row['country'];
                $state=$row['state'];
                $admin_name=$row['admin_name'];
                $admin_phone=$row['admin_phone'];

                $this->prepareSearchIndex($school_code); 
                $this->prepareSearchIndex($school_name); 
                $this->prepareSearchIndex($school_address); 
                $this->prepareSearchIndex($country); 
                $this->prepareSearchIndex($state); 
                $this->prepareSearchIndex($admin_name); 
                $this->prepareSearchIndex($admin_phone); 
                            
                $data[] = $row;
         }
     return $data;   
        
}

public function getAppUserStudent($class_id,$section_id,$session_id,$school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];

    $sql="SELECT a.`student_enrollment_no`,b.`sr_admission_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` FROM `tm_student_class`a LEFT JOIN  `tm_student_admission` b ON a.`student_enrollment_no`=b.`student_enrollment_no`WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                        $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;
                        $contact=$this->getStudentContactDetails($enrollment_no);
                        $row['contact_details']=$contact;

                        $FirebaseId=$this->getStudentFirebaseId($enrollment_no,$school_code);
                        $row['FirebaseId']=$FirebaseId;
                       
                        $data[] = $row;
                 }
        return $data;
    
}
public function getStudentFirebaseId($enrollment_no,$school_code)
{
     $sql="SELECT `firebase_id`,`student_enrollment_no`,`device_id` FROM `tm_student_firebase_token` WHERE `student_enrollment_no`='$enrollment_no' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student firebase id: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                       
                        $data[] = $row;
                 }
        return $data;

}
public function getAppUserMatrixData($session_id,$school_code)
{
    $board=$this->getBoard($school_code,$session_id);
    $data['board']=$board;

    $medium=$this->getMedium($school_code,$session_id);
    $data['medium']=$medium;

    $class=$this->getAppUserMatrix($session_id,$school_code);
    $data['class']=$class;
    

    return $data;

}

public function getAppUserMatrix($session_id,$school_code)
{
   $sql="SELECT a.`school_code`,a.`session_id`,a.`class_id`,a.`class_name`,a.`board_id`,b.`board_name`,a.`medium_id`,c.`medium_name` FROM `tm_class` a LEFT JOIN (SELECT * FROM `tm_board` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') b ON a.`board_id`=b.`board_id`
        LEFT JOIN (SELECT * FROM `tm_medium` WHERE `school_code`='$school_code' AND `status`='Active' AND `session_id`='$session_id') c ON a.`medium_id`=c.`medium_id` WHERE a.`session_id`='$session_id' AND a.`status`='Active' AND a.`school_code`='$school_code' ORDER BY a.`id` ASC"; 
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   ClassWithSection '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {

                        $class_id=$row['class_id'];   
                        $section=$this->getClassSection($class_id,$session_id,$school_code);
                        if($section)
                        {
                            for ($i=0; $i<count($section) ; $i++) { 
                                $section_id=$section[$i]['section_id'];
                                $app_user=$this->getAppUserCount($class_id,$section_id,$session_id,$school_code);
                                $section[$i]['app_user']=$app_user;
                                $student=$this->getStudentCount($class_id,$section_id,$session_id,$school_code);
                                $section[$i]['student']=$student;
                                   
                            }
                            $row['section']=$section;
                        }
                        else{
                            $row['section']='No';
                            $section_id='No';
                            $app_user=$this->getAppUserCount($class_id,$section_id,$session_id,$school_code);
                            $row['app_user']=$app_user;
                        
                            $student=$this->getStudentCount($class_id,$section_id,$session_id,$school_code);
                            $row['student']=$student;
                                   
                        }
                        
                        $data[] = $row;
                 }
        return $data;

    
}
public function getAppUserCount($class_id,$section_id,$session_id,$school_code)
{
     $sql="SELECT COUNT(*) as total FROM `tm_student_class` a INNER JOIN (SELECT DISTINCT `student_enrollment_no` FROM `tm_student_firebase_token` WHERE `school_code`='$school_code') b ON b.`student_enrollment_no` = a.`student_enrollment_no` WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`school_code`='$school_code' ";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  app user count: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                       
                        $data[] = $row;
                 }
        return $data[0]['total'];

}

public function getPaymentGatewayDetails($school_code)
{
    $sql="SELECT `school_code`,`payment_gateway_id`,`payment_gateway_name`,`is_ipg`,`merchant_id`,`merchant_key`,`merchant_salt` FROM `tm_payment_gateway` WHERE `status`='Active' AND `school_code`='$school_code'";

     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting   payment gateway details '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data;

}
//exporting 
public function exportStudentData($all_class_data,$class_id,$section_id,$session_id,$school_code)
{
    $common=new Common();
    $common->giveFilePermission();

    $server_name=$_SERVER['SERVER_NAME'];
    //echo $server_name;
    $file_name=$school_code.'_'.'student_data.csv';
    $output='INTO OUTFILE '.'\''.$server_name."/".'Export'."/".$file_name.'\''.' FIELDS TERMINATED BY  '.'\'#\''.' ENCLOSED BY '. '\'"\''.' LINES TERMINATED BY '. '\'\n\'';
     //echo $output;


    $sql="SELECT a.`student_enrollment_no`,b.`sr_admission_no`,b.`password`,a.`student_roll_no`,b.`stu_name`,b.`gender`,b.`father_name`,b.`student_img_path` $output FROM `tm_student_class`a  LEFT JOIN  `tm_student_admission` b ON a.`student_enrollment_no`=b.`student_enrollment_no` WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`status`!='InActive'  AND a.`school_code`='$school_code' ORDER BY a.`student_roll_no` ASC ";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $enrollment_no=$row['student_enrollment_no'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=trim(preg_replace('/\s\s+/', '', $img));
                       /* $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        $row['class']=$class;*/
                        $data[] = $row;
                 }
        return $data;

}

public function getExportDataMaster()
{

    $sql="SELECT `export_data_id`,`export_data_caption`,`activity` FROM `tm_export_data_master` WHERE `status`='Active'";
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  export data master : '.mysqli_error($this->conn));
                 
        while ($row = $result->fetch_assoc()) {
                       
            $data[] = $row;
        }
    return $data;

}
public function getIdCardSampleData($sample_id,$school_code)
{

    $sql="SELECT a.`sample_id`,a.`setting_id`,a.`setting_name`,a.`option_id`,a.`css_id`,a.`setting_remark`,b.`option_name`,b.`option_remark`,b.`add_class`,b.`remove_class` FROM `tm_student_idcard_settings` a LEFT JOIN `tm_student_idcard_settings_options` b ON (a.`option_id`=b.`option_id` AND a.`setting_id`=b.`setting_id`) WHERE a.`status`='Active'";
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  id card sample data : '.mysqli_error($this->conn));
                 
        while ($row = $result->fetch_assoc()) {
             $setting_id=$row['setting_id'];
             $option_id=$row['option_id'];

             $attribute=$this->getSettingAttribute($sample_id,$setting_id,$option_id,$school_code); 
             $row['attribute']=$attribute;        
             $data[] = $row;
        }
    return $data;

}
public function getSettingAttribute($sample_id,$setting_id,$option_id,$school_code)
{

    if($option_id)
    {
        $sql="SELECT `attribute_id`,`attribute_name`,`attribute_value`,`is_unit_required`,`unit`,`measurable_value` FROM `tm_student_idcard_default_attribute` WHERE `sample_id`='$sample_id' AND `setting_id`='$setting_id' AND `option_id`='$option_id' AND `status`='Active'";
    }
    else{
        $sql="SELECT `attribute_id`,`attribute_name`,`attribute_value`,`is_unit_required`,`unit`,`measurable_value` FROM `tm_student_idcard_default_attribute` WHERE `sample_id`='$sample_id' AND `setting_id`='$setting_id'  AND `status`='Active'";
    }
    
     
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting  id card sample data : '.mysqli_error($this->conn));
                 
        while ($row = $result->fetch_assoc()) {
                  
             $data[] = $row;
        }
    return $data;

}



public function getStudentManagementDashBoard($session_id,$school_code)
{
    

    $total_active_student=$this->getTotalStudent_count($session_id,$school_code);
    $dashboard['total_active_student']=$total_active_student;

    $total_inactive_student=$this->getInActiveStudent_count($session_id,$school_code);
    $dashboard['total_inactive_student']=$total_inactive_student;

    $total_delisted_student=$this->getDelistedStudent_count($school_code);
    $dashboard['total_delisted_student']=$total_delisted_student;


    return $dashboard;

}
public function getDelistedStudent_count($school_code)
{
    $sql="SELECT count(*) as total FROM `tm_student_admission` WHERE `status`='Delisted'  AND `school_code`='$school_code'";
    $result=mysqli_query($this->conn,$sql)or die ('Error in getting   total delisted student '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
                 }
        return $data[0]['total'];

}

public function getStudentIdCardSample($school_code)
{
    $server_name=$_SERVER['SERVER_NAME'];
    $sql="SELECT `sample_id`,`sample_name`,`sample_remark`,`file_directory`,`file_name`,`is_both_side`,`file_name_back`,`sample_img_dir`,`sample_img`,`system_code` FROM `tm_student_idcard_sample` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student id card sample : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

        
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getSelectedStudentDetailsWithAdmitCard($selected_student_ids,$session_id,$exam_id,$school_code)
{
    unset($data);
        $arr_selected_student_ids = json_decode($selected_student_ids, TRUE);
       
        $str_selected_student_ids= "'" . implode ( "', '", $arr_selected_student_ids ) . "'";
       $server_name=$_SERVER['SERVER_NAME'];
    
        $sql="SELECT `student_enrollment_no`,`stu_name` ,`gender`,`student_img_path`,`father_name`,`sr_admission_no`,`bloodgroup`,`religion`,`nationality`,`community`,`current_address`,`permanent_address`,`mother_name`,`email_id` FROM `tm_student_admission` WHERE `student_enrollment_no` IN ($str_selected_student_ids) AND `status`!='InActive'";
        //echo $sql;

         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {
                        $student_img_path=$row['student_img_path'];
                        $img='http://'.$server_name."/".$student_img_path;
                        $row['student_img_path']=$img;

                         $enrollment_no=$row['student_enrollment_no'];
                         $class=$this->getClassOfStudent($enrollment_no,$session_id,$school_code);
                        
                         $row['class']=$class;
                         $class_id=$class[0]['class_id'];
                         $section_id=$class[0]['section_id'];
                         $guideline=$this->getExamGuideline($exam_id,$class_id,$section_id,$session_id,$school_code);
                         $row['guideline_list']=$guideline;
                         $date_sheet=$this->getExamDateSheet($exam_id,$class_id,$section_id,$session_id,$school_code);
                         $row['date_sheet']=$date_sheet;

                         $data[] = $row;
                 }             
         }
         else{
            return $result;

         }
     
     
     return $data;
         

}

public function getExamGuideline($exam_id,$class_id,$section_id,$session_id,$school_code)
{
    $sql="SELECT `guideline_id`,`exam_id`,`class_id`,`section_id`,`guideline` FROM `tm_exam_guideline` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `exam_id`='$exam_id' AND `status`='Active'";
   // echo $sql;
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  exam guideline : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

        
                        $data[] = $row;
                 }
         }
        
        return $data;
}

public function getExamDateSheet($exam_id,$class_id,$section_id,$session_id,$school_code)
{
    $sql="SELECT a.`datesheet_id`,a.`session_id`,a.`exam_id`,a.`class_id`,a.`section_id`,a.`subject_id`,b.`subject_name`,a.`subject_paper_id`,c.`exam_paper_name`,a.`exam_date`,a.`exam_shift`,a.`exam_time` FROM `tm_exam_datesheet` a LEFT JOIN (SELECT * FROM `tm_subject` WHERE `school_code`='$school_code' AND `status`='Active') b ON a.`subject_id`=b.`subject_id` LEFT jOIN (SELECT * FROM `tm_exam_paper` WHERE `exam_id`='$exam_id' AND `class_id`='$class_id' AND `section_id`='$section_id'  AND `school_code`='$school_code') c ON a.`subject_paper_id`=c.`exam_paper_id` WHERE a.`class_id`='$class_id' AND a.`section_id`='$section_id' AND a.`session_id`='$session_id' AND a.`exam_id`='$exam_id' AND a.`status`='Active'";
    //echo $sql;
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  exam date sheet : '.mysqli_error($this->conn));
         if($result)
         {
                 while ($row = $result->fetch_assoc()) {

        
                        $data[] = $row;
                 }
         }
        
        return $data;
}





}
?>

