<?php

date_default_timezone_set('Asia/Kolkata');
 class updateFunctions{
  
    private $conn;
   
       
    // constructor
    function __construct() {
        require_once 'DB_Connect.php';
        require_once 'Automation.php';
        require_once ('Common.php');
        require_once ('setFunctions.php');
        require_once ('getFunctions.php');
       
        $db = new Db_Connect();
        $this->conn = $db->connect();
        mysqli_set_charset($this->conn,'utf8'); 
       
    }


    public function updateStaffPrivilege($staff_id,$module_id,$status,$school_code)
    {

        $sql="UPDATE `tm_privilege_master` SET `status` = '$status' WHERE `staff_id`='$staff_id' AND `module_id`='$module_id' AND `school_code`='$school_code'";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff privilege:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
        
                $sql="INSERT INTO `tm_privilege_master` (`id`,`school_code`, `staff_id`, `module_id`, `status`, `date_added`) 
                VALUES (NULL,'$school_code', '$staff_id', '$module_id', '$status',CURRENT_TIMESTAMP)";


                $result2=mysqli_query($this->conn,$sql)or die ('Error in updating staff privilege:'.mysqli_error($this->conn));
                 return $result2;


            }
    }

    public function updateModuleStatus($module_id,$status)
    {

       $sql="UPDATE `tm_modules` SET `status` = '$status' WHERE `module_id`='$module_id'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating module status:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
    public function updateStaffPersonalDetails($staff_id,$StaffName,$phone,$email,$Department_id, $doj,$dob,$gender,$religion,$aadhar_no,$nationality, $role,$login_type,$address)
    {


       $sql=" UPDATE `tm_staff_master` SET `staff_name` = '$StaffName',`aadhar_no`='$aadhar_no',`department_id`='$Department_id',`staff_gender`='$gender',`staff_phone`='$phone',`staff_email`='$email',`staff_dob`='$dob',`joining_date`='$doj',`staff_role`='$role',`login_type`='$login_type',`staff_religion`='$religion',`nationality`='$nationality',`staff_address`='$address' WHERE `staff_id`='$staff_id'";   
      // echo $sql; 
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff personal details:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

     public function updateStudentPersonalDetails($enrollment_no,$student_name,$dob,$gender,$community, $religion,$aadhar_no,$nationality, $curAddress,$perAddress,$staff_id)
    {

       $sql=" UPDATE `tm_student_admission` SET `stu_name` = '$student_name',`adharcard_no`='$aadhar_no',`birthday`='$dob',`gender`='$gender',`community`='$community',`religion`='$religion',`nationality`='$nationality',`current_address`='$curAddress',`permanent_address`='$perAddress',`staff_id`='$staff_id' WHERE `student_enrollment_no`='$enrollment_no'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating student personal details:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

     public function updateStudentFamilyDetails($enrollment_no,$father_name,$father_occupation,$mother_name,$mother_occupation)
    {

       $sql=" UPDATE `tm_student_admission` SET `father_name` = '$father_name',`father_occupation`='$father_occupation',`mother_name`='$mother_name',`mother_occupation`='$mother_occupation' WHERE `student_enrollment_no`='$enrollment_no'";    
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating student family details:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
     public function updateStudentContactDetails($enrollment_no,$contact1,$contact2,$contact_person_name1,$contact_person_name2,$contact_person_relation1,$contact_person_relation2,$email,$school_code)
    {
        $UPDATE_TRUE=false;
        $UPDATE_FALSE=false;
        if(isset($email))
        {
                         
            $status=$this->updateStudentEmailId($enrollment_no,$email);
            if($status)
            {
                    $UPDATE_TRUE=true;
            }

        }

         $sql="SELECT * FROM `tm_student_contact` WHERE `student_enrollment_no`='$enrollment_no'";     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  Students contact: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $data[] = $row;
            }

        if($data[0])
        {
            $id=$data[0]['id'];
            $status=$this->updateContact($contact1,$contact_person_relation1,$contact_person_name1,$id);
            if($status)
            {
                    $UPDATE_TRUE=true;
            }

            
        } 
        
          
        if($data[1])
        {
            $id=$data[1]['id'];
            $status=$this->updateContact($contact2,$contact_person_relation2,$contact_person_name2,$id);
            if($status)
            {
                    $UPDATE_TRUE=true;
            }
            
        }
        else{

            $set=new setFunctions();
            $status=$set->addStudentContact($enrollment_no,$contact2,$contact_person_relation2,$contact_person_name2,$school_code);
            if($status)
            {
                    $UPDATE_TRUE=true;
            }
           
        }
     if($UPDATE_TRUE)
     {
            return $UPDATE_TRUE;
     }
     else{
        return $UPDATE_FALSE;
     }       
        
       
           
    }
    public function updateContact($contact,$contact_person_relation,$contact_person_name,$id)
    {

       $sql="UPDATE `tm_student_contact` SET `contact_number`='$contact',`contact_person_relation`='$contact_person_relation',`contact_person_name`='$contact_person_name' WHERE `id`='$id'";    
    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating student contact details:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
    public function updateStudentEmailId($enrollment_no,$email)
    {

       $sql="UPDATE `tm_student_admission` SET `email_id` = '$email' WHERE `student_enrollment_no`='$enrollment_no'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating student email details:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

   public function updateSpecialFee($staff_id,$student_id,$class_id,$session_id,$fee_id,$fee_value,$fee_value_old,$school_code)
    {
        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();


        $sql="UPDATE `tm_fee_special_case` SET `fee_value` = '$fee_value'  WHERE `student_id`='$student_id' AND `class_id`='$class_id' AND `session_id`='$session_id' AND `fee_id`='$fee_id' AND `school_code`='$school_code'";  
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating special fee:'.mysqli_error($this->conn));  
           if(mysqli_affected_rows($this->conn)>0)   
            {
            
               $change_text="Fee value of class ".$common->getClassName($class_id,$session_id,$school_code)."  of student ".$common->getStudentName($student_id)."(".$student_id. ") changed from ".$fee_value_old." to ".$fee_value.' By Staff '.$get->getStaffName($staff_id);

                $changing_field="fee_value";
                $field_value=$fee_value_old;
                $new_field_value=$fee_value;



                $set->AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);
                return true;
            }
            else{
        
                $sql="INSERT INTO `tm_fee_special_case` (`id`,`school_code`, `student_id`, `class_id`, `session_id`, `fee_id`, `fee_value`, `date_added`, `status`) 
                VALUES (NULL,'$school_code', '$student_id', '$class_id', '$session_id', '$fee_id', '$fee_value', CURRENT_TIMESTAMP, 'Active')";

                $result2=mysqli_query($this->conn,$sql)or die ('Error in updating special fee:'.mysqli_error($this->conn));

                if($result2)
                {

                  $change_text="Special case of student ".$common->getStudentName($student_id)."(".$student_id. ") of class ".$common->getClassName($class_id,$session_id,$school_code)." created with fee value from ".$fee_value_old." to ".$fee_value.' By Staff '.$get->getStaffName($staff_id);

                $changing_field="fee_value";
                $field_value=$fee_value_old;
                $new_field_value=$fee_value;



                $set->AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);
                }

                return $result2;


            }
    }

    public function updateStudentNotice($notice_id,$status,$school_code)
    {

       $sql="UPDATE `tm_notice_board` SET `status` = '$status' WHERE `notice_id`='$notice_id' AND `school_code`='$school_code'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating student notice status:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }


    public function updateAccessoriesStock($stock_id,$product_id,$quantity,$TAG_SOLD)
    {

        if($TAG_SOLD=="SOLD")
        {
            $sql="UPDATE `tm_accessories_stock` SET `quantity_sold_out` = `quantity_sold_out`+'$quantity',`quantity_in_stock`=`quantity_in_stock`-'$quantity' WHERE `product_id`='$product_id' AND `stock_id`='$stock_id'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating saccessories stock:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {

                $sql="SELECT SUM(`quantity_in_stock`) AS total_stock FROM `tm_accessories_stock` WHERE `product_id`='$product_id'";
               $result2=mysqli_query($this->conn,$sql)or die ('Error in getting  accessories in sell stock: '.mysqli_error($this->conn));
                                     
                while ($row = $result2->fetch_assoc()) {
                    $data[] = $row;
                }
                $total_stock=$data[0]['total_stock'];
                if($result2)
                {
                    $sql="UPDATE `tm_accessories_product` SET `in_stock` = '$total_stock' WHERE `product_id`='$product_id'";    
                   $result3=mysqli_query($this->conn,$sql)or die ('Error in updating product stock:'.mysqli_error($this->conn));
                  if(mysqli_affected_rows($this->conn)>0)   
                  {
            
                    return true;
                  }
                  else{
            
                    return false;
                  }
                }
                else{
                   return false; 
                }


            }
            else{
            
                return false;
            }
        }
       
           
    }

public function UpdateHolidayStatus($session_id,$school_code)
{
    $today = date('Y-m-d');

    $sql="UPDATE `tm_holiday_list` SET `status` = 'Over' WHERE `end_holiday_date`<'$today'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating holiday status:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }

}
 function updateSchoolLogo($school_code,$img_dir_toupload)
    {
         $sql="UPDATE `tm_school_details` SET `school_logo_path` = '$img_dir_toupload' WHERE `school_code` ='$school_code'";

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating school logo:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {           
                return true;
            }
            else{
            
                return false;
            }
    }
    function updateSchoolDetails($school_name,$contact1,$contact2,$address,$registration_no,$established_year,$tagline,$email,$website,$school_code)
    {
         $school_name=addcslashes($school_name, "'");
         $address=addcslashes($address, "'");
         $tagline=addcslashes($tagline, "'");
         
        $UPDATE_TRUE=false;

         $sql="UPDATE `tm_school_details` SET `school_tag_line`='$tagline',`school_estb_year`='$established_year',`school_reg_no`='$registration_no',`officail_contact_no1`='$contact1',`officail_contact_no2`='$contact2',`officail_email`='$email',`website`='$website' WHERE `school_code`='$school_code'";

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating school details:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {           
                
                 $UPDATE_TRUE=true;

                 $sql2="UPDATE `tm_school_master` SET `school_name` ='$school_name',`school_address` = '$address' WHERE `school_code`='$school_code'";

                  $result2=mysqli_query($this->conn,$sql2)or die ('Error in updating school details:'.mysqli_error($this->conn));

                  return $UPDATE_TRUE;
            }
            else{

                $sql2="UPDATE `tm_school_master` SET `school_name` ='$school_name',`school_address` = '$address' WHERE `school_code`='$school_code'";

                  $result2=mysqli_query($this->conn,$sql2)or die ('Error in updating school details:'.mysqli_error($this->conn));
                if(mysqli_affected_rows($this->conn)>0)   
                  { 
                     $UPDATE_TRUE=true;
                  }
                  else{
                     $UPDATE_TRUE=false;
                  }

                  return $UPDATE_TRUE;
            }
    }



     public function updateAllStudentSectionShift($staff_id,$existing_section_id,$new_section_id,$class_id,$session_id,$school_code)
    {

       
        $sql="SELECT `student_enrollment_no` FROM `tm_student_class` WHERE `session_id`='$session_id' AND `class_id`='$class_id' AND `section_id`='$existing_section_id' AND `school_code`='$school_code'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  student: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        $student_enrollment_no=$row['student_enrollment_no'];
                        $this->updateStudentSectionShift($staff_id,$student_enrollment_no,$existing_section_id,$new_section_id,$class_id,$session_id,$school_code);
                        $data[] = $row;
                 }
        
           
     }
    public function updateStudentSection($staff_id,$existing_section_id,$new_section_id,$class_id,$student_list,$school_code)
    {

       
       $set=new setFunctions();
       $session_id=$set->getCurrentSession($school_code);

        $arrStudents= json_decode($student_list, TRUE);
        for ($i=0; $i <count($arrStudents) ; $i++) { 
            $student_enrollment_no=$arrStudents[$i]['student_enrollment_no'];
            $flag=$this->updateStudentSectionShift($staff_id,$student_enrollment_no,$existing_section_id,$new_section_id,$class_id,$session_id,$school_code);

        }
        return $flag;
        
           
     }

    public function updateStudentSectionShift($staff_id,$student_enrollment_no,$existing_section_id,$new_section_id,$class_id,$session_id,$school_code)
    {

        $set=new setFunctions();
        $FLAG=false;
       
        $dependent_table=$this->getSectionShiftDependentTables();
        for ($i=0; $i <count($dependent_table) ; $i++) { 
            $table_name=$dependent_table[$i]['table_name'];
            $student_uniqe_id=$dependent_table[$i]['student_uniqe_id'];

            if($table_name!='tm_fee_special_case')
            {

              $sql="UPDATE $table_name SET `section_id` = '$new_section_id' WHERE `class_id`='$class_id' AND `section_id`='$existing_section_id' AND `session_id`='$session_id' AND $student_uniqe_id='$student_enrollment_no'";   

            }
    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating student section shift :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                $FLAG=true;
            }
        }
        if($FLAG)
        {
             $set->AddClassChangeLogs($staff_id,$student_enrollment_no,$class_id,$existing_section_id,$class_id,$new_section_id,$session_id,$school_code);
        }

        return $FLAG;      
           
     }

    public function updateClassChange($staff_id,$existing_class_id,$existing_section_id,$new_class_id,$new_section_id,$student_list,$session_id,$school_code)
    {

   
        $arrStudents= json_decode($student_list, TRUE);
        for ($i=0; $i <count($arrStudents) ; $i++) { 

            $student_enrollment_no=$arrStudents[$i]['student_enrollment_no'];
            $flag=$this->updateStudentClassChange($staff_id,$student_enrollment_no,$existing_class_id,$existing_section_id,$new_class_id,$new_section_id,$session_id,$school_code);

        }
        return $flag;
        
           
     }

    public function updateStudentClassChange($staff_id,$student_enrollment_no,$existing_class_id,$existing_section_id,$new_class_id,$new_section_id,$session_id,$school_code)
    {


        $set=new setFunctions();
        $FLAG=false;
       
        $dependent_table=$this->getSectionShiftDependentTables();
        for ($i=0; $i <count($dependent_table) ; $i++) { 
            $table_name=$dependent_table[$i]['table_name'];
            $student_uniqe_id=$dependent_table[$i]['student_uniqe_id'];

            if($table_name=='tm_fee_special_case')
            {
                 $sql="UPDATE $table_name SET `class_id` = '$new_class_id' WHERE `class_id`='$existing_class_id'  AND `session_id`='$session_id' AND $student_uniqe_id='$student_enrollment_no'"; 
            }
            else{
                 $sql="UPDATE $table_name SET `class_id` = '$new_class_id',`section_id` = '$new_section_id' WHERE `class_id`='$existing_class_id' AND `section_id`='$existing_section_id' AND `session_id`='$session_id' AND $student_uniqe_id='$student_enrollment_no'"; 
            }

 
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating student class change :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                $FLAG=true;

                
            }
        }
        if($FLAG)
        {
             $set->AddClassChangeLogs($staff_id,$student_enrollment_no,$existing_class_id,$existing_section_id,$new_class_id,$new_section_id,$session_id,$school_code);
        }

        return $FLAG;      
           
     }
    public function getSectionShiftDependentTables()
    {
     
        $sql="SELECT `table_name`,`student_uniqe_id` FROM `tm_dependent_section_shift` WHERE `status`='Active'";
     
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  dependent table: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {
                        
                        $data[] = $row;
                 }
        
          return $data; 
     }




      public function updateClassTeacher($class_id,$section_id,$session_id,$staff_id,$school_code)
    {
        if($section_id=="null")
        {
            $section_id="No";
        }

        $sql="SELECT * FROM `tm_class_teacher` WHERE `class_id`='$class_id'  AND `section_id`='$section_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";  
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating class teacher:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                 $sql="UPDATE `tm_class_teacher` SET `class_teacher_id`='$staff_id' WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";  
                  $result=mysqli_query($this->conn,$sql)or die ('Error in updating class teacher2:'.mysqli_error($this->conn));  
                if(mysqli_affected_rows($this->conn)>0)   
                {
                        return true;
                }
                else{
                    return false;
                }

                
        }
        else{
        
                $sql="INSERT INTO `tm_class_teacher` (`id`, `school_code`,`class_id`, `section_id`, `session_id`, `class_teacher_id`, `date`, `status`) 
                VALUES (NULL, '$school_code','$class_id', '$section_id', '$session_id', '$staff_id', CURRENT_TIMESTAMP, 'Active')";


                $result2=mysqli_query($this->conn,$sql)or die ('Error in updating class teacher3:'.mysqli_error($this->conn));
                 return $result2;


            }
            
    }


    public function updateClassRollNumber($staff_id,$class_id,$section_id,$session_id,$student_list,$school_code)
    {
        $arrStudents = json_decode($student_list, TRUE);
        for ($i=0; $i <count($arrStudents) ; $i++) { 
            $student_enrollment_no=$arrStudents[$i]['student_enrollment_no'];
            $student_roll_no=$arrStudents[$i]['student_roll_no'];
            $new_roll_no=$arrStudents[$i]['new_roll_no'];
            $flag=$this->updateStudentRollNumber($staff_id,$student_enrollment_no,$new_roll_no,$student_roll_no,$class_id,$section_id,$session_id,$school_code);

        }
        return $flag;
        
           
     }

     public function updateStudentRollNumber($staff_id,$student_enrollment_no,$student_roll_no,$student_roll_no_old,$class_id,$section_id,$session_id,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
         $get=new getFunctions();
        $FLAG=false;
       
        $sql="UPDATE `tm_student_class` SET `student_roll_no` = '$student_roll_no' WHERE `student_enrollment_no`='$student_enrollment_no' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id'  AND `school_code`='$school_code'";    
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating student rool number :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                $FLAG=true;
            }
            if($FLAG)
            {

                $change_text="Roll Number of class ".$common->getClassName($class_id,$session_id,$school_code)."  of student ".$common->getStudentName($student_enrollment_no)."(".$student_enrollment_no. ") changed from ".$student_roll_no_old." to ".$student_roll_no.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="student_roll_no";
                $field_value=$student_roll_no_old;
                $new_field_value=$student_roll_no;



                $set->AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);
            }

        return $FLAG;

        
           
     }

    public function updateSettlementRequest($request_id,$student_id,$class_id,$section_id,$staff_id,$fee_id,$applicable_month,$amount,$settlement_status,$school_code)
    {

        $FLAG=false;
       
        $sql="UPDATE `tm_fee_due_settlement_request` SET `settlement_status` = '$settlement_status',`approved_by`='$staff_id' WHERE `settlement_request_id`='$request_id' AND `student_id`='$student_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `fee_id`='$fee_id' AND `applicable_month`='$applicable_month' AND `due_amount`='$amount' AND `school_code`='$school_code'";  
         
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating settlement request :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                $FLAG=true;
            }

        return $FLAG;

        
           
     }

   
    public function updateClassFee($staff_id,$class_id,$session_id,$fee_id,$is_special_fee,$fee_value_old,$fee_value,$fee_value_readmission_old,$fee_value_readmission,$applicable_month,$mode_id,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();

        $FLAG_UPDATE=false;
      

        $sql="UPDATE `tm_class_fee` SET `fee_value` = '$fee_value' ,`applicable_month`='$applicable_month',`mode_id`='$mode_id' WHERE  `class_id`='$class_id' AND `session_id`='$session_id' AND `fee_id`='$fee_id' AND `school_code`='$school_code'";  
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating class  fee:'.mysqli_error($this->conn));  
           if(mysqli_affected_rows($this->conn)>0)   
            {


                $FLAG_UPDATE=true;

                 $change_text="Fee value of class ".$common->getClassName($class_id,$session_id,$school_code)." changed from ".$fee_value_old." to ".$fee_value.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="fee_value";
                $field_value=$fee_value_old;
                $new_field_value=$fee_value;


                $set->AddChangeLogs($staff_id,$student_id,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);

                
            }
            else{
        
               $FLAG_UPDATE=false;


            }
        if($is_special_fee=='1')
        {

            $sql="UPDATE `tm_fee_registration_existing_student` SET `fee_value` = '$fee_value_readmission' ,`applicable_month`='$applicable_month',`mode_id`='$mode_id' WHERE  `class_id`='$class_id' AND `session_id`='$session_id' AND `fee_id`='$fee_id' AND `school_code`='$school_code'";
        
            
            $result2=mysqli_query($this->conn,$sql)or die ('Error in updating fee in  class :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            

                $FLAG_UPDATE=true;
                 $change_text="Fee value of readmission student of class ".$common->getClassName($class_id,$session_id,$school_code)." changed from ".$fee_value_readmission_old." to ".$fee_value_readmission.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="fee_value";
                $field_value=$fee_value_readmission_old;
                $new_field_value=$fee_value_readmission;


                $set->AddChangeLogs($staff_id,$student_id,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);

            }
            else{
        
                if(!$FLAG_UPDATE)
                {
                    $FLAG_UPDATE=false;
                }
               
            }
        } 
        return $FLAG_UPDATE;   
    }

    public function updateStaffQualification($id,$qualification,$university,$passing_year,$percentage)
    {

       $sql="UPDATE `tm_staff_education` SET `staff_university` = '$university',`staff_degree`='$qualification',`staff_passing_year`='$passing_year', `staff_percentage`='$percentage' WHERE `id` ='$id'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff qualification:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

    public function updateStudentSrAdmissionNo($staff_id,$student_enrollment_no,$sr_admission_no,$admission_no_old,$session_id,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();
        $FLAG=false;
       
       
        $sql="UPDATE `tm_student_admission` SET `sr_admission_no`='$sr_admission_no' WHERE `student_enrollment_no`='$student_enrollment_no' AND `school_code`='$school_code'";  
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating student sr admision_no :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
                $FLAG=true;
            }
             if($FLAG)
            {

                 $change_text="Admission Number of student ".$common->getStudentName($student_enrollment_no)."(".$student_enrollment_no.") changed from ".$admission_no_old." to ".$sr_admission_no.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="sr_admission_no";
                $field_value=$admission_no_old;
                $new_field_value=$sr_admission_no;



                $set->AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);
            }

        return $FLAG;
           
     }

    public function updateStudentAttendance($enrollment_no,$class_id,$section_id,$session_id,$attendance_date,$attendance,$school_code)
    {

       
        $sql="UPDATE `tm_student_attendence` SET `attendence` = '$attendance' WHERE `student_enrollment_no`='$enrollment_no' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `attendence_date`='$attendance_date' AND `school_code`='$school_code'";  
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating student attendance :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
                return true;
            }
            else{
            
                return false;
            }

        
           
     }

    public function updateStudentAttendanceReport($staff_id,$attendance_report,$school_code)
    {
         $FLAG_UPDATE=false;
         $arr_attendance_report= json_decode($attendance_report, TRUE);
         for ($i=0; $i <count($arr_attendance_report) ; $i++) {

                $student_id=$arr_attendance_report[$i]['student_id'] ;
                $class_id=$arr_attendance_report[$i]['class_id'] ;
                $section_id=$arr_attendance_report[$i]['section_id'] ;
                $session_id=$arr_attendance_report[$i]['session_id'] ;
                $month=$arr_attendance_report[$i]['month'] ;
                $working_days=$arr_attendance_report[$i]['working_days'] ;
                $present=$arr_attendance_report[$i]['present'] ;

                $this->AddWorkingDaysAttendanceReport($staff_id,$month,$session_id,$working_days,$school_code);



             $sql="UPDATE `tm_student_attendance_report` SET `working_days` = '$working_days',`present`='$present',`staff_id`='$staff_id' WHERE `student_id`='$student_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `month`='$month' AND `school_code`='$school_code'";  
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating student attendance report :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
               $FLAG_UPDATE=true;
            }
           
        }
        return $FLAG_UPDATE;
        
           
     }

      public function updateClassWorkingDaysAttendanceReport($staff_id,$month,$class_id,$section_id,$session_id,$working_days,$school_code)
    {
         $FLAG_UPDATE=false;
         
        $sql="UPDATE `tm_student_attendance_report` SET `working_days` = '$working_days' WHERE  `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `month`='$month' AND `school_code`='$school_code'";  
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in updating working days attendance report :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
               $FLAG_UPDATE=true;
            }
           return $FLAG_UPDATE;
        
           
     }

    public function AddWorkingDaysAttendanceReport($staff_id,$month,$session_id,$working_days,$school_code)
    {
         $FLAG_UPDATE=false;
         
        $sql="UPDATE `tm_student_attendance_report` SET `working_days` = '$working_days' WHERE `session_id`='$session_id' AND `month`='$month' AND `school_code`='$school_code'";  
    
              $result=mysqli_query($this->conn,$sql)or die ('Error in adding working days attendance report :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
               $FLAG_UPDATE=true;
            }
           return $FLAG_UPDATE;
        
           
     }

    public function updateExamStatus($exam_id,$status,$school_code)
    {

       $sql="UPDATE `tm_exam_master` SET `status` = '$status' WHERE `exam_id`='$exam_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating exam status:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }


    public function updateFileAttachmentDetails($attachment_id,$topic,$description,$school_code)
    {

       $sql="UPDATE `tm_attachment_documents` SET `topic` = '$topic',`description` = '$description' WHERE `attachment_id`='$attachment_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating file attachment:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

     public function updateSubjectName($subject_id,$subject_name,$school_code)
    {

       $sql="UPDATE `tm_subject` SET `subject_name` ='$subject_name' WHERE `subject_id` ='$subject_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating subject name:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

     public function updateHomeworkSolution($student_id,$session_id,$class_id,$section_id,$subject_id,$homework_date,$homework_id,$homework_solution,$homework_solution_img,$document_name,$remark,$school_code)
    {

        $common=new Common();  
        $sql="UPDATE `tm_class_homework_solution` SET `homework_solution_img` = '$homework_solution_img',`document_name` = '$document_name' WHERE `homework_id`='$homework_id' AND  `school_code`='$school_code'";  

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating homework solution:'.mysqli_error($this->conn));  
           if(mysqli_affected_rows($this->conn)>0)   
            {
 
        
                return true;
            }
            else{
                  

                 $table='tm_class_homework_solution';
                 $col_id='solution_id';
                 $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
                 $solution_id='SLN'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
        
                $sql="INSERT INTO `tm_class_homework_solution` (`id`, `school_code`,`student_id`,`session_id`,`class_id`,`section_id`,`subject_id`,`homework_date`, `solution_id`, `homework_id`, `homework_solution`, `homework_solution_img`,`document_name`, `remark`, `date_added`, `status`) 
                VALUES (NULL, '$school_code','$student_id','$session_id','$class_id','$section_id','$subject_id','$homework_date', '$solution_id','$homework_id', '$homework_solution ','$homework_solution_img','$document_name' ,'$remark', CURRENT_TIMESTAMP, 'Active')";
                
                $result2=mysqli_query($this->conn,$sql)or die ('Error in adding  homework solution :'.mysqli_error($this->conn));
                 return $result2;


            }
    }
    public function updateAttachmentExerciseSolution($student_id,$session_id,$class_id,$section_id,$attachment_id,$exercise_id,$solution,$img_dir_toupload,$document_name,$remark,$school_code)
    {

        $common=new Common();  
        $sql="UPDATE `tm_attachment_solution` SET `solution_img` = '$img_dir_toupload',`document_name` = '$document_name' WHERE `exercise_id`='$exercise_id' AND  `school_code`='$school_code'";  

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating exercise solution:'.mysqli_error($this->conn));  
           if(mysqli_affected_rows($this->conn)>0)   
            {
 
        
                return true;
            }
            else{
                  

                 $table='tm_attachment_solution';
                 $col_id='solution_id';
                 $UniqueId=$common->getUniqueId_No_Hyphen($table,$col_id);
                 $solution_id='SLN'.str_pad($UniqueId, 4,'0',STR_PAD_LEFT);
        
                $sql="INSERT INTO `tm_attachment_solution` (`id`, `school_code`, `student_id`, `session_id`, `class_id`, `section_id`, `solution_id`, `attachment_id`, `exercise_id`, `solution`, `solution_img`, `document_name`, `remark`, `date_added`, `status`)
                 VALUES (NULL, '$school_code', '$student_id', '$session_id', '$class_id', '$section_id', '$solution_id', '$attachment_id', '$exercise_id', '$solution', '$img_dir_toupload', '$document_name', '$remark', CURRENT_TIMESTAMP, 'Active')";
                
                $result2=mysqli_query($this->conn,$sql)or die ('Error in adding  attachment exercise solution :'.mysqli_error($this->conn));
                 return $result2;


            }
    }
 public function updateNotice($notice_id,$notice,$order_by,$staff_id,$school_code)
    {

       $sql="UPDATE `tm_notice_board` SET `notice` = '$notice',`ordered_by`='$order_by' WHERE `notice_id`='$notice_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating notice:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
    public function updateFeeReceiptSetting($setting_id,$status,$school_code)
    {

       $sql="UPDATE `tm_fee_receipt_settings` SET `setting_value` = '$status' WHERE `setting_id`='$setting_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating fee receipt setting:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
    

    public function updateStaffRole($staff_role,$staff_id)
    {
       $sql="UPDATE `tm_staff_master` SET `staff_role` = '$staff_role' WHERE `staff_id`='$staff_id'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff role:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
     public function updateStaffLoginType($login_type,$staff_id)
    {

       $sql="UPDATE `tm_staff_master` SET `login_type` = '$login_type' WHERE `staff_id`='$staff_id'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating staff login type:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
    public function makeCurrentSession($session_id,$school_code)
    {

        $get=new getFunctions();

        $today=date('Y-m-d');
        //echo $today;
        $start_date=$get->getSessionStartDate($session_id,$school_code);
        if($today>=$start_date)
        {

            $sql="UPDATE `tm_session` SET `status` = 'Current' WHERE `session_id`='$session_id' AND `school_code`='$school_code' ";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating current session :'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
                $previousSession=$get->getPreviousSession($school_code);
                $previous_session_id=$previousSession[0]['session_id'];
                $sql2="UPDATE `tm_session` SET `status` = 'Previous' WHERE `session_id`='$previous_session_id' AND `school_code`='$school_code' ";    
               $result2=mysqli_query($this->conn,$sql2)or die ('Error in updating previous session :'.mysqli_error($this->conn));

            
                return $result2;
            }
            else{
            
                return false;
            }
        }
        else{
            return false;
        }
       

      
           
    }

    public function updateStudentStatus($student_id,$class_id,$section_id,$session_id,$status,$school_code)
    {

       $sql="UPDATE `tm_student_class` SET `status` = '$status' WHERE `student_enrollment_no`='$student_id' AND `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `school_code`='$school_code'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating student  status:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
    public function updateStudentDelistedStatus($student_id,$status,$school_code)
    {

       $sql="UPDATE `tm_student_admission` SET `status` = '$status' WHERE `student_enrollment_no`='$student_id' AND `school_code`='$school_code'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating student  status:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

    public function updateDeleteSuccess($delete_log_id,$school_code)
    {

       $sql="UPDATE `tm_log_delete` SET `delete_success` = '1' WHERE `delete_log_id`='$delete_log_id' AND `school_code`='$school_code'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating delete success:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }
      public function updateBackupSuccess($delete_log_id,$school_code)
    {

       $sql="UPDATE `tm_log_delete` SET `backup_success` = '1' WHERE `delete_log_id`='$delete_log_id' AND `school_code`='$school_code'";    
        $result=mysqli_query($this->conn,$sql)or die ('Error in updating backup success:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
            
                return false;
            }
           
    }

    public function updateDayBookEntryAmount($staff_id,$session_id,$entry_id,$amount,$amount_old,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();

        $sql="UPDATE `tm_daybook_entry` SET `amount` = '$amount' WHERE `entry_id`='$entry_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating day book entry amount:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            

                 $change_text="DayBook entry amount changed from ".$amount_old." to ".$amount.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="amount";
                $field_value=$amount_old;
                $new_field_value=$amount;


                $set->AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);

                return true;
            }
            else{
            
                return false;
            }
           
    }
     public function updateDayBookEntryDate($staff_id,$session_id,$entry_id,$entry_date,$entry_date_old,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();

       

        $sql="UPDATE `tm_daybook_entry` SET `entry_date` = '$entry_date' WHERE `entry_id`='$entry_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating day book entry date:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            

                 $change_text="DayBook entry date changed from ".$entry_date_old." to ".$entry_date.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="entry_date";
                $field_value=$amount_old;
                $new_field_value=$amount;


                $set->AddChangeLogs($staff_id,$student_enrollment_no,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);

                return true;
            }
            else{
            
                return false;
            }
           
    }

    public function updateTransactionDate($staff_id,$student_id,$session_id,$transaction_id,$transaction_date,$transaction_date_old,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();

       

            $sql="UPDATE `tm_transaction_master` SET `transaction_date` = '$transaction_date' WHERE `transaction_id`='$transaction_id' AND `school_code`='$school_code'";    
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating day book entry date:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            

                $change_text="Transaction date of tansaction_id ".$transaction_id." changed from ".$transaction_date_old." to ".$transaction_date.' By Staff '.$get->getStaffName($staff_id);
                $changing_field="transaction_date";
                $field_value=$transaction_date_old;
                $new_field_value=$transaction_date;


                $set->AddChangeLogs($staff_id,$student_id,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);

                return true;
            }
            else{
            
                return false;
            }
           
    }
     public function updateTransportServiceMonthFee($staff_id,$service_id,$service_fee,$net_service_fee_old,$net_service_fee_new,$student_id,$session_id,$service_month,$school_code)
    {
        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();
        if($net_service_fee_new<=$service_fee)
        {
             $discount=$service_fee-$net_service_fee_new;
             $sql="UPDATE `tm_student_services_fee` SET `net_service_fee` = '$net_service_fee_new',`discount` = '$discount',`is_discount_granted` = '1' WHERE `student_id`='$student_id' AND `session_id`='$session_id' AND `service_id`='$service_id' AND `applicable_month`='$service_month' AND `school_code`='$school_code'"; 
        }
        else{
            $sql="UPDATE `tm_student_services_fee` SET `net_service_fee` = '$net_service_fee_new' WHERE `student_id`='$student_id' AND `session_id`='$session_id' AND `service_id`='$service_id' AND `applicable_month`='$service_month' AND `school_code`='$school_code'"; 
        }

          
            $result=mysqli_query($this->conn,$sql)or die ('Error in updating transport service month fee:'.mysqli_error($this->conn));
            if(mysqli_affected_rows($this->conn)>0)   
            {
            
                if($service_id="SRV001")
                {
                    $change_text="Transport service fee of month ".$service_month." of student ".$get->getStudentName($student_id)." changed from ".$net_service_fee_old." to ".$net_service_fee_new.' By Staff '.$get->getStaffName($staff_id);
                }
                else if($service_id="SRV002")
                {
                    $change_text="Hostal service fee of month ".$service_month." of student ".$get->getStudentName($student_id)." changed from ".$net_service_fee_old." to ".$net_service_fee_new.' By Staff '.$get->getStaffName($staff_id);
                }
                

                $changing_field="net_service_fee";
                $field_value=$net_service_fee_old;
                $new_field_value=$net_service_fee_new;


                $set->AddChangeLogs($staff_id,$student_id,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);

                return true;
            }
            else{
            
                return false;
            }
           
    }


    public function updateStudentReportCardRemark($staff_id,$student_id,$report_card_id,$session_id,$class_id,$section_id,$remark,$remark_old,$school_code)
    {

        $set=new setFunctions();
        $common=new Common();
        $get=new getFunctions();

        $sql="UPDATE `tm_exam_reportcard_student_remark` SET `remark` = '$remark' WHERE `report_card_id`='$report_card_id' AND  `student_id`='$student_id' AND  `school_code`='$school_code'";  

        $result=mysqli_query($this->conn,$sql)or die ('Error in updating student reportcard remark :'.mysqli_error($this->conn));  
           if(mysqli_affected_rows($this->conn)>0)   
            {
 
                $change_text="Remark of report card of student ".$get->getStudentName($student_id)." changed from ".$remark_old." to ".$remark.' By Staff '.$get->getStaffName($staff_id);

                $changing_field="remark";
                $field_value=$remark_old;
                $new_field_value=$remark;


                $set->AddChangeLogs($staff_id,$student_id,$change_text,$changing_field,$field_value,$new_field_value,$session_id,$school_code);
                return true;
            }
            else{
                  
        
                $sql="INSERT INTO `tm_exam_reportcard_student_remark` (`id`, `school_code`, `report_card_id`, `student_id`, `session_id`, `class_id`, `section_id`, `remark`, `status`, `date_added`) 
                 VALUES (NULL, '$school_code', '$report_card_id', '$student_id', '$session_id', '$class_id', '$section_id', '$remark', 'Active', CURRENT_TIMESTAMP)";
                
                $result2=mysqli_query($this->conn,$sql)or die ('Error in adding  student report card remark :'.mysqli_error($this->conn));
                 return $result2;


            }
    }
    
   
}
?>