<?php

 date_default_timezone_set('Asia/Kolkata');
 class DelFunctions{
  
    private $conn;     
    // constructor
    function __construct() {
        require_once 'DB_Connect.php';
        require_once 'Automation.php';
        require_once ('Common.php');
        require_once 'getFunctions.php';
        require_once 'setFunctions.php';
        require_once 'updateFunctions.php';
       
        $db = new Db_Connect();
        $this->conn = $db->connect();
        mysqli_set_charset($this->conn,'utf8'); 
       
    }


    public function deleteStudentNotice($notice_id,$school_code)
    {

        $sql="DELETE FROM `tm_notice_board` WHERE `notice_id` ='$notice_id' AND `school_code` ='$school_code'";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in deleting student notice:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
        
                return false;

            }
    }
    public function deleteStaffQualification($school_code,$id)
    {

        $sql="DELETE FROM `tm_staff_education` WHERE `id` ='$id' AND `school_code` ='$school_code'";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in deleting staff qualification:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
        
                return false;

            }
    }
    public function deleteClassAttendance($school_code,$class_id,$section_id,$session_id,$attendance_date)
    {

        $sql="DELETE FROM `tm_student_attendence` WHERE  `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `attendence_date`='$attendance_date' AND `school_code`='$school_code'";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in deleting class attendance:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
        
                return false;

            }
    }
    public function deleteClassFee($school_code,$class_id,$section_id,$session_id,$fee_id)
    {

        $sql="DELETE FROM `tm_class_fee` WHERE  `class_id`='$class_id'  AND `session_id`='$session_id' AND `fee_id`='$fee_id' AND `school_code`='$school_code'";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in deleting class fee:'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                //$this->deleteClassFeeTransaction($school_code,$class_id,$section_id,$session_id,$fee_id);
                $this->deleteClassSpecialFee($school_code,$class_id,$session_id,$fee_id);
                return true;
            }
            else{
        
                return false;

            }
    }
    public function deleteClassFeeTransaction($school_code,$class_id,$section_id,$session_id,$fee_id)
    {


         $sql="SELECT `school_code`,`transaction_id` FROM `tm_fee_payment` WHERE `class_id`='$class_id' AND `section_id`='$section_id' AND `session_id`='$session_id' AND `fee_id`='$fee_id'";
         $result=mysqli_query($this->conn,$sql)or die ('Error in getting  fee payment: '.mysqli_error($this->conn));
                 
                 while ($row = $result->fetch_assoc()) {                     
                        $transaction_id=$row['transaction_id'];
                        //$this->deleteFeeTransaction($school_code,$transaction_id);
                        $data[] = $row;
                 }

    
    }
    public function deleteTransaction($staff_id,$transaction_amount,$student_id,$transaction_id,$transaction_for,$session_id,$school_code)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

        $delete_text="Transaction amount of Rs:".$transaction_amount." which transaction_id:".$transaction_id." of student ".$common->getStudentName($student_id)." deleted by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $b1=$common->backupTransactionDelete($school_code,$transaction_id,$transaction_for,$delete_log_id);
            if($b1)
            {
                $sql="DELETE FROM `tm_transaction_master` WHERE   `transaction_id`='$transaction_id' AND `school_code`='$school_code'";
        
                $f1=mysqli_query($this->conn,$sql)or die ('Error in deleting  fee transaction:'.mysqli_error($this->conn));
                if(mysqli_affected_rows($this->conn)>0)   
                {
                    
                    $f2=$this->deleteTransactionDetails($school_code,$transaction_id,$transaction_for);
                } 

            }
            
        }

       

        if ($f1 and $f2) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }
    public function deleteTransactionDetails($school_code,$transaction_id,$transaction_for)
    {


        if($transaction_for=='FEE')
        {
            $sql="DELETE FROM `tm_fee_payment` WHERE   `transaction_id`='$transaction_id' AND `school_code`='$school_code'";
    
            $result=mysqli_query($this->conn,$sql)or die ('Error in deleting  fee transaction details:'.mysqli_error($this->conn));  
            if(mysqli_affected_rows($this->conn)>0)   
                {
                
                    return true;
                }
                else{
            
                    return false;

                }
        }
        else if($transaction_for=='OLD_DUE')
        {
            $sql="DELETE FROM `tm_fee_old_due_payment` WHERE   `transaction_id`='$transaction_id' AND `school_code`='$school_code'";
    
            $result=mysqli_query($this->conn,$sql)or die ('Error in deleting  fee transaction details:'.mysqli_error($this->conn));  
            if(mysqli_affected_rows($this->conn)>0)   
                {
                
                    return true;
                }
                else{
            
                    return false;

                }
        }
        else if($transaction_for=='ACCESSORIES')
        {
            $sql="DELETE FROM `tm_accessories_to_student` WHERE   `transaction_id`='$transaction_id' AND `school_code`='$school_code'";
    
            $result=mysqli_query($this->conn,$sql)or die ('Error in deleting  fee transaction details:'.mysqli_error($this->conn));  
            if(mysqli_affected_rows($this->conn)>0)   
                {
                
                    return true;
                }
                else{
            
                    return false;

                }
        }
        
        
    }
     public function deleteClassSpecialFee($school_code,$class_id,$session_id,$fee_id)
    {


        $sql="DELETE FROM `tm_fee_registration_existing_student` WHERE `school_code`='$school_code' AND `session_id`='$session_id' AND `class_id`='$class_id' AND `fee_id`='$fee_id'";
    
        $result=mysqli_query($this->conn,$sql)or die ('Error in deleting  special fee :'.mysqli_error($this->conn));  
        if(mysqli_affected_rows($this->conn)>0)   
            {
            
                return true;
            }
            else{
        
                return false;

            }
    }

     public function deleteDayBookEntry($staff_id,$entry_id,$entry_amount,$entry_date,$session_id,$school_code)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

        $delete_text="DayBook entry amount of Rs:".$entry_amount." and entry date:".$entry_date." deleted by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_daybook_entry';
            $backup_table='tm_backup_daybook_entry';
            $condition= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'entry_id'.'` = '.'\''.$entry_id.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition,$delete_log_id);
            if($b1)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);
                $sql="DELETE FROM `tm_daybook_entry` WHERE `entry_id`='$entry_id' AND `school_code`='$school_code'";
        
                $f1=mysqli_query($this->conn,$sql)or die ('Error in deleting  fee day book entry:'.mysqli_error($this->conn));
               
            }
                                      
        }
        if ($f1) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }


public function deleteLiveClass($staff_id,$live_class_id,$session_id,$class_id,$section_id,$subject_id,$topic,$school_code)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

        $delete_text="Live Class of Topic ".$topic." of subject :".$common->getSubjectName($subject_id,$school_code)." of class :".$common->getClassName($class_id,$session_id,$school_code)." deleted by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_school_live_class';
            $backup_table='tm_backup_school_live_class';
            $condition= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'live_class_id'.'` = '.'\''.$live_class_id.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition,$delete_log_id);
            if($b1)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);
                $sql="DELETE FROM `tm_school_live_class` WHERE `live_class_id`='$live_class_id' AND `school_code`='$school_code'";
        
                $f1=mysqli_query($this->conn,$sql)or die ('Error in deleting  live class:'.mysqli_error($this->conn));
               
            }
                                      
        }
        if ($f1) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }

    public function deleteExamDateSheet($staff_id,$datesheet_id,$exam_id,$school_code)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

        $exam_name=$common->getExamName($exam_id,$school_code);
        $delete_text="A DateSheet of exam : ".$exam_name." deleted by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_exam_datesheet';
            $backup_table='tm_backup_exam_datesheet';
            $condition= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'datesheet_id'.'` = '.'\''.$datesheet_id.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition,$delete_log_id);
            if($b1)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);
                $sql="DELETE FROM `tm_exam_datesheet` WHERE `datesheet_id`='$datesheet_id' AND `school_code`='$school_code'";
        
                $f1=mysqli_query($this->conn,$sql)or die ('Error in deleting  exam date sheet:'.mysqli_error($this->conn));
               
            }
                                      
        }
        if ($f1) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }


     public function deleteExamGuideline($staff_id,$guideline_id,$exam_id,$school_code)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

        $exam_name=$common->getExamName($exam_id,$school_code);
        $delete_text="A Guideline of exam : ".$exam_name." deleted by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_exam_guideline';
            $backup_table='tm_backup_exam_guideline';
            $condition= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'guideline_id'.'` = '.'\''.$guideline_id.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition,$delete_log_id);
            if($b1)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);
                $sql="DELETE FROM `tm_exam_guideline` WHERE `guideline_id`='$guideline_id' AND `school_code`='$school_code'";
        
                $f1=mysqli_query($this->conn,$sql)or die ('Error in deleting  exam duideline:'.mysqli_error($this->conn));
               
            }
                                      
        }
        if ($f1) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }

    
     public function removeTransportServiceMonth($staff_id,$applicable_month,$student_id,$class_id,$section_id,$session_id,$service_id,$school_code)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

        if($service_id="SRV001")
        {
             $delete_text="Transport service of month ".$applicable_month." of student ".$common->getStudentName($student_id)." removed by staff ".$get->getStaffName($staff_id);

        }
        else if($service_id="SRV002")
        {
            $delete_text="Hostal service of month ".$applicable_month." of student ".$common->getStudentName($student_id)." removed by staff ".$get->getStaffName($staff_id);
        }
       
        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_student_services_fee';
            $backup_table='tm_backup_student_services_fee';
            $condition= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'service_id'.'` = '.'\''.$service_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\''.' AND '.'`'.'applicable_month'.'` = '.'\''.$applicable_month.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition,$delete_log_id);
            if($b1)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);
                $sql="DELETE FROM `tm_student_services_fee` WHERE $condition";
        
                $f1=mysqli_query($this->conn,$sql)or die ('Error in removing  service month:'.mysqli_error($this->conn));
               
            }
                                      
        }
        if ($f1) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }

    public function deleteTransportStudent($school_code,$session_id,$student_id,$service_id,$staff_id)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();


        $delete_text="Transport service of student ".$common->getStudentName($student_id)." removed by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_student_services_fee';
            $backup_table='tm_backup_student_services_fee';
            $condition1= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'service_id'.'` = '.'\''.$service_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition1,$delete_log_id);
           

            $table='tm_transport_student';
            $backup_table='tm_backup_transport_student';
            $condition2= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\'';
           // echo $condition;
            $b2=$common->backupTableData($school_code,$table,$backup_table,$condition2,$delete_log_id);
            
            $table='tm_student_services';
            $backup_table='tm_backup_student_services';
            $condition3= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\''.' AND '.'`'.'service_id'.'` = '.'\''.$service_id.'\'';
           // echo $condition;
            $b3=$common->backupTableData($school_code,$table,$backup_table,$condition3,$delete_log_id);
            
            if($b1 && $b2 && $b3)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);

                $sql="DELETE FROM `tm_student_services_fee` WHERE $condition1";       
                $f1=mysqli_query($this->conn,$sql)or die ('Error in removing transport service fee:'.mysqli_error($this->conn));
                if($f1)
                {
                    $sql="DELETE FROM `tm_transport_student` WHERE $condition2";       
                    $f2=mysqli_query($this->conn,$sql)or die ('Error in deleting transport student:'.mysqli_error($this->conn));
                    if($f2)
                    {
                        $sql="DELETE FROM `tm_student_services` WHERE $condition3";       
                        $f3=mysqli_query($this->conn,$sql)or die ('Error in deleting transport service:'.mysqli_error($this->conn));
                    }
                }
               
            }
                                      
        }
        if($f1 && $f2 && $f3) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }


    public function deleteHostalStudent($school_code,$session_id,$student_id,$service_id,$staff_id)
    {
        $auto=new Automation();
        $common=new Common();
        $get=new getFunctions();
        $set=new setFunctions();
        $update=new updateFunctions();

    
        $delete_text="Hostal service of student ".$common->getStudentName($student_id)." removed by staff ".$get->getStaffName($staff_id);

        mysqli_query("START TRANSACTION");

        $delete_log_id=$set->AddDeleteLogs($staff_id,$student_id,$delete_text,$session_id,$school_code);
        if($delete_log_id)
        {
            $table='tm_student_services_fee';
            $backup_table='tm_backup_student_services_fee';
            $condition1= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'service_id'.'` = '.'\''.$service_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\'';
           // echo $condition;
            $b1=$common->backupTableData($school_code,$table,$backup_table,$condition1,$delete_log_id);
           

            $table='tm_hostal_student';
            $backup_table='tm_backup_hostal_student';
            $condition2= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\'';
           // echo $condition;
            $b2=$common->backupTableData($school_code,$table,$backup_table,$condition2,$delete_log_id);
            
            $table='tm_student_services';
            $backup_table='tm_backup_student_services';
            $condition3= '`'.'school_code'.'` = '.'\''.$school_code.'\''.' AND '.'`'.'student_id'.'` = '.'\''.$student_id.'\''.' AND '.'`'.'session_id'.'` = '.'\''.$session_id.'\''.' AND '.'`'.'service_id'.'` = '.'\''.$service_id.'\'';
           // echo $condition;
            $b3=$common->backupTableData($school_code,$table,$backup_table,$condition3,$delete_log_id);
            
            if($b1 && $b2 && $b3)
            {
                $update->updateBackupSuccess($delete_log_id,$school_code);

                $sql="DELETE FROM `tm_student_services_fee` WHERE $condition1";       
                $f1=mysqli_query($this->conn,$sql)or die ('Error in removing hostal service fee:'.mysqli_error($this->conn));
                if($f1)
                {
                    $sql="DELETE FROM `tm_hostal_student` WHERE $condition2";       
                    $f2=mysqli_query($this->conn,$sql)or die ('Error in deleting hostal student:'.mysqli_error($this->conn));
                    if($f2)
                    {
                        $sql="DELETE FROM `tm_student_services` WHERE $condition3";       
                        $f3=mysqli_query($this->conn,$sql)or die ('Error in deleting hostal service:'.mysqli_error($this->conn));
                    }
                }
               
            }
                                      
        }
        if($f1 && $f2 && $f3) {
            mysqli_query("COMMIT");

            $update->updateDeleteSuccess($delete_log_id,$school_code);
            $auto->NotifyLogDeleteToAdmin($delete_text,$school_code);
            return true;

        } else {        
            mysqli_query("ROLLBACK");
            return false;
        }

    
    }


   
}
?>